/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.text.Line;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.rubyforge.debugcommons.RubyDebuggerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set<Object> ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public RubyBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void doAction(Object object) {
        RubyBreakpoint rubyBreakpoint = RubyBreakpointManager.getCurrentLineBreakpoint();
        if (rubyBreakpoint != null) {
            RubyBreakpointManager.removeBreakpoint(rubyBreakpoint);
        } else {
            try {
                Line line = EditorUtil.getCurrentLine();
                if (line != null) {
                    RubyBreakpointManager.addBreakpoint(line);
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                Util.LOGGER.log(Level.WARNING, "Unable to add breakpoint.", rubyDebuggerException);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = EditorUtil.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

