/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubyDebuggerEngineProvider;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyDebuggerActionProvider
extends ActionsProviderSupport
implements RubyDebugEventListener {
    private static final Set<Object> ACTIONS;
    private final Semaphore frontEndSemaphore;
    private final Semaphore backEndSemaphore;
    private final ContextProviderWrapper contextProvider;
    private final RubyDebuggerEngineProvider engineProvider;
    private final RubySession rubySession;
    private Boolean terminated;

    public RubyDebuggerActionProvider(ContextProvider contextProvider) {
        this.engineProvider = (RubyDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.frontEndSemaphore = new Semaphore(1, true);
        this.backEndSemaphore = new Semaphore(1, true);
        this.terminated = false;
        boolean bl = this.frontEndSemaphore.tryAcquire();
        assert (bl);
        for (Object object : ACTIONS) {
            this.setEnabled(object, true);
        }
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object object) {
        Util.finest("Performing \"" + object + '\"');
        if (object == ActionsManager.ACTION_KILL) {
            this.finish(true);
            return;
        }
        if (this.frontEndSemaphore.getQueueLength() > 10) {
            Util.info("Too much pending events (> 10). Action \"" + object + "\" is rejected.");
            return;
        }
        try {
            this.frontEndSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            Util.severe(interruptedException);
            return;
        }
        Boolean bl = this.terminated;
        synchronized (bl) {
            if (this.terminated.booleanValue()) {
                Util.info("Flushing cached actions: " + object + ", process is terminated.");
                this.frontEndSemaphore.release();
                return;
            }
        }
        if (object == ActionsManager.ACTION_CONTINUE) {
            this.rubySession.resume();
            this.contextProvider.fireModelChanges();
        } else if (object == ActionsManager.ACTION_STEP_INTO) {
            this.rubySession.stepInto();
        } else if (object == ActionsManager.ACTION_RUN_TO_CURSOR) {
            this.rubySession.runToCursor();
        } else if (object == ActionsManager.ACTION_STEP_OUT) {
            if (this.rubySession.getFrames().length == 1) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RubyDebuggerActionProvider.class, (String)"RubyDebuggerActionProvider.stepout.outermost.frame"));
                this.frontEndSemaphore.release();
                return;
            }
            this.rubySession.stepReturn();
        } else if (object == ActionsManager.ACTION_STEP_OVER) {
            this.rubySession.stepOver();
        }
        ContextProviderWrapper.getSessionsModel().fireChanges();
        this.backEndSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onDebugEvent(RubyDebugEvent rubyDebugEvent) {
        block17: {
            if (rubyDebugEvent.isTerminateType()) {
                this.finish(false);
                return;
            }
            try {
                this.backEndSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                Util.severe(interruptedException);
                return;
            }
            Object object = this.terminated;
            // MONITORENTER : object
            if (this.terminated.booleanValue()) {
                Util.info("Flushing pending event: " + rubyDebugEvent + ", process is terminated.");
                this.backEndSemaphore.release();
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (rubyDebugEvent.isSuspensionType()) {
                object = rubyDebugEvent.getFilePath();
                if ("(eval)".equals(object)) {
                    try {
                        rubyDebugEvent.getRubyThread().stepReturn();
                    }
                    catch (RubyDebuggerException rubyDebuggerException) {
                        Util.severe(rubyDebuggerException);
                    }
                    this.backEndSemaphore.release();
                    return;
                }
                String string = this.rubySession.resolveAbsolutePath((String)object);
                if (string != null) {
                    File file = new File(string);
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    if (rubyDebugEvent.isStepping() || this.rubySession.isRunningTo(file, rubyDebugEvent.getLine()) || fileObject != null && RubyBreakpointManager.isBreakpointOnLine(fileObject, rubyDebugEvent.getLine())) {
                        this.stopHere(rubyDebugEvent);
                        break block17;
                    } else {
                        rubyDebugEvent.getRubyThread().resume();
                        this.backEndSemaphore.release();
                        return;
                    }
                }
                try {
                    rubyDebugEvent.getRubyThread().stepReturn();
                    this.backEndSemaphore.release();
                    return;
                }
                catch (RubyDebuggerException rubyDebuggerException) {
                    Util.severe(rubyDebuggerException);
                }
            } else assert (false) : "Unkown event type: " + rubyDebugEvent;
        }
        this.frontEndSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean bl) {
        Boolean bl2 = this.terminated;
        synchronized (bl2) {
            Util.finest("Finishing session: " + this.rubySession.getName());
            if (this.terminated.booleanValue()) {
                Util.warning("Finish is not supposed to be called when a process is already terminated");
                return;
            }
            this.terminated = true;
        }
        this.rubySession.finish(this, bl);
        EditorUtil.unmarkCurrent();
        this.engineProvider.getDestructor().killEngine();
        this.frontEndSemaphore.release();
        this.backEndSemaphore.release();
    }

    private void stopHere(RubyDebugEvent rubyDebugEvent) {
        this.rubySession.suspend(rubyDebugEvent.getRubyThread(), this.contextProvider);
        this.setEnabled(ActionsManager.ACTION_STEP_OUT, this.rubySession.getFrames().length != 1);
    }

    static {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(ActionsManager.ACTION_KILL);
        hashSet.add(ActionsManager.ACTION_CONTINUE);
        hashSet.add(ActionsManager.ACTION_STEP_INTO);
        hashSet.add(ActionsManager.ACTION_STEP_OVER);
        hashSet.add(ActionsManager.ACTION_STEP_OUT);
        hashSet.add(ActionsManager.ACTION_RUN_TO_CURSOR);
        ACTIONS = Collections.unmodifiableSet(hashSet);
    }
}

