/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.debugger.RubyDebuggerActionProvider;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerFactory;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyDebugger
implements RubyDebuggerImplementation {
    static boolean FORCE_CLASSIC;
    private static final String PATH_TO_CLASSIC_DEBUG_DIR;
    private RubySession session;

    public Process debug(ExecutionDescriptor executionDescriptor) {
        Process process = null;
        try {
            this.session = RubyDebugger.startDebugging(executionDescriptor);
            if (this.session != null) {
                process = this.session.getProxy().getDebugTarged().getProcess();
            }
        }
        catch (IOException iOException) {
            RubyDebugger.problemOccurred(iOException);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            RubyDebugger.problemOccurred((Exception)((Object)rubyDebuggerException));
        }
        return process;
    }

    public Runnable getFinishAction() {
        return new Runnable(){

            public void run() {
                if (RubyDebugger.this.session != null) {
                    RubyDebugger.this.session.getActionProvider().doAction(ActionsManager.ACTION_KILL);
                    RubyDebugger.this.session = null;
                }
            }
        };
    }

    private static void problemOccurred(Exception exception) {
        Util.showWarning(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.startup.problem", (Object)exception.getMessage()));
    }

    static RubySession startDebugging(ExecutionDescriptor executionDescriptor) throws IOException, RubyDebuggerException {
        Object object;
        RubyDebuggerProxy rubyDebuggerProxy;
        Cloneable cloneable;
        RubyPlatform rubyPlatform = executionDescriptor.getPlatform();
        boolean bl = rubyPlatform.isJRuby();
        if (!RubyDebugger.checkAndTuneSettings(executionDescriptor)) {
            return null;
        }
        RubyDebuggerFactory.Descriptor descriptor = new RubyDebuggerFactory.Descriptor();
        descriptor.useDefaultPort(false);
        descriptor.setJRuby(bl);
        descriptor.setScriptPath(executionDescriptor.getScript());
        if (executionDescriptor.getInitialArgs() != null) {
            cloneable = new ArrayList<String>();
            cloneable.addAll(Arrays.asList(executionDescriptor.getInitialArgs()));
            descriptor.setAdditionalOptions(cloneable);
        }
        descriptor.setScriptArguments(executionDescriptor.getAdditionalArgs());
        descriptor.setSynchronizedOutput(true);
        if (executionDescriptor.getPwd() != null) {
            descriptor.setBaseDirectory(executionDescriptor.getPwd());
        }
        cloneable = new HashMap();
        GemManager.adjustEnvironment((RubyPlatform)rubyPlatform, cloneable);
        if (executionDescriptor.getAdditionalEnvironment() != null) {
            cloneable.putAll(executionDescriptor.getAdditionalEnvironment());
        }
        if (bl) {
            cloneable.putAll(RubyDebugger.getJRubyEnvironment(executionDescriptor));
        }
        descriptor.setEnvironment((Map)((Object)cloneable));
        int n = Integer.getInteger("org.netbeans.modules.ruby.debugger.timeout", 15);
        Util.finest("Using timeout: " + n + 's');
        String string = rubyPlatform.getInterpreter();
        if (!rubyPlatform.hasFastDebuggerInstalled() || FORCE_CLASSIC) {
            Util.LOGGER.fine("Running classic(slow) debugger...");
            rubyDebuggerProxy = RubyDebuggerFactory.startClassicDebugger((RubyDebuggerFactory.Descriptor)descriptor, (String)PATH_TO_CLASSIC_DEBUG_DIR, (String)string, (int)n);
        } else {
            Util.LOGGER.fine("Running fast debugger...");
            object = new File(Util.findRDebugExecutable(rubyPlatform));
            rubyDebuggerProxy = RubyDebuggerFactory.startRubyDebug((RubyDebuggerFactory.Descriptor)descriptor, (String)((File)object).getAbsolutePath(), (String)string, (int)n);
        }
        object = RubyDebugger.intializeIDEDebuggerEngine(rubyDebuggerProxy, executionDescriptor.getFileLocator());
        rubyDebuggerProxy.startDebugging((IRubyBreakpoint[])RubyBreakpointManager.getBreakpoints());
        return object;
    }

    private static Map<String, String> getJRubyEnvironment(ExecutionDescriptor executionDescriptor) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (executionDescriptor.getClassPath() != null) {
            hashMap.put("CLASSPATH", executionDescriptor.getClassPath());
        }
        return hashMap;
    }

    static boolean checkAndTuneSettings(ExecutionDescriptor executionDescriptor) {
        RubyPlatform rubyPlatform = executionDescriptor.getPlatform();
        assert (rubyPlatform.isValid()) : rubyPlatform + " is a valid platform";
        boolean bl = rubyPlatform.isJRuby();
        boolean bl2 = executionDescriptor.isFastDebugRequired();
        if (!bl) {
            Util.offerToInstallFastDebugger(rubyPlatform);
        }
        if (bl2 && !Util.ensureRubyDebuggerIsPresent(rubyPlatform, true, "RubyDebugger.wrong.fast.debugger.required")) {
            return false;
        }
        if (rubyPlatform.hasFastDebuggerInstalled()) {
            if (!Util.ensureRubyDebuggerIsPresent(rubyPlatform, true, "RubyDebugger.requiredMessage")) {
                return false;
            }
            String string = Util.findRDebugExecutable(rubyPlatform);
            if (string == null) {
                Util.showMessage(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.wrong.rdebug-ide", (Object)rubyPlatform.getInterpreter(), (Object)Util.rdebugPattern()));
                return false;
            }
        }
        return true;
    }

    private static RubySession intializeIDEDebuggerEngine(RubyDebuggerProxy rubyDebuggerProxy, FileLocator fileLocator) {
        RubySession rubySession = new RubySession(rubyDebuggerProxy, fileLocator);
        SessionProvider sessionProvider = rubySession.createSessionProvider();
        DebuggerInfo debuggerInfo = DebuggerInfo.create((String)"RubyDebuggerInfo", (Object[])new Object[]{sessionProvider, rubySession});
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        DebuggerEngine[] debuggerEngineArray = debuggerManager.startDebugging(debuggerInfo);
        RubyDebuggerActionProvider rubyDebuggerActionProvider = (RubyDebuggerActionProvider)((Object)debuggerEngineArray[0].lookupFirst(null, RubyDebuggerActionProvider.class));
        assert (rubyDebuggerActionProvider != null);
        rubySession.setActionProvider(rubyDebuggerActionProvider);
        rubyDebuggerProxy.addRubyDebugEventListener((RubyDebugEventListener)rubyDebuggerActionProvider);
        return rubySession;
    }

    static {
        String string = "ruby/debug-commons-0.9.5/classic-debug.rb";
        File file = InstalledFileLocator.getDefault().locate(string, "org.netbeans.modules.ruby.debugger", false);
        if (file == null || !file.isFile()) {
            throw new IllegalStateException("Cannot locate classic debugger in NetBeans Ruby cluster (" + string + ')');
        }
        PATH_TO_CLASSIC_DEBUG_DIR = file.getParentFile().getAbsolutePath();
    }
}

