/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidNameAttribute
extends AbstractWebServiceRule {
    protected ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        AnnotationValue annotationValue;
        AnnotationMirror annotationMirror = Utilities.findAnnotation(typeElement, "javax.jws.WebService");
        AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(typeElement, annotationMirror);
        if (typeElement.getKind() == ElementKind.CLASS && (annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "endpointInterface")) != null && Utilities.getAnnotationAttrValue(annotationMirror, "name") != null) {
            String string = NbBundle.getMessage(InvalidNameAttribute.class, (String)"MSG_NameAttributeNotAllowed");
            ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "name");
            RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), typeElement, annotationMirror, "name");
            problemContext.setElementToAnnotate(expressionTree);
            ErrorDescription errorDescription = InvalidNameAttribute.createProblem((Element)typeElement, problemContext, string, removeAnnotationArgument);
            problemContext.setElementToAnnotate(null);
            return new ErrorDescription[]{errorDescription};
        }
        return null;
    }
}

