/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.parser;

import org.netbeans.modules.css.parser.CSSParser;
import org.netbeans.modules.css.parser.CSSParserTreeConstants;
import org.netbeans.modules.css.parser.Node;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected CSSParser parser;
    protected Token firstToken;
    protected Token lastToken;
    private String image;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(CSSParser cSSParser, int n) {
        this(n);
        this.parser = cSSParser;
    }

    public int kind() {
        return this.id;
    }

    public int startOffset() {
        return this.jjtGetFirstToken().offset;
    }

    public int endOffset() {
        if (this.jjtGetLastToken().image == null) {
            System.err.println("ERROR: lastToken image is null! : " + this.jjtGetLastToken());
            return this.jjtGetLastToken().offset;
        }
        return this.jjtGetLastToken().offset + this.jjtGetLastToken().image.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String image() {
        SimpleNode simpleNode = this;
        synchronized (simpleNode) {
            if (this.image == null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.jjtGetFirstToken() == this.jjtGetLastToken()) {
                    this.image = this.jjtGetFirstToken().image;
                } else {
                    Token token = this.jjtGetFirstToken();
                    Token token2 = this.jjtGetLastToken();
                    while (token != null && token.offset <= token2.offset) {
                        stringBuffer.append(token.image);
                        token = token.next;
                    }
                    this.image = stringBuffer.toString();
                }
            }
            return this.image;
        }
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Token jjtGetFirstToken() {
        return this.firstToken;
    }

    public void jjtSetFirstToken(Token token) {
        this.firstToken = token;
    }

    public Token jjtGetLastToken() {
        return this.lastToken;
    }

    public void jjtSetLastToken(Token token) {
        this.lastToken = token;
    }

    public String toString() {
        return CSSParserTreeConstants.jjtNodeName[this.id] + " [" + this.startOffset() + " - " + this.endOffset() + "]";
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public void visitChildren(NodeVisitor nodeVisitor) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                nodeVisitor.visit(simpleNode);
                simpleNode.visitChildren(nodeVisitor);
            }
        }
    }
}

