/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.TranslatedSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> semanticHighlights;

    public Map<OffsetRange, ColoringAttributes> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        if (this.cancelled) {
            return;
        }
        final HashMap<OffsetRange, ColoringAttributes> hashMap = new HashMap<OffsetRange, ColoringAttributes>();
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
        final TranslatedSource translatedSource = parserResult.getTranslatedSource();
        SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
        if (simpleNode == null) {
            this.semanticHighlights = hashMap;
            return;
        }
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                AstOffsetRange astOffsetRange;
                if (simpleNode.kind() == 23 || simpleNode.kind() == 22 || simpleNode.kind() == 25 || simpleNode.kind() == 26 || simpleNode.kind() == 24) {
                    AstOffsetRange astOffsetRange2 = new AstOffsetRange(simpleNode.startOffset(), simpleNode.endOffset(), translatedSource);
                    if (!astOffsetRange2.isEmpty()) {
                        hashMap.put(astOffsetRange2, ColoringAttributes.METHOD);
                    }
                } else if (simpleNode.kind() == 17 && !(astOffsetRange = new AstOffsetRange(simpleNode.startOffset(), simpleNode.endOffset(), translatedSource)).isEmpty()) {
                    String string = simpleNode.image().trim();
                    if (CssAnalyser.isVendorSpecificProperty(string)) {
                        hashMap.put(astOffsetRange, ColoringAttributes.PARAMETER_USE);
                    } else {
                        hashMap.put(astOffsetRange, ColoringAttributes.PARAMETER);
                    }
                }
            }
        };
        simpleNode.visitChildren(nodeVisitor);
        this.semanticHighlights = hashMap;
    }

    public static class AstOffsetRange
    extends OffsetRange {
        private TranslatedSource source;

        public AstOffsetRange(int n, int n2, TranslatedSource translatedSource) {
            super(n, n2);
            this.source = translatedSource;
        }

        public int getStart() {
            return this.source == null ? super.getStart() : this.source.getLexicalOffset(super.getStart());
        }

        public int getEnd() {
            return this.source == null ? super.getEnd() : this.source.getLexicalOffset(super.getEnd());
        }

        public boolean isEmpty() {
            return this.getEnd() - this.getStart() == 0;
        }
    }
}

