/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.gsf.AstUtils;
import org.netbeans.modules.css.gsf.CSSParserResult;
import org.netbeans.modules.css.lexer.api.CSSTokenId;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSCompletion
implements Completable {
    private static final Logger LOGGER = Logger.getLogger(CSSCompletion.class.getName());
    private final PropertyModel PROPERTIES = PropertyModel.instance();
    private static final Collection<String> AT_RULES = Arrays.asList("@media", "@page", "@import", "@charset", "@font-face");

    public List<CompletionProposal> complete(CompilationInfo compilationInfo, int n, String string, NameKind nameKind, Completable.QueryType queryType, boolean bl, HtmlFormatter htmlFormatter) {
        try {
            if (string == null) {
                return null;
            }
            TokenSequence tokenSequence = LexerUtils.getCssTokenSequence(compilationInfo.getDocument(), n);
            tokenSequence.move(n - string.length());
            boolean bl2 = tokenSequence.moveNext();
            ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/x-css").iterator().next();
            TranslatedSource translatedSource = parserResult.getTranslatedSource();
            SimpleNode simpleNode = ((CSSParserResult)parserResult).root();
            if (simpleNode == null) {
                return null;
            }
            int n2 = translatedSource == null ? n : translatedSource.getAstOffset(n);
            SimpleNode simpleNode2 = SimpleNodeUtil.findDescendant(simpleNode, n2);
            if (simpleNode2 == null) {
                if (bl2 && "@".equals(((Object)tokenSequence.token().text()).toString())) {
                    return this.wrapValues(AT_RULES, CompletionItemKind.VALUE, tokenSequence.offset(), htmlFormatter);
                }
                return null;
            }
            if (simpleNode2.kind() == 1) {
                return this.wrapValues(AT_RULES, CompletionItemKind.VALUE, n, htmlFormatter);
            }
            if (simpleNode2.kind() == 37) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetParent();
                if (simpleNode3 != null && simpleNode3.kind() == 4) {
                    Collection<String> collection = this.filterValues(AT_RULES, string);
                    return this.wrapValues(collection, CompletionItemKind.VALUE, AstUtils.documentPosition(simpleNode3.startOffset(), translatedSource), htmlFormatter);
                }
            } else if (simpleNode2.kind() == 5 || simpleNode2.kind() == 6 || simpleNode2.kind() == 11 || simpleNode2.kind() == 3 || simpleNode2.kind() == 13) {
                TokenId tokenId = tokenSequence.token().id();
                if (tokenId == CSSTokenId.IMPORT_SYM || tokenId == CSSTokenId.MEDIA_SYM || tokenId == CSSTokenId.PAGE_SYM || tokenId == CSSTokenId.CHARSET_SYM || tokenId == CSSTokenId.FONT_FACE_SYM) {
                    Collection<String> collection = this.filterValues(AT_RULES, string);
                    return this.wrapValues(collection, CompletionItemKind.VALUE, AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource), htmlFormatter);
                }
            } else {
                if (simpleNode2.kind() == 17 && (string.length() > 0 || n2 == simpleNode2.startOffset())) {
                    Collection<Property> collection = this.filterProperties(this.PROPERTIES.properties(), string);
                    return this.wrapProperties(collection, CompletionItemKind.PROPERTY, AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource), htmlFormatter);
                }
                if (simpleNode2.kind() == 18) {
                    return this.wrapProperties(this.PROPERTIES.properties(), CompletionItemKind.PROPERTY, n, htmlFormatter);
                }
                if (simpleNode2.kind() == 28) {
                    final SimpleNode[] simpleNodeArray = new SimpleNode[1];
                    NodeVisitor nodeVisitor = new NodeVisitor(){

                        public void visit(SimpleNode simpleNode) {
                            if (simpleNode.kind() == 17) {
                                simpleNodeArray[0] = simpleNode;
                            }
                        }
                    };
                    simpleNode2.visitChildren(nodeVisitor);
                    SimpleNode simpleNode4 = simpleNodeArray[0];
                    Property property = this.PROPERTIES.getProperty(simpleNode4.image());
                    if (property != null) {
                        Collection<String> collection = property.values();
                        return this.wrapValues(collection, CompletionItemKind.VALUE, n, htmlFormatter);
                    }
                } else if (simpleNode2.kind() == 31 && (string.length() > 0 || n2 == simpleNode2.startOffset())) {
                    final SimpleNode[] simpleNodeArray = new SimpleNode[1];
                    NodeVisitor nodeVisitor = new NodeVisitor(){

                        public void visit(SimpleNode simpleNode) {
                            if (simpleNode.kind() == 28) {
                                simpleNodeArray[0] = simpleNode;
                            }
                        }
                    };
                    SimpleNodeUtil.visitAncestors(simpleNode2, nodeVisitor);
                    SimpleNode simpleNode5 = simpleNodeArray[0];
                    simpleNodeArray[0] = null;
                    NodeVisitor nodeVisitor2 = new NodeVisitor(){

                        public void visit(SimpleNode simpleNode) {
                            if (simpleNode.kind() == 17) {
                                simpleNodeArray[0] = simpleNode;
                            }
                        }
                    };
                    SimpleNodeUtil.visitChildren(simpleNode5, nodeVisitor2);
                    SimpleNode simpleNode6 = simpleNodeArray[0];
                    Property property = this.PROPERTIES.getProperty(simpleNode6.image());
                    if (property == null) {
                        return null;
                    }
                    Collection<String> collection = property.values();
                    return this.wrapValues(this.filterValues(collection, string), CompletionItemKind.VALUE, AstUtils.documentPosition(simpleNode2.startOffset(), translatedSource), htmlFormatter);
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private List<CompletionProposal> wrapValues(Collection<String> collection, CompletionItemKind completionItemKind, int n, HtmlFormatter htmlFormatter) {
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>(collection.size());
        for (String string : collection) {
            CSSCompletionItem cSSCompletionItem = new CSSCompletionItem(string, completionItemKind, n, htmlFormatter);
            arrayList.add(cSSCompletionItem);
        }
        return arrayList;
    }

    private Collection<String> filterValues(Collection<String> collection, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private List<CompletionProposal> wrapProperties(Collection<Property> collection, CompletionItemKind completionItemKind, int n, HtmlFormatter htmlFormatter) {
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>(collection.size());
        for (Property property : collection) {
            CSSCompletionItem cSSCompletionItem = new CSSCompletionItem(property.name(), completionItemKind, n, htmlFormatter);
            arrayList.add(cSSCompletionItem);
        }
        return arrayList;
    }

    private Collection<Property> filterProperties(Collection<Property> collection, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : collection) {
            if (!property.name().startsWith(string)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        return "doc not supported yet";
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return null;
    }

    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        try {
            Token token;
            TokenSequence tokenSequence = LexerUtils.getCssTokenSequence(compilationInfo.getDocument(), n);
            if (tokenSequence == null) {
                return null;
            }
            int n2 = tokenSequence.move(n);
            if (n2 == 0) {
                if (!tokenSequence.movePrevious()) {
                    return "";
                }
            } else if (!tokenSequence.moveNext()) {
                return null;
            }
            if ((token = tokenSequence.token()).id() == CSSTokenId.COLON) {
                return "";
            }
            return ((Object)token.text().subSequence(0, n2 == 0 ? token.text().length() : n2)).toString().trim();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public Completable.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        if (string == null || string.length() == 0) {
            return Completable.QueryType.NONE;
        }
        char c = string.charAt(0);
        switch (c) {
            case '\n': 
            case ';': 
            case '}': {
                return Completable.QueryType.STOP;
            }
            case ':': {
                return Completable.QueryType.COMPLETION;
            }
        }
        return Completable.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        return "";
    }

    public Set<String> getApplicableTemplates(CompilationInfo compilationInfo, int n, int n2) {
        return Collections.emptySet();
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CSSCompletionItem
    implements CompletionProposal {
        private static final String CSS_PROPERTY = "org/netbeans/modules/css/resources/methodPublic.png";
        private static final String CSS_VALUE = "org/netbeans/modules/css/resources/fieldPublic.png";
        private ImageIcon propertyIcon;
        private ImageIcon valueIcon;
        private int anchorOffset;
        private String value;
        private HtmlFormatter formatter;
        private CompletionItemKind kind;

        private CSSCompletionItem(String string, CompletionItemKind completionItemKind, int n, HtmlFormatter htmlFormatter) {
            this.anchorOffset = n;
            this.value = string;
            this.kind = completionItemKind;
            this.formatter = htmlFormatter;
        }

        public int getAnchorOffset() {
            return this.anchorOffset;
        }

        public String getName() {
            return this.value;
        }

        public String getInsertPrefix() {
            return this.getName();
        }

        public String getSortText() {
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public ImageIcon getIcon() {
            if (this.kind == CompletionItemKind.PROPERTY) {
                if (this.propertyIcon == null) {
                    this.propertyIcon = new ImageIcon(Utilities.loadImage((String)CSS_PROPERTY));
                }
                return this.propertyIcon;
            }
            if (this.kind == CompletionItemKind.VALUE) {
                if (this.valueIcon == null) {
                    this.valueIcon = new ImageIcon(Utilities.loadImage((String)CSS_VALUE));
                }
                return this.valueIcon;
            }
            return null;
        }

        public String getLhsHtml() {
            this.formatter.reset();
            this.formatter.appendText(this.getName());
            return this.formatter.getText();
        }

        public String getRhsHtml() {
            return null;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public String toString() {
            return this.getName();
        }

        public boolean isSmart() {
            return false;
        }

        public List<String> getInsertParams() {
            return null;
        }

        public String[] getParamListDelimiters() {
            return new String[]{"(", ")"};
        }

        public String getCustomInsertTemplate() {
            return null;
        }

        public ElementHandle getElement() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompletionItemKind {
        PROPERTY,
        VALUE;

    }
}

