/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssRuleContent {
    private static final Logger LOGGER = Logger.getLogger(CssRuleContent.class.getName());
    public static final String NOT_SET = NbBundle.getMessage(CssRuleContent.class, (String)"NOT_SET");
    public static final String VALUE = NbBundle.getMessage(CssRuleContent.class, (String)"VALUE");
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private HashMap<PropertyChangeListener, Exception> listenersCreators = new HashMap();
    private List<CssRuleItem> items;
    private boolean immutable;

    CssRuleContent(List<CssRuleItem> list, boolean bl) {
        this.items = list;
        this.immutable = bl;
    }

    public List<CssRuleItem> ruleItems() {
        return this.items;
    }

    public String getProperty(String string) {
        CssRuleItem cssRuleItem = this.findItem(string);
        if (cssRuleItem != null) {
            return cssRuleItem.value().name();
        }
        return null;
    }

    public void modifyProperty(String string, String string2) throws BadLocationException {
        if (Boolean.getBoolean("issue_118641_debug")) {
            Thread.dumpStack();
        }
        CssRuleItem cssRuleItem = this.findItem(string);
        string2 = string2.trim();
        if (cssRuleItem == null && string2.length() == 0) {
            return;
        }
        if (cssRuleItem != null && string2.length() == 0) {
            if (!this.immutable) {
                this.items.remove(cssRuleItem);
            }
            this.firePropertyChange(cssRuleItem, null);
        } else {
            String string3;
            String string4 = string3 = cssRuleItem == null ? null : cssRuleItem.value().name();
            if (string3 == null || !string2.equals(string3)) {
                CssRuleItem cssRuleItem2 = new CssRuleItem(string, -1, string2, -1);
                if (!this.immutable) {
                    if (cssRuleItem == null) {
                        this.items.add(cssRuleItem2);
                    } else {
                        cssRuleItem.key = new CssRuleItem.Item(string, -1);
                        cssRuleItem.value = new CssRuleItem.Item(string2, -1);
                    }
                }
                this.firePropertyChange(cssRuleItem, cssRuleItem2);
            }
        }
    }

    public String getFormattedString() {
        StringWriter stringWriter = new StringWriter();
        for (CssRuleItem cssRuleItem : this.items) {
            String string = cssRuleItem.key().name();
            String string2 = cssRuleItem.value().name().trim();
            if (!string2.equals(NOT_SET) && !string2.equals("")) {
                stringWriter.write("   " + string);
                stringWriter.write(": ");
                stringWriter.write(string2);
                stringWriter.write("; ");
            }
            stringWriter.write("\n");
        }
        return stringWriter.toString();
    }

    public String toString() {
        return this.getFormattedString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.listeners.isEmpty()) {
            IllegalStateException illegalStateException = new IllegalStateException("Trying to add second listener to CssRuleContent.");
            LOGGER.throwing(CssRuleContent.class.getName(), "addPropertyChangeListener", illegalStateException);
            LOGGER.log(Level.FINE, "Stacktraces of the previous listeners creators:");
            for (Exception exception : this.listenersCreators.values()) {
                LOGGER.throwing(CssRuleContent.class.getName(), "addPropertyChangeListener", exception);
            }
        }
        this.listenersCreators.put(propertyChangeListener, new Exception());
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
        this.listenersCreators.remove(propertyChangeListener);
    }

    private synchronized void firePropertyChange(CssRuleItem cssRuleItem, CssRuleItem cssRuleItem2) {
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "property", cssRuleItem, cssRuleItem2));
        }
    }

    private CssRuleItem findItem(String string) {
        for (CssRuleItem cssRuleItem : this.items) {
            if (!cssRuleItem.key().name().equals(string)) continue;
            return cssRuleItem;
        }
        return null;
    }
}

