/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.model;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.css.editor.model.CssRuleContent;

public class CssRule {
    private Position ruleNameOffset;
    private Position ruleOpenBracketOffset;
    private Position ruleCloseBracketOffset;
    private String ruleName;
    private CssRuleContent styleData;

    public CssRule(Document document, String string, int n, int n2, int n3, CssRuleContent cssRuleContent) throws BadLocationException {
        this.ruleName = string;
        this.ruleNameOffset = document == null ? new SimplePosition(n) : document.createPosition(n);
        this.ruleOpenBracketOffset = document == null ? new SimplePosition(n2) : document.createPosition(n2);
        this.ruleCloseBracketOffset = document == null ? new SimplePosition(n3) : document.createPosition(n3);
        this.styleData = cssRuleContent;
    }

    public CssRuleContent ruleContent() {
        return this.styleData;
    }

    public String name() {
        return this.ruleName;
    }

    public int getRuleNameOffset() {
        return this.ruleNameOffset.getOffset();
    }

    public int getRuleCloseBracketOffset() {
        return this.ruleCloseBracketOffset.getOffset();
    }

    public int getRuleOpenBracketOffset() {
        return this.ruleOpenBracketOffset.getOffset();
    }

    public String toString() {
        return "CssRule[" + this.name() + "\n" + this.ruleContent().toString() + "]";
    }

    static class SimplePosition
    implements Position {
        private int offset;

        SimplePosition(int n) {
            this.offset = n;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

