/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.javon.JavonSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData {
    private String packageName;
    private String className;
    private boolean primitive;
    private boolean array;
    private boolean generics;
    private ClassData parent;
    private JavonSerializer supportingSerializer = null;
    private List<FieldData> fields = new ArrayList<FieldData>();
    private List<MethodData> methods = new ArrayList<MethodData>();
    private ClassData componentType;
    private List<ClassData> typeParameters = new ArrayList<ClassData>();
    public static final ClassData java_lang_Object = new ClassData("java.lang", "Object", false, false);

    private ClassData(String string, String string2, boolean bl, boolean bl2) {
        this.packageName = string;
        this.className = string2;
        this.primitive = bl;
        this.array = bl2;
        this.parent = java_lang_Object;
    }

    public ClassData(ClassData classData) {
        this.packageName = classData.getPackage();
        this.className = classData.getName();
        this.primitive = classData.isPrimitive();
        this.array = classData.isArray();
        this.generics = classData.getParameterTypes().isEmpty();
        this.componentType = classData.getComponentType();
        this.parent = classData.getParent();
        this.supportingSerializer = classData.getSerializer();
        this.fields = classData.getFields();
        this.methods = classData.getMethods();
        this.typeParameters = classData.getParameterTypes();
    }

    public ClassData(String string, String string2, boolean bl, boolean bl2, JavonSerializer javonSerializer) {
        this(string, string2, bl, bl2);
        this.generics = false;
        this.supportingSerializer = javonSerializer;
    }

    public ClassData(String string, String string2, boolean bl, List<FieldData> list, List<MethodData> list2, JavonSerializer javonSerializer) {
        this(string, string2, false, bl, javonSerializer);
        this.generics = false;
        this.fields = list;
        this.methods = list2;
    }

    public ClassData(String string, String string2, boolean bl, List<ClassData> list, JavonSerializer javonSerializer) {
        this(string, string2, false, bl, javonSerializer);
        this.generics = true;
        this.typeParameters = list;
    }

    public ClassData(String string, String string2, boolean bl, List<FieldData> list, List<MethodData> list2, List<ClassData> list3, JavonSerializer javonSerializer) {
        this(string, string2, bl, list, list2, javonSerializer);
        this.generics = true;
        this.typeParameters = list3;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        int n = 0;
        ClassData classData = this;
        while (classData.isArray()) {
            classData = classData.getComponentType();
            ++n;
        }
        String string = "";
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                string = string + "[]";
            }
        }
        return this.className + string;
    }

    public String getFullyQualifiedName() {
        if (this.packageName == "") {
            return this.getName();
        }
        return this.packageName + "." + this.getName();
    }

    public void setParent(ClassData classData) {
        this.parent = classData;
    }

    public ClassData getParent() {
        return this.parent;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setComponentType(ClassData classData) {
        this.componentType = classData;
    }

    public ClassData getComponentType() {
        return this.componentType;
    }

    public void addField(FieldData fieldData) {
        this.fields.add(fieldData);
    }

    public List<FieldData> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<FieldData> getAllFields() {
        ArrayList<FieldData> arrayList = new ArrayList<FieldData>();
        for (ClassData classData = this; classData != null; classData = classData.getParent()) {
            arrayList.addAll(classData.getFields());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void addMethod(MethodData methodData) {
        this.methods.add(methodData);
    }

    public List<MethodData> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public List<ClassData> getParameterTypes() {
        return Collections.unmodifiableList(this.typeParameters);
    }

    public void setParameterTypes(List<ClassData> list) {
        this.typeParameters = list;
    }

    public String toString() {
        String string = this.getName();
        if (this.typeParameters.size() > 0) {
            string = string + "<";
            Iterator<Object> iterator = this.typeParameters.iterator();
            while (iterator.hasNext()) {
                string = string + ((ClassData)iterator.next()).toString();
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            string = string + ">";
        }
        if (this.fields.size() > 0) {
            string = string + "[";
            for (FieldData fieldData : this.fields) {
                string = string + fieldData.getType().toString() + ", ";
            }
            string = string + "]";
        }
        return string;
    }

    public JavonSerializer getSerializer() {
        return this.supportingSerializer;
    }

    public boolean equals(Object object) {
        if (object instanceof ClassData) {
            ClassData classData = (ClassData)object;
            if (!this.getFullyQualifiedName().equals(classData.getFullyQualifiedName())) {
                return false;
            }
            if (this.primitive != classData.isPrimitive()) {
                return false;
            }
            if (this.array != classData.isArray()) {
                return false;
            }
            if (this.typeParameters.size() != classData.getParameterTypes().size()) {
                return false;
            }
            for (int i = 0; i < this.typeParameters.size(); ++i) {
                if (this.typeParameters.get(i).equals(classData.getParameterTypes().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode() * 37 + this.className.hashCode() * 37 + (this.primitive ? 7 : 3) + (this.array ? 7 : 3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modifier {
        PUBLIC,
        PRIVATE;

    }
}

