/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 1L;
    private String[] serverInstanceIDs;
    private String[] serverNames;
    private boolean initialized;
    private final EarProjectProperties uiProperties;
    private JPanel clientInfoPanel;
    private JComboBox clientModuleUriCombo;
    private JLabel filler;
    private JCheckBox jCheckBoxDisplayBrowser;
    private JComboBox jComboBoxServer;
    private JLabel jLabelArgs;
    private JLabel jLabelContextPath;
    private JLabel jLabelContextPathDesc;
    private JLabel jLabelMainClass;
    private JLabel jLabelRelativeURL;
    private JLabel jLabelServer;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelVersion;
    private JTextField jTextArgs;
    private JTextField jTextFieldRelativeURL;
    private JTextField jTextFieldVersion;
    private JTextField jTextMainClass;
    private JTextField jTextVMOptions;
    private JPanel webInfoPanel;

    public CustomizerRun(EarProjectProperties earProjectProperties) {
        this.uiProperties = earProjectProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_A11YDesc"));
        this.clientModuleUriCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.updateEnabled();
            }
        });
        this.initValues();
        this.updateEnabled();
    }

    private boolean isWebModuleSelected() {
        return this.clientModuleUriCombo.getSelectedItem() == null || !((ClientModuleItem)this.clientModuleUriCombo.getSelectedItem()).appClient;
    }

    private void updateEnabled() {
        boolean bl = this.isWebModuleSelected();
        this.handleWebModuleRelated(bl);
        this.jTextMainClass.setEnabled(!bl);
        this.jTextArgs.setEnabled(!bl);
        this.jTextVMOptions.setEnabled(!bl);
        this.jLabelMainClass.setEnabled(!bl);
        this.jLabelArgs.setEnabled(!bl);
        this.jLabelVMOptions.setEnabled(!bl);
        this.jLabelVMOptionsExample.setEnabled(!bl);
    }

    public void initValues() {
        if (this.initialized) {
            return;
        }
        this.jTextFieldRelativeURL.setDocument(this.uiProperties.LAUNCH_URL_RELATIVE_MODEL);
        this.jCheckBoxDisplayBrowser.setModel(this.uiProperties.DISPLAY_BROWSER_MODEL);
        this.jComboBoxServer.setModel(this.uiProperties.J2EE_SERVER_INSTANCE_MODEL);
        this.jTextMainClass.setDocument(this.uiProperties.MAIN_CLASS_MODEL);
        this.jTextArgs.setDocument(this.uiProperties.ARUGMENTS_MODEL);
        this.jTextVMOptions.setDocument(this.uiProperties.VM_OPTIONS_MODEL);
        this.clientModuleUriCombo.setModel(this.uiProperties.CLIENT_MODULE_MODEL);
        String string = this.uiProperties.getProject().getJ2eePlatformVersion();
        if ("1.5".equals(string)) {
            this.jTextFieldVersion.setText(EarProjectProperties.JAVA_EE_SPEC_50_LABEL);
        } else if ("1.4".equals(string)) {
            this.jTextFieldVersion.setText(EarProjectProperties.J2EE_SPEC_14_LABEL);
        }
        this.handleWebModuleRelated();
        this.initialized = true;
    }

    private void handleWebModuleRelated() {
        this.handleWebModuleRelated(this.isWebModuleSelected());
    }

    private void handleWebModuleRelated(Boolean bl) {
        this.jCheckBoxDisplayBrowser.setEnabled(bl);
        this.jLabelContextPathDesc.setEnabled(bl);
        this.jLabelRelativeURL.setEnabled(bl);
        this.jTextFieldRelativeURL.setEnabled(bl);
    }

    private int getLongestVersionLength() {
        return Math.max(EarProjectProperties.JAVA_EE_SPEC_50_LABEL.length(), EarProjectProperties.J2EE_SPEC_14_LABEL.length());
    }

    private void initComponents() {
        this.jLabelContextPath = new JLabel();
        this.jLabelServer = new JLabel();
        this.jComboBoxServer = new JComboBox();
        this.clientModuleUriCombo = new JComboBox();
        this.webInfoPanel = new JPanel();
        this.jLabelContextPathDesc = new JLabel();
        this.jLabelRelativeURL = new JLabel();
        this.jTextFieldRelativeURL = new JTextField();
        this.jCheckBoxDisplayBrowser = new JCheckBox();
        this.clientInfoPanel = new JPanel();
        this.jLabelVMOptionsExample = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptions = new JLabel();
        this.jLabelArgs = new JLabel();
        this.jLabelMainClass = new JLabel();
        this.jTextMainClass = new JTextField();
        this.jTextArgs = new JTextField();
        this.filler = new JLabel();
        this.jLabelVersion = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabelContextPath.setLabelFor(this.clientModuleUriCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ClientModuleURI_JLabel"));
        this.jLabelServer.setLabelFor(this.jComboBoxServer);
        Mnemonics.setLocalizedText((JLabel)this.jLabelServer, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Server_JLabel"));
        this.jComboBoxServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jComboBoxServerActionPerformed(actionEvent);
            }
        });
        this.webInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_WebModInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPathDesc, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_ContextPathDesc_JLabel"));
        this.jLabelRelativeURL.setLabelFor(this.jTextFieldRelativeURL);
        Mnemonics.setLocalizedText((JLabel)this.jLabelRelativeURL, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_RelativeURL_JLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxDisplayBrowser, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_DisplayBrowser_JCheckBox"));
        this.jCheckBoxDisplayBrowser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jCheckBoxDisplayBrowserActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.webInfoPanel);
        this.webInfoPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jCheckBoxDisplayBrowser).add((Component)this.jLabelContextPathDesc).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelRelativeURL).addPreferredGap(0).add((Component)this.jTextFieldRelativeURL, -1, 511, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jCheckBoxDisplayBrowser).addPreferredGap(0).add((Component)this.jLabelContextPathDesc).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelRelativeURL).add((Component)this.jTextFieldRelativeURL, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldRelativeURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_RelativeURL_A11YDesc"));
        this.jCheckBoxDisplayBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_DisplayBrowser_A11YDesc"));
        this.clientInfoPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ClientInfo")));
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        this.jLabelArgs.setLabelFor(this.jTextArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.jLabelMainClass.setLabelFor(this.jTextMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.clientInfoPanel);
        this.clientInfoPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.jLabelMainClass).add((Component)this.jLabelArgs, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelVMOptions, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabelVMOptionsExample).add(2, (Component)this.jTextVMOptions, -1, 514, Short.MAX_VALUE).add(2, (Component)this.jTextArgs, -1, 514, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((Component)this.jTextMainClass, -1, 514, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabelMainClass).add((Component)this.jTextMainClass, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jTextArgs, -2, -1, -2).add((Component)this.jLabelArgs)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jTextVMOptions, -2, -1, -2).add((Component)this.jLabelVMOptions)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelVMOptionsExample)));
        this.jLabelVersion.setLabelFor(this.jTextFieldVersion);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVersion, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Version_JLabel"));
        this.jTextFieldVersion.setColumns(this.getLongestVersionLength());
        this.jTextFieldVersion.setEditable(false);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.webInfoPanel, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.clientInfoPanel, -1, -1, Short.MAX_VALUE)).add((Component)this.filler).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.jLabelVersion).add((Component)this.jLabelContextPath).add((Component)this.jLabelServer)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addPreferredGap(0).add((Component)this.clientModuleUriCombo, 0, 530, Short.MAX_VALUE)).add((Component)this.jComboBoxServer, 0, 530, Short.MAX_VALUE).add((Component)this.jTextFieldVersion, -2, -1, -2)))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.filler).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabelContextPath).add((Component)this.clientModuleUriCombo, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabelServer).add((Component)this.jComboBoxServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.jLabelVersion).add((Component)this.jTextFieldVersion, -2, -1, -2)).add(32, 32, 32).add((Component)this.webInfoPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.clientInfoPanel, -2, -1, -2).addContainerGap(184, Short.MAX_VALUE)));
        this.jComboBoxServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"ACS_CustomizeRun_Server_A11YDesc"));
    }

    private void jCheckBoxDisplayBrowserActionPerformed(ActionEvent actionEvent) {
        this.handleWebModuleRelated();
    }

    private void jComboBoxServerActionPerformed(ActionEvent actionEvent) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    public static ApplicationUrisComboBoxModel createApplicationUrisComboBoxModel(EarProject earProject) {
        return new ApplicationUrisComboBoxModel(earProject);
    }

    public static final class ClientModuleItem
    implements Comparable {
        private String uri;
        private boolean appClient;

        public ClientModuleItem(String string, boolean bl) {
            assert (string != null);
            this.uri = string;
            this.appClient = bl;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isAppClient() {
            return this.appClient;
        }

        public String toString() {
            return this.uri;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            return this.uri.equals(((ClientModuleItem)object).uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public int compareTo(Object object) {
            return this.uri.compareTo(((ClientModuleItem)object).uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ApplicationUrisComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List<ClientModuleItem> values;
        private EarProject project;
        private ClientModuleItem selected;

        public ApplicationUrisComboBoxModel(EarProject earProject) {
            this.project = earProject;
            this.initValues(EarProjectProperties.getJarContentAdditional(earProject));
        }

        @Override
        public Object getElementAt(int n) {
            return this.values.get(n);
        }

        private boolean setSelectedItem(String string, String string2) {
            if (string != null && this.values.contains(new ClientModuleItem(string, false))) {
                this.setSelectedItem(new ClientModuleItem(string, false));
                return true;
            }
            if (string2 != null && this.values.contains(new ClientModuleItem(string2, true))) {
                this.setSelectedItem(new ClientModuleItem(string2, true));
                return true;
            }
            return false;
        }

        public void storeSelectedItem(EditableProperties editableProperties) {
            ClientModuleItem clientModuleItem = (ClientModuleItem)this.getSelectedItem();
            if (clientModuleItem == null) {
                editableProperties.remove((Object)"app.client");
                editableProperties.remove((Object)"client.module.uri");
            } else if (clientModuleItem.isAppClient()) {
                editableProperties.setProperty("app.client", clientModuleItem.getUri());
                editableProperties.setProperty("client.module.uri", ApplicationUrisComboBoxModel.getClientModuleUriForAppClient(this.project));
            } else {
                editableProperties.remove((Object)"app.client");
                editableProperties.setProperty("client.module.uri", clientModuleItem.getUri());
            }
        }

        @Override
        public int getSize() {
            return this.values.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selected = (ClientModuleItem)object;
        }

        void refresh(List<ClassPathSupport.Item> list) {
            this.initValues(list);
            this.fireContentsChanged(this, 0, this.values.size());
        }

        private void initValues(List<ClassPathSupport.Item> list) {
            String string;
            Object object2;
            TreeSet<ClientModuleItem> treeSet = new TreeSet<ClientModuleItem>();
            for (Object object2 : EarProjectProperties.getApplicationSubprojects(list, J2eeModule.WAR)) {
                treeSet.add(new ClientModuleItem(ProjectUtils.getInformation((Project)object2).getName(), false));
            }
            for (Object object2 : EarProjectProperties.getApplicationSubprojects(list, J2eeModule.CLIENT)) {
                treeSet.add(new ClientModuleItem(ProjectUtils.getInformation((Project)object2).getName(), true));
            }
            this.values = new ArrayList<ClientModuleItem>(treeSet);
            EditableProperties editableProperties = this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
            object2 = editableProperties.getProperty("client.module.uri");
            if (!this.setSelectedItem((String)object2, string = editableProperties.getProperty("app.client"))) {
                this.setSelectedItem(this.values.size() > 0 ? this.values.get(0) : null);
            }
        }

        private static String getClientModuleUriForAppClient(EarProject earProject) {
            String string = earProject.getAntProjectHelper().getProperties("nbproject/project.properties").getProperty("jar.name");
            if (string.endsWith(".ear")) {
                string = string.substring(0, string.length() - 4);
            }
            return string + "/${" + "app.client" + '}';
        }

        public static void moduleWasRemove(Project project, EditableProperties editableProperties) {
            String string = ProjectUtils.getInformation((Project)project).getName();
            if (string.equals(editableProperties.getProperty("app.client")) || string.equals(editableProperties.getProperty("client.module.uri"))) {
                editableProperties.remove((Object)"app.client");
                editableProperties.remove((Object)"client.module.uri");
            }
        }

        public static void initializeProperties(final EarProject earProject, final String string, final String string2) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    try {
                        EditableProperties editableProperties = earProject.getUpdateHelper().getProperties("nbproject/project.properties");
                        if (string != null) {
                            editableProperties.remove((Object)"app.client");
                            editableProperties.setProperty("client.module.uri", string);
                        } else if (string2 != null) {
                            editableProperties.setProperty("app.client", string2);
                            editableProperties.setProperty("client.module.uri", ApplicationUrisComboBoxModel.getClientModuleUriForAppClient(earProject));
                        }
                        earProject.getUpdateHelper().putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject((Project)earProject);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }
    }
}

