/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.classpath.BootClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_BUILT_UNPACKED = 2;
    private static final int TYPE_BUILT_JAR = 3;
    private static final int TYPE_OTHER = -1;
    private static final String BUILD_CLASSES_DIR = "build.classes.dir";
    private static final String DIST_JAR = "dist.jar";
    private static final String DOC_BASE_DIR = "web.docbase.dir";
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final Reference<ClassPath>[] cache = new SoftReference[8];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.evaluator.getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject getBuildClassesDir() {
        return this.getDir(BUILD_CLASSES_DIR);
    }

    private FileObject getDistJar() {
        return this.getDir(DIST_JAR);
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir(DOC_BASE_DIR);
    }

    private int getType(FileObject fileObject) {
        FileObject fileObject2 = this.getDocumentBaseDir();
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return 2;
        }
        fileObject2 = this.getBuildClassesDir();
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return 3;
        }
        fileObject2 = this.getDistJar();
        if (fileObject2 != null && fileObject2.equals(FileUtil.getArchiveFile((FileObject)fileObject))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        return this.getCompileTimeClasspath(n);
    }

    private synchronized ClassPath getCompileTimeClasspath(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        if (n == 2) {
            n = 0;
        }
        ClassPath classPath = null;
        if (this.cache[3 + n] == null || (classPath = this.cache[3 + n].get()) == null) {
            if (n == 0) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath", "debug.classpath"}));
            }
            this.cache[3 + n] = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject fileObject) {
        int n = this.getType(fileObject);
        if (n < 0 || n > 4) {
            return null;
        }
        switch (n) {
            case 2: {
                n = 0;
                break;
            }
            case 3: 
            case 4: {
                n -= 3;
            }
        }
        ClassPath classPath = null;
        if (this.cache[6 + n] == null || (classPath = this.cache[6 + n].get()) == null) {
            if (n == 0) {
                classPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath"}));
            }
            this.cache[6 + n] = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath classPath = null;
        if (this.cache[7] == null || (classPath = this.cache[7].get()) == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
            this.cache[7] = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileObject);
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(string)) {
            ClassPath[] classPathArray = new ClassPath[]{this.getCompileTimeClasspath(0)};
            return classPathArray;
        }
        assert (false);
        return null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }
}

