/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.palette.UMLPaletteFactory;
import org.netbeans.modules.uml.palette.model.ModelingPaletteNodeDescriptor;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaSelectStateEnteredSink;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class PaletteSupport {
    private PaletteController pController = null;
    private PalettePropertyChangeListener propertyChangeListener = null;

    public PaletteController getPalette(IDrawingAreaControl iDrawingAreaControl) {
        String string = this.findPaletteRepository(iDrawingAreaControl.getDiagramKind());
        this.pController = UMLPaletteFactory.getPalette(string);
        if (this.pController != null) {
            this.propertyChangeListener = new PalettePropertyChangeListener(iDrawingAreaControl);
            this.pController.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
            this.initPaletteSettings();
            iDrawingAreaControl.addDrawingAreaToolSelectionSink((IDrawingAreaSelectStateEnteredSink)new DrawingAreaSelectStateEnteredListener(this.pController, this.propertyChangeListener));
        }
        return this.pController;
    }

    public void unregisterListeners() {
        if (this.pController != null) {
            this.pController.removePropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        }
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.setDrawingAreaControl(null);
            this.propertyChangeListener = null;
        }
    }

    private String findPaletteRepository(int n) {
        String string = null;
        switch (n) {
            case 4: {
                string = "UML/Palette/ClassDiagram";
                break;
            }
            case 2: {
                string = "UML/Palette/ActivityDiagram";
                break;
            }
            case 8: {
                string = "UML/Palette/CollaborationDiagram";
                break;
            }
            case 16: {
                string = "UML/Palette/ComponentDiagram";
                break;
            }
            case 32: {
                string = "UML/Palette/DeploymentDiagram";
                break;
            }
            case 64: {
                string = "UML/Palette/SequenceDiagram";
                break;
            }
            case 128: {
                string = "UML/Palette/StateDiagram";
                break;
            }
            case 256: {
                string = "UML/Palette/UsecaseDiagram";
            }
        }
        return string;
    }

    private void initPaletteSettings() {
        Lookup lookup = this.pController.getRoot();
        Node node = (Node)lookup.lookup(Node.class);
        if (node == null) {
            return;
        }
        Children children = node.getChildren();
        if (children != null) {
            Node node2 = null;
            Enumeration enumeration = children.nodes();
            while (enumeration.hasMoreElements()) {
                node2 = (Node)enumeration.nextElement();
                if (node2 == null) continue;
                node2.setValue("isExpanded", (Object)true);
            }
        }
    }

    private class DrawingAreaSelectStateEnteredListener
    implements IDrawingAreaSelectStateEnteredSink {
        PaletteController paletteController;
        PalettePropertyChangeListener listener;

        public DrawingAreaSelectStateEnteredListener(PaletteController paletteController, PalettePropertyChangeListener palettePropertyChangeListener) {
            this.paletteController = paletteController;
            this.listener = palettePropertyChangeListener;
        }

        public void onSelectToolSelected() {
            Log.out((String)"CreatePalette():DrawingAreaSelectStateEnteredListener(): resetting state");
            this.paletteController.removePropertyChangeListener((PropertyChangeListener)this.listener);
            this.paletteController.setSelectedItem(null, null);
            this.paletteController.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
    }

    private class PalettePropertyChangeListener
    implements PropertyChangeListener {
        private IDrawingAreaControl drawingAreaContrl1;

        public PalettePropertyChangeListener(IDrawingAreaControl iDrawingAreaControl) {
            this.drawingAreaContrl1 = iDrawingAreaControl;
        }

        public void setDrawingAreaControl(IDrawingAreaControl iDrawingAreaControl) {
            this.drawingAreaContrl1 = iDrawingAreaControl;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Log.out((String)("PalettePropertyChangeListener():propertyChange(): event is on " + string));
            if ("selectedItem".equals(string)) {
                Object object = propertyChangeEvent.getNewValue();
                Log.out((String)("PalettePropertyChangeListener():propertyChange(): Current selection is " + object));
                if (object != null) {
                    if (object instanceof Lookup) {
                        Lookup lookup = (Lookup)object;
                        Node node = (Node)lookup.lookup(Node.class);
                        if (node == null) {
                            this.drawingAreaContrl1.enterMode(0);
                            return;
                        }
                        InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(InstanceCookie.class);
                        if (instanceCookie != null) {
                            Object object2 = null;
                            try {
                                object2 = instanceCookie.instanceCreate();
                            }
                            catch (Exception exception) {
                                Log.out((String)("PalettePropertyChangeListener(): Error : " + exception));
                                ErrorManager.getDefault().notify(1, (Throwable)exception);
                            }
                            if (object2 instanceof ModelingPaletteNodeDescriptor) {
                                ModelingPaletteNodeDescriptor modelingPaletteNodeDescriptor = (ModelingPaletteNodeDescriptor)object2;
                                String string2 = modelingPaletteNodeDescriptor.getButtonID();
                                Log.out((String)("Button ID is " + string2));
                                if (this.drawingAreaContrl1 != null) {
                                    this.drawingAreaContrl1.setSelectedPaletteButton(string2);
                                    Log.out((String)"PalettePropertyChangeListener(): Calling entermodefromButton()");
                                    this.drawingAreaContrl1.enterModeFromButton(string2);
                                }
                            }
                        }
                    }
                } else {
                    this.drawingAreaContrl1.enterMode(0);
                }
            }
        }
    }
}

