/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CompactMap;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.StandaloneTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SnapshotTokenList<T extends TokenId>
implements TokenList<T> {
    private TokenHierarchyOperation<?, T> snapshot;
    private IncTokenList<T> liveTokenList;
    private int liveTokenGapStart = -1;
    private int liveTokenGapEnd;
    private int liveTokenGapStartOffset;
    private int liveTokenOffsetDiff;
    private Object[] origTokensOrBranches;
    private int[] origOffsets;
    private int origTokenStartIndex;
    private int origTokenCount;
    private CompactMap<AbstractToken<T>, Token2OffsetEntry<T>> token2offset;

    public int liveTokenGapStart() {
        return this.liveTokenGapStart;
    }

    public int liveTokenGapEnd() {
        return this.liveTokenGapEnd;
    }

    public SnapshotTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation) {
        this.snapshot = tokenHierarchyOperation;
        this.token2offset = new CompactMap();
    }

    public TokenHierarchyOperation<?, T> snapshot() {
        return this.snapshot;
    }

    @Override
    public LanguagePath languagePath() {
        return this.liveTokenList.languagePath();
    }

    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOrEmbeddingContainer(n);
        }
        if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origTokensOrBranches[this.origTokenStartIndex + n];
        }
        return this.liveTokenList.tokenOrEmbeddingContainer(this.liveTokenGapEnd + n - this.origTokenCount);
    }

    @Override
    public int lookahead(int n) {
        return -1;
    }

    @Override
    public Object state(int n) {
        return null;
    }

    @Override
    public int tokenOffset(int n) {
        int n2;
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            return this.liveTokenList.tokenOffset(n);
        }
        if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            return this.origOffsets[this.origTokenStartIndex + n];
        }
        AbstractToken abstractToken = LexerUtilsConstants.token(this.liveTokenList.tokenOrEmbeddingContainerUnsync(this.liveTokenGapEnd + (n -= this.origTokenCount)));
        if (abstractToken.isFlyweight()) {
            n2 = abstractToken.length();
            while (--n >= 0) {
                abstractToken = LexerUtilsConstants.token(this.liveTokenList.tokenOrEmbeddingContainerUnsync(this.liveTokenGapEnd + n));
                if (abstractToken.isFlyweight()) {
                    n2 += abstractToken.length();
                    continue;
                }
                n2 += this.tokenOffset(abstractToken, this.liveTokenList, abstractToken.rawOffset());
                break;
            }
            if (n == -1 && (n += this.liveTokenGapStart + this.origTokenCount) >= 0) {
                n2 += this.tokenOffset(n);
            }
        } else {
            n2 = this.tokenOffset(abstractToken, this.liveTokenList, abstractToken.rawOffset());
        }
        return n2;
    }

    public <TT extends TokenId> int tokenOffset(AbstractToken<TT> abstractToken, TokenList<TT> tokenList, int n) {
        if (tokenList.getClass() == EmbeddedTokenList.class) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)tokenList;
            AbstractToken<?> abstractToken2 = embeddedTokenList.rootToken();
            Token2OffsetEntry token2OffsetEntry = (Token2OffsetEntry)((Object)this.token2offset.get(abstractToken2));
            if (token2OffsetEntry != null) {
                return token2OffsetEntry.offset() + embeddedTokenList.childTokenOffsetShift(n);
            }
            int n2 = embeddedTokenList.childTokenOffset(n);
            TokenList<?> tokenList2 = embeddedTokenList.root();
            if (tokenList2 != null && tokenList2.getClass() == IncTokenList.class && n2 >= this.liveTokenGapStartOffset) {
                n2 += this.liveTokenOffsetDiff;
            }
            return n2;
        }
        Token2OffsetEntry token2OffsetEntry = (Token2OffsetEntry)((Object)this.token2offset.get(abstractToken));
        if (token2OffsetEntry != null) {
            return token2OffsetEntry.offset();
        }
        if (tokenList.getClass() == IncTokenList.class) {
            if ((n = tokenList.childTokenOffset(n)) >= this.liveTokenGapStartOffset) {
                n += this.liveTokenOffsetDiff;
            }
            return n;
        }
        return tokenList.childTokenOffset(n);
    }

    @Override
    public int tokenCount() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCount() : this.liveTokenList.tokenCount() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int tokenCountCurrent() {
        return this.liveTokenGapStart == -1 ? this.liveTokenList.tokenCountCurrent() : this.liveTokenList.tokenCountCurrent() - (this.liveTokenGapEnd - this.liveTokenGapStart) + this.origTokenCount;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int childTokenOffset(int n) {
        return n;
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        throw new IllegalStateException("Not expected to be called");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            this.liveTokenList.wrapToken(n, embeddingContainer);
        } else if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            this.origTokensOrBranches[this.origTokenStartIndex + n] = embeddingContainer;
        } else {
            this.liveTokenList.wrapToken(this.liveTokenGapEnd + n - this.origTokenCount, embeddingContainer);
        }
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        AbstractToken<T> abstractToken2;
        if (this.liveTokenGapStart == -1 || n < this.liveTokenGapStart) {
            abstractToken2 = this.liveTokenList.replaceFlyToken(n, abstractToken, n2);
        } else if ((n -= this.liveTokenGapStart) < this.origTokenCount) {
            this.origTokensOrBranches[this.origTokenStartIndex + n] = abstractToken2 = ((TextToken)abstractToken).createCopy(this, n2);
        } else {
            abstractToken2 = this.liveTokenList.replaceFlyToken(this.liveTokenGapEnd + n - this.origTokenCount, abstractToken, n2 - this.liveTokenOffsetDiff);
        }
        return abstractToken2;
    }

    @Override
    public TokenList<?> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.snapshot;
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.liveTokenList.inputAttributes();
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffset(n) + LexerUtilsConstants.token(this, n).length();
        }
        return 0;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    public boolean canModifyToken(int n, AbstractToken abstractToken) {
        return this.liveTokenGapStart != -1 && n >= this.liveTokenGapStart && n < this.liveTokenGapEnd && !this.token2offset.containsKey((Object)abstractToken);
    }

    public void update(TokenHierarchyEventInfo tokenHierarchyEventInfo, TokenListChange<T> tokenListChange) {
        Object object;
        AbstractToken abstractToken;
        int n;
        int n2;
        int n3;
        int n4;
        RemovedTokenList<T> removedTokenList = tokenListChange.tokenChangeInfo().removedTokenList();
        int n5 = tokenListChange.index();
        int n6 = n5 + removedTokenList.tokenCount();
        if (this.liveTokenGapStart == -1) {
            this.liveTokenGapStart = n5;
            this.liveTokenGapEnd = n5;
            this.liveTokenGapStartOffset = tokenListChange.offset();
            this.origTokensOrBranches = new Object[removedTokenList.tokenCount()];
            this.origOffsets = new int[this.origTokensOrBranches.length];
        }
        int n7 = tokenListChange.tokenChangeInfo().addedTokenCount() - removedTokenList.tokenCount();
        if (n5 < this.liveTokenGapStart) {
            Object object2;
            n4 = this.liveTokenGapStart - n5;
            this.ensureOrigTokensStartCapacity(n4);
            this.origTokenStartIndex -= n4;
            this.origTokenCount += n4;
            n3 = Math.min(n6, this.liveTokenGapStart);
            this.liveTokenGapStartOffset = n2 = tokenListChange.offset();
            for (n = n5; n < n3; ++n) {
                object2 = removedTokenList.tokenOrEmbeddingContainer(n - n5);
                abstractToken = LexerUtilsConstants.token(object2);
                if (!abstractToken.isFlyweight() && (object = abstractToken.tokenList()) == null) {
                    object = new StandaloneTokenList(tokenListChange.languagePath(), tokenHierarchyEventInfo.originalText().toCharArray(n2, n2 + abstractToken.length()));
                    abstractToken.setTokenList(object);
                }
                this.origOffsets[this.origTokenStartIndex] = n2;
                this.origTokensOrBranches[this.origTokenStartIndex++] = object2;
                n2 += abstractToken.length();
            }
            while (n < this.liveTokenGapStart) {
                object2 = this.liveTokenList.tokenOrEmbeddingContainerUnsync(n + n7);
                abstractToken = LexerUtilsConstants.token(object2);
                if (!abstractToken.isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(abstractToken, n2));
                }
                this.origOffsets[this.origTokenStartIndex] = n2;
                this.origTokensOrBranches[this.origTokenStartIndex++] = object2;
                n2 += abstractToken.length();
                ++n;
            }
            this.liveTokenGapStart = n5;
        }
        if (n6 > this.liveTokenGapEnd) {
            n4 = n6 - this.liveTokenGapEnd;
            this.ensureOrigTokensEndCapacity(n4);
            this.origTokenCount += n4;
            n3 = this.origTokenStartIndex + this.origTokenCount - 1;
            n = Math.max(n5, this.liveTokenGapEnd);
            n2 = n6;
            int n8 = tokenListChange.removedEndOffset();
            for (n2 = n6 - 1; n2 >= n; --n2) {
                TokenList tokenList;
                abstractToken = removedTokenList.tokenOrEmbeddingContainer(n2 - n5);
                object = LexerUtilsConstants.token(abstractToken);
                n8 -= ((AbstractToken)object).length();
                if (!((AbstractToken)object).isFlyweight() && (tokenList = ((AbstractToken)object).tokenList()) == null) {
                    tokenList = new StandaloneTokenList(tokenListChange.languagePath(), tokenHierarchyEventInfo.originalText().toCharArray(n8, n8 + ((AbstractToken)object).length()));
                    ((AbstractToken)object).setTokenList(tokenList);
                }
                this.origOffsets[n3] = n8 + this.liveTokenOffsetDiff;
                if (this.liveTokenOffsetDiff != 0) {
                    this.token2offset.putEntry(new Token2OffsetEntry(object, this.origOffsets[n3]));
                }
                this.origTokensOrBranches[n3--] = abstractToken;
            }
            while (n2 >= this.liveTokenGapEnd) {
                abstractToken = this.liveTokenList.tokenOrEmbeddingContainerUnsync(n2 + n7);
                object = LexerUtilsConstants.token(abstractToken);
                n8 -= ((AbstractToken)object).length();
                if (!((AbstractToken)object).isFlyweight()) {
                    this.token2offset.putEntry(new Token2OffsetEntry(object, n8));
                }
                this.origOffsets[n3] = n8 + this.liveTokenOffsetDiff;
                this.token2offset.putEntry(new Token2OffsetEntry(object, this.origOffsets[n3]));
                this.origTokensOrBranches[n3--] = abstractToken;
                --n2;
            }
            this.liveTokenGapEnd = n6;
        }
        this.liveTokenOffsetDiff += tokenHierarchyEventInfo.removedLength() - tokenHierarchyEventInfo.insertedLength();
        this.liveTokenGapEnd += n7;
    }

    private void ensureOrigTokensStartCapacity(int n) {
        if (n > this.origTokensOrBranches.length - this.origTokenCount) {
            Object[] objectArray = new Object[this.origTokensOrBranches.length * 3 / 2 + n];
            int[] nArray = new int[objectArray.length];
            int n2 = Math.max(n, (objectArray.length - (this.origTokenCount + n)) / 2);
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, objectArray, n2, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, nArray, n2, this.origTokenCount);
            this.origTokensOrBranches = objectArray;
            this.origOffsets = nArray;
            this.origTokenStartIndex = n2;
        } else if (n > this.origTokenStartIndex) {
            int n3 = this.origTokensOrBranches.length - this.origTokenCount;
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, this.origTokensOrBranches, n3, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, n3, this.origTokenCount);
            this.origTokenStartIndex = this.origTokensOrBranches.length - this.origTokenCount;
        }
    }

    private void ensureOrigTokensEndCapacity(int n) {
        if (n > this.origTokensOrBranches.length - this.origTokenCount) {
            Object[] objectArray = new Object[this.origTokensOrBranches.length * 3 / 2 + n];
            int[] nArray = new int[objectArray.length];
            int n2 = (objectArray.length - (this.origTokenCount + n)) / 2;
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, objectArray, n2, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, nArray, n2, this.origTokenCount);
            this.origTokensOrBranches = objectArray;
            this.origOffsets = nArray;
            this.origTokenStartIndex = n2;
        } else if (n > this.origTokensOrBranches.length - this.origTokenCount - this.origTokenStartIndex) {
            System.arraycopy(this.origTokensOrBranches, this.origTokenStartIndex, this.origTokensOrBranches, 0, this.origTokenCount);
            System.arraycopy(this.origOffsets, this.origTokenStartIndex, this.origOffsets, 0, this.origTokenCount);
            this.origTokenStartIndex = 0;
        }
    }

    public String toString() {
        return "liveTokenGapStart=" + this.liveTokenGapStart + ", liveTokenGapEnd=" + this.liveTokenGapEnd + ", liveTokenGapStartOffset=" + this.liveTokenGapStartOffset + ", liveTokenOffsetDiff=" + this.liveTokenOffsetDiff + ",\n origTokenStartIndex=" + this.origTokenStartIndex + ", origTokenCount=" + this.origTokenCount + ", token2offset: " + this.token2offset;
    }

    public int tokenShiftStartOffset() {
        return this.liveTokenGapStartOffset;
    }

    public int tokenShiftEndOffset() {
        return this.liveTokenGapStartOffset + this.liveTokenOffsetDiff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Token2OffsetEntry<T extends TokenId>
    extends CompactMap.MapEntry<AbstractToken<T>, Token2OffsetEntry<T>> {
        private final AbstractToken<T> token;
        private final int offset;

        Token2OffsetEntry(AbstractToken<T> abstractToken, int n) {
            this.token = abstractToken;
            this.offset = n;
        }

        public AbstractToken<T> getKey() {
            return this.token;
        }

        public Token2OffsetEntry<T> getValue() {
            return this;
        }

        protected int valueHashCode() {
            return this.offset;
        }

        protected boolean valueEquals(Object object) {
            return object instanceof Token2OffsetEntry && ((Token2OffsetEntry)((Object)object)).offset() == this.offset();
        }

        public int offset() {
            return this.offset;
        }

        public Token2OffsetEntry<T> setValue(Token2OffsetEntry<T> token2OffsetEntry) {
            throw new IllegalStateException("Prohibited");
        }

        public String toString() {
            return String.valueOf(this.offset);
        }
    }
}

