/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.util.ArrayList;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchTokenList<T extends TokenId>
extends ArrayList<Object>
implements TokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    private static boolean maintainLAState;
    private final TokenHierarchyOperation<?, T> tokenHierarchyOperation;
    private final LanguagePath languagePath;
    private final Set<T> skipTokenIds;
    private final InputAttributes inputAttributes;
    private LexerInputOperation<T> lexerInputOperation;
    private LAState laState;
    private boolean inited;

    public static boolean isMaintainLAState() {
        return maintainLAState;
    }

    public static void setMaintainLAState(boolean bl) {
        maintainLAState = bl;
    }

    public BatchTokenList(TokenHierarchyOperation<?, T> tokenHierarchyOperation, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        this.tokenHierarchyOperation = tokenHierarchyOperation;
        this.languagePath = LanguagePath.get(language);
        this.skipTokenIds = set;
        this.inputAttributes = inputAttributes;
        if (testing) {
            this.laState = LAState.empty();
        }
    }

    @Override
    public abstract char childTokenCharAt(int var1, int var2);

    protected abstract LexerInputOperation<T> createLexerInputOperation();

    protected void init() {
        this.lexerInputOperation = this.createLexerInputOperation();
    }

    @Override
    public TokenList<?> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenHierarchyOperation;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public synchronized int tokenCount() {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        if (this.lexerInputOperation != null) {
            this.tokenOrEmbeddingContainerImpl(Integer.MAX_VALUE);
        }
        return this.size();
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public int childTokenOffset(int n) {
        return n;
    }

    @Override
    public int tokenOffset(int n) {
        int n2;
        Token<T> token = this.existingToken(n);
        if (token.isFlyweight()) {
            n2 = 0;
            while (--n >= 0) {
                token = this.existingToken(n);
                n2 += token.length();
                if (token.isFlyweight()) continue;
                n2 += token.offset(null);
                break;
            }
        } else {
            n2 = token.offset(null);
        }
        return n2;
    }

    @Override
    public synchronized Object tokenOrEmbeddingContainer(int n) {
        return this.tokenOrEmbeddingContainerImpl(n);
    }

    private Object tokenOrEmbeddingContainerImpl(int n) {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        while (this.lexerInputOperation != null && n >= this.size()) {
            AbstractToken<T> abstractToken = this.lexerInputOperation.nextToken();
            if (abstractToken != null) {
                this.add(abstractToken);
                if (this.laState == null) continue;
                this.laState = this.laState.add(this.lexerInputOperation.lookahead(), this.lexerInputOperation.lexerState());
                continue;
            }
            this.lexerInputOperation.release();
            this.lexerInputOperation = null;
            this.trimToSize();
        }
        return n < this.size() ? this.get(n) : null;
    }

    private Token<T> existingToken(int n) {
        return LexerUtilsConstants.token(this.get(n));
    }

    @Override
    public int lookahead(int n) {
        return this.laState != null ? this.laState.lookahead(n) : -1;
    }

    @Override
    public Object state(int n) {
        return this.laState != null ? this.laState.state(n) : null;
    }

    @Override
    public int startOffset() {
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffset(n) + LexerUtilsConstants.token(this, n).length();
        }
        return 0;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken = ((TextToken)abstractToken).createCopy(this, n2);
        this.set(n, textToken);
        return textToken;
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        this.set(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public boolean isContinuous() {
        return this.skipTokenIds == null;
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.skipTokenIds;
    }
}

