/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingContainer<T extends TokenId> {
    private AbstractToken<T> token;
    private int cachedModCount;
    private final TokenList<?> rootTokenList;
    private AbstractToken<?> rootToken;
    private int tokenStartOffset;
    private EmbeddedTokenList<?> firstEmbeddedTokenList;
    private int offsetShiftFromRootToken;
    private EmbeddedTokenList<?> defaultEmbeddedTokenList;
    private static boolean checkStatusUpdatedThrowingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> embeddedTokenList(TokenList<T> tokenList, int n, Language<ET> language) {
        TokenList<?> tokenList2;
        TokenList<?> tokenList3 = tokenList2 = tokenList.root();
        synchronized (tokenList3) {
            EmbeddedTokenList<?> embeddedTokenList;
            EmbeddingPresence embeddingPresence;
            AbstractToken<T> abstractToken;
            EmbeddingContainer<T> embeddingContainer;
            Object object;
            Object object2 = tokenList.tokenOrEmbeddingContainer(n);
            if (object2.getClass() == EmbeddingContainer.class) {
                object = (EmbeddingContainer<T>)object2;
                embeddingContainer = object;
                abstractToken = embeddingContainer.token();
                embeddingPresence = null;
            } else {
                embeddingContainer = null;
                object = (AbstractToken)object2;
                abstractToken = object;
                embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
                if (embeddingPresence == EmbeddingPresence.NONE) {
                    return null;
                }
            }
            if (embeddingContainer != null) {
                embeddingContainer.updateStatusImpl();
                object = null;
                for (embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    if (language == null || embeddedTokenList.languagePath().innerLanguage() == language) {
                        EmbeddedTokenList<?> embeddedTokenList2 = embeddedTokenList;
                        return embeddedTokenList2;
                    }
                    object = embeddedTokenList;
                }
                if (embeddingContainer.defaultEmbeddedTokenList() != null) {
                    return null;
                }
            } else {
                object = null;
            }
            if (tokenList.isRemoved()) {
                return null;
            }
            embeddedTokenList = tokenList.languagePath();
            LanguageHierarchy languageHierarchy = LexerUtilsConstants.innerLanguageHierarchy((LanguagePath)((Object)embeddedTokenList));
            LanguageEmbedding<?> languageEmbedding = LexerUtilsConstants.findEmbedding(languageHierarchy, abstractToken, (LanguagePath)((Object)embeddedTokenList), tokenList.inputAttributes());
            if (embeddingPresence == null) {
                embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
            }
            if (languageEmbedding != null) {
                CharSequence charSequence;
                if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                    LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.ALWAYS_QUERY);
                }
                if ((charSequence = abstractToken.text()) == null || languageEmbedding.startSkipLength() + languageEmbedding.endSkipLength() > charSequence.length()) {
                    return null;
                }
                if (embeddingContainer == null) {
                    embeddingContainer = new EmbeddingContainer<T>(abstractToken, tokenList2);
                    tokenList.wrapToken(n, embeddingContainer);
                }
                LanguagePath languagePath = LanguagePath.get(embeddedTokenList, languageEmbedding.language());
                EmbeddedTokenList embeddedTokenList3 = new EmbeddedTokenList(embeddingContainer, languagePath, languageEmbedding, null);
                embeddingContainer.addEmbeddedTokenList((EmbeddedTokenList<?>)object, embeddedTokenList3, true);
                return language == null || language == languageEmbedding.language() ? embeddedTokenList3 : null;
            }
            if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.NONE);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int n, Language<ET> language, int n2, int n3, boolean bl) {
        TokenHierarchyEventInfo tokenHierarchyEventInfo;
        int n4;
        EmbeddedTokenList<ET> embeddedTokenList;
        LanguageEmbedding<ET> languageEmbedding;
        TokenChangeInfo<ET> tokenChangeInfo;
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation;
        TokenList<?> tokenList2 = tokenList.root();
        Object object = tokenList2;
        synchronized (object) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (tokenList.isRemoved()) {
                return false;
            }
            tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            tokenChangeInfo = tokenList.tokenOrEmbeddingContainer(n);
            if (tokenChangeInfo.getClass() == EmbeddingContainer.class) {
                object4 = object5 = (EmbeddingContainer)((Object)tokenChangeInfo);
                for (object3 = ((EmbeddingContainer)object4).firstEmbeddedTokenList(); object3 != null; object3 = ((EmbeddedTokenList)object3).nextEmbeddedTokenList()) {
                    if (language != ((EmbeddedTokenList)object3).languagePath().innerLanguage()) continue;
                    return false;
                }
                object2 = ((EmbeddingContainer)object4).token();
            } else {
                object5 = (AbstractToken)((Object)tokenChangeInfo);
                object2 = object5;
                if (((AbstractToken)object2).isFlyweight()) {
                    return false;
                }
                object4 = new EmbeddingContainer<T>(object2, tokenList2);
                tokenList.wrapToken(n, (EmbeddingContainer<T>)object4);
            }
            if (n2 + n3 > ((AbstractToken)object2).length()) {
                return false;
            }
            languageEmbedding = LanguageEmbedding.create(language, n2, n3, bl);
            object5 = tokenList.languagePath();
            object3 = LanguagePath.get((LanguagePath)object5, language);
            tokenHierarchyOperation.addLanguagePath((LanguagePath)object3);
            embeddedTokenList = new EmbeddedTokenList<ET>((EmbeddingContainer<?>)object4, (LanguagePath)object3, languageEmbedding, ((EmbeddingContainer)object4).firstEmbeddedTokenList());
            ((EmbeddingContainer)object4).addEmbeddedTokenList(null, embeddedTokenList, false);
            n4 = ((EmbeddingContainer)object4).tokenStartOffset();
            tokenHierarchyEventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_CREATED, n4, 0, "", 0);
            tokenHierarchyEventInfo.setMaxAffectedEndOffset(n4 + ((AbstractToken)object2).length());
            TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(embeddedTokenList.languagePath());
            if (tokenListList != null) {
                new TokenHierarchyUpdate(tokenHierarchyEventInfo).updateCreateEmbedding(embeddedTokenList);
            } else if (languageEmbedding.joinSections()) {
                tokenListList = tokenHierarchyOperation.tokenListList(embeddedTokenList.languagePath());
            }
        }
        object = new TokenChangeInfo<T>(tokenList);
        ((TokenChangeInfo)object).setIndex(n);
        ((TokenChangeInfo)object).setOffset(n4);
        tokenHierarchyEventInfo.setTokenChangeInfo((TokenChangeInfo<?>)object);
        tokenChangeInfo = new TokenChangeInfo<ET>(embeddedTokenList);
        tokenChangeInfo.setIndex(0);
        tokenChangeInfo.setOffset(n4 + languageEmbedding.startSkipLength());
        ((TokenChangeInfo)object).addEmbeddedChange(tokenChangeInfo);
        tokenHierarchyOperation.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean removeEmbedding(TokenList<T> tokenList, int n, Language<ET> language) {
        TokenList<?> tokenList2;
        TokenList<?> tokenList3 = tokenList2 = tokenList.root();
        synchronized (tokenList3) {
            if (tokenList.isRemoved()) {
                return false;
            }
            TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
            tokenHierarchyOperation.ensureWriteLocked();
            Object object = tokenList.tokenOrEmbeddingContainer(n);
            if (object.getClass() == EmbeddingContainer.class) {
                EmbeddingContainer<T> embeddingContainer;
                EmbeddingContainer<T> embeddingContainer2 = embeddingContainer = (EmbeddingContainer<T>)object;
                embeddingContainer2.updateStatusImpl();
                EmbeddedTokenList<?> embeddedTokenList = null;
                for (EmbeddedTokenList<T> embeddedTokenList2 = embeddingContainer2.firstEmbeddedTokenList(); embeddedTokenList2 != null; embeddedTokenList2 = embeddedTokenList2.nextEmbeddedTokenList()) {
                    if (language != embeddedTokenList2.languagePath().innerLanguage()) continue;
                    embeddingContainer2.removeEmbeddedTokenList(embeddedTokenList, embeddedTokenList2);
                    embeddingContainer2 = new EmbeddingContainer<T>(embeddingContainer2);
                    embeddingContainer2.addEmbeddedTokenList(null, embeddedTokenList2, false);
                    embeddedTokenList2.setEmbeddingContainer(embeddingContainer2);
                    embeddingContainer2.invalidateChildren();
                    int n2 = embeddingContainer2.tokenStartOffset();
                    TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_REMOVED, n2, 0, "", 0);
                    tokenHierarchyEventInfo.setMaxAffectedEndOffset(n2 + embeddingContainer2.token().length());
                    TokenChangeInfo<T> tokenChangeInfo = new TokenChangeInfo<T>(tokenList);
                    tokenChangeInfo.setIndex(n);
                    tokenChangeInfo.setOffset(n2);
                    tokenHierarchyEventInfo.setTokenChangeInfo(tokenChangeInfo);
                    EmbeddedTokenList<T> embeddedTokenList3 = embeddedTokenList2;
                    TokenChangeInfo tokenChangeInfo2 = new TokenChangeInfo(embeddedTokenList3);
                    tokenChangeInfo2.setIndex(0);
                    tokenChangeInfo2.setOffset(n2 + embeddedTokenList2.embedding().startSkipLength());
                    tokenChangeInfo.addEmbeddedChange(tokenChangeInfo2);
                    TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(embeddedTokenList2.languagePath());
                    if (tokenListList != null) {
                        new TokenHierarchyUpdate(tokenHierarchyEventInfo).updateRemoveEmbedding(embeddedTokenList2);
                    }
                    tokenHierarchyOperation.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
                    return true;
                }
            }
        }
        return false;
    }

    EmbeddingContainer(AbstractToken<T> abstractToken, TokenList<?> tokenList) {
        this.token = abstractToken;
        this.rootTokenList = tokenList;
        this.rootToken = abstractToken;
        this.cachedModCount = -2;
        this.updateStatusImpl();
    }

    EmbeddingContainer(EmbeddingContainer<T> embeddingContainer) {
        this(embeddingContainer.token(), embeddingContainer.rootTokenList());
    }

    private void invalidate() {
        this.rootToken = null;
        this.cachedModCount = -2;
    }

    void invalidateChildren() {
        for (EmbeddedTokenList<?> embeddedTokenList = this.firstEmbeddedTokenList; embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
            for (int i = embeddedTokenList.tokenCountCurrent() - 1; i >= 0; --i) {
                Object object = embeddedTokenList.tokenOrEmbeddingContainerUnsync(i);
                if (object.getClass() != EmbeddingContainer.class) continue;
                ((EmbeddingContainer)object).invalidateChildren();
            }
        }
    }

    public int cachedModCount() {
        return this.cachedModCount;
    }

    public void checkStatusUpdated() {
        if (this.cachedModCount != -2 && this.cachedModCount != this.rootTokenList.modCount() && !checkStatusUpdatedThrowingException) {
            checkStatusUpdatedThrowingException = true;
            String string = "!!!INTERNAL ERROR!!! Status not updated on " + this + "\nin token hierarchy\n" + this.rootTokenList.tokenHierarchyOperation();
            checkStatusUpdatedThrowingException = false;
            throw new IllegalStateException(string);
        }
    }

    public AbstractToken<T> token() {
        return this.token;
    }

    public void reinit(AbstractToken<T> abstractToken) {
        this.token = abstractToken;
        TokenList<T> tokenList = abstractToken.tokenList();
        assert (tokenList != null);
        this.rootToken = tokenList.getClass() == EmbeddedTokenList.class ? ((EmbeddedTokenList)tokenList).rootToken() : abstractToken;
        this.updateStatusImpl();
    }

    public TokenList<?> rootTokenList() {
        return this.rootTokenList;
    }

    public AbstractToken<?> rootToken() {
        return this.rootToken;
    }

    public int tokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int rootTokenOffsetShift() {
        return this.offsetShiftFromRootToken;
    }

    public char charAt(int n) {
        return this.rootToken.charAt(this.offsetShiftFromRootToken + n);
    }

    public EmbeddedTokenList<?> firstEmbeddedTokenList() {
        return this.firstEmbeddedTokenList;
    }

    public void addEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2, boolean bl) {
        if (embeddedTokenList != null) {
            embeddedTokenList2.setNextEmbeddedTokenList(embeddedTokenList.nextEmbeddedTokenList());
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList2);
        } else {
            embeddedTokenList2.setNextEmbeddedTokenList(this.firstEmbeddedTokenList);
            this.firstEmbeddedTokenList = embeddedTokenList2;
        }
        if (bl) {
            this.defaultEmbeddedTokenList = embeddedTokenList2;
        }
    }

    public EmbeddedTokenList<?> removeEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2) {
        EmbeddedTokenList<?> embeddedTokenList3 = embeddedTokenList2.nextEmbeddedTokenList();
        if (embeddedTokenList != null) {
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList3);
        } else {
            this.firstEmbeddedTokenList = embeddedTokenList3;
        }
        embeddedTokenList2.setNextEmbeddedTokenList(null);
        if (this.defaultEmbeddedTokenList == embeddedTokenList2) {
            this.defaultEmbeddedTokenList = null;
        }
        return embeddedTokenList3;
    }

    public EmbeddedTokenList<?> defaultEmbeddedTokenList() {
        return this.defaultEmbeddedTokenList;
    }

    public boolean isRemoved() {
        return this.rootToken == null;
    }

    public void updateStatusAndInvalidate() {
        this.updateStatusImpl();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus() {
        TokenList<?> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.updateStatusImpl() != null;
        }
    }

    public AbstractToken<?> updateStatusImpl() {
        if (this.rootToken == null) {
            return null;
        }
        int n = this.rootTokenList.modCount();
        if (this.cachedModCount != n) {
            this.cachedModCount = n;
            TokenList<T> tokenList = this.token.tokenList();
            if (tokenList == null) {
                this.rootToken = null;
            } else if (tokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)tokenList;
                this.rootToken = embeddedTokenList.embeddingContainer().updateStatusImpl();
                this.tokenStartOffset = embeddedTokenList.childTokenOffsetNoUpdate(this.token.rawOffset());
                EmbeddingContainer<?> embeddingContainer = embeddedTokenList.embeddingContainer();
                this.offsetShiftFromRootToken = this.tokenStartOffset - embeddingContainer.tokenStartOffset() + embeddingContainer.rootTokenOffsetShift();
            } else {
                this.rootToken = this.token;
                this.tokenStartOffset = this.token.offset(null);
                this.offsetShiftFromRootToken = 0;
            }
        }
        return this.rootToken;
    }
}

