/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.FlyOffsetGapList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LAState;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TextLexerInputOperation;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;
import org.netbeans.spi.lexer.LanguageEmbedding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedTokenList<T extends TokenId>
extends FlyOffsetGapList<Object>
implements MutableTokenList<T> {
    private static final boolean testing = Boolean.getBoolean("netbeans.debug.lexer.test");
    public static final EmbeddedTokenList<TokenId> NO_DEFAULT_EMBEDDING = new EmbeddedTokenList(null, null, null, null);
    private EmbeddingContainer<?> embeddingContainer;
    private final LanguageEmbedding<T> embedding;
    private final LanguagePath languagePath;
    private LAState laState;
    private EmbeddedTokenList<?> nextEmbeddedTokenList;

    public EmbeddedTokenList(EmbeddingContainer<?> embeddingContainer, LanguagePath languagePath, LanguageEmbedding<T> languageEmbedding, EmbeddedTokenList<?> embeddedTokenList) {
        this.embeddingContainer = embeddingContainer;
        this.languagePath = languagePath;
        this.embedding = languageEmbedding;
        this.nextEmbeddedTokenList = embeddedTokenList;
        if (embeddingContainer != null) {
            this.laState = LAState.initState();
            embeddingContainer.updateStatusImpl();
        }
    }

    private void init() {
        if (this.embedding.joinSections()) {
            this.root().tokenHierarchyOperation().tokenListList(this.languagePath);
        } else {
            this.init(null);
        }
    }

    public void init(Object object) {
        this.laState = this.modCount() != -1 || testing ? LAState.empty() : null;
        LexerInputOperation<T> lexerInputOperation = this.createLexerInputOperation(0, this.startOffset(), object);
        AbstractToken<T> abstractToken = lexerInputOperation.nextToken();
        while (abstractToken != null) {
            this.updateElementOffsetAdd(abstractToken);
            this.add(abstractToken);
            if (this.laState != null) {
                this.laState = this.laState.add(lexerInputOperation.lookahead(), lexerInputOperation.lexerState());
            }
            abstractToken = lexerInputOperation.nextToken();
        }
        lexerInputOperation.release();
        lexerInputOperation = null;
        this.trimToSize();
        if (this.laState != null) {
            this.laState.trimToSize();
        }
    }

    public boolean isInited() {
        return this.laState != LAState.initState();
    }

    EmbeddedTokenList<?> nextEmbeddedTokenList() {
        return this.nextEmbeddedTokenList;
    }

    void setNextEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList) {
        this.nextEmbeddedTokenList = embeddedTokenList;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public LanguageEmbedding embedding() {
        return this.embedding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tokenCount() {
        TokenList<?> tokenList = this.root();
        synchronized (tokenList) {
            if (this.laState == LAState.initState()) {
                this.init();
            }
            return this.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        TokenList<?> tokenList = this.root();
        synchronized (tokenList) {
            if (this.laState == LAState.initState()) {
                this.init();
            }
            return n < this.size() ? this.get(n) : null;
        }
    }

    private Token existingToken(int n) {
        return LexerUtilsConstants.token(this.tokenOrEmbeddingContainer(n));
    }

    @Override
    public int lookahead(int n) {
        return this.laState != null ? this.laState.lookahead(n) : -1;
    }

    @Override
    public Object state(int n) {
        return this.laState != null ? this.laState.state(n) : null;
    }

    @Override
    public int tokenOffset(int n) {
        return this.elementOffset(n);
    }

    @Override
    public int childTokenOffset(int n) {
        this.embeddingContainer.updateStatus();
        return this.childTokenOffsetNoUpdate(n);
    }

    public int childTokenOffsetNoUpdate(int n) {
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength() + this.childTokenRelOffset(n);
    }

    public int childTokenOffsetShift(int n) {
        this.embeddingContainer.updateStatus();
        return this.embeddingContainer.rootTokenOffsetShift() + this.childTokenRelOffset(n);
    }

    private int childTokenRelOffset(int n) {
        return n < this.offsetGapStart() ? n : n - this.offsetGapLength();
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        return this.embeddingContainer.charAt(this.embedding.startSkipLength() + this.childTokenRelOffset(n) + n2);
    }

    @Override
    public int modCount() {
        return this.embeddingContainer.cachedModCount();
    }

    @Override
    public int startOffset() {
        return this.embeddingContainer.tokenStartOffset() + this.embedding.startSkipLength();
    }

    @Override
    public int endOffset() {
        return this.embeddingContainer.tokenStartOffset() + this.embeddingContainer.token().length() - this.embedding.endSkipLength();
    }

    @Override
    public boolean isRemoved() {
        this.embeddingContainer.updateStatusImpl();
        return this.embeddingContainer.isRemoved();
    }

    @Override
    public TokenList<?> root() {
        return this.embeddingContainer.rootTokenList();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.root().tokenHierarchyOperation();
    }

    public AbstractToken<?> rootToken() {
        return this.embeddingContainer.rootToken();
    }

    protected int elementRawOffset(Object object) {
        return object.getClass() == EmbeddingContainer.class ? ((EmbeddingContainer)object).token().rawOffset() : ((AbstractToken)object).rawOffset();
    }

    protected void setElementRawOffset(Object object, int n) {
        if (object.getClass() == EmbeddingContainer.class) {
            ((EmbeddingContainer)object).token().setRawOffset(n);
        } else {
            ((AbstractToken)object).setRawOffset(n);
        }
    }

    protected boolean isElementFlyweight(Object object) {
        return object.getClass() != EmbeddingContainer.class && ((AbstractToken)object).isFlyweight();
    }

    protected int elementLength(Object object) {
        return LexerUtilsConstants.token(object).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TokenList<?> tokenList = this.root();
        synchronized (tokenList) {
            TextToken textToken = ((TextToken)abstractToken).createCopy(this, this.offset2Raw(n2));
            this.set(n, textToken);
            return textToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        TokenList<?> tokenList = this.root();
        synchronized (tokenList) {
            this.set(n, embeddingContainer);
        }
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.root().inputAttributes();
    }

    @Override
    public Object tokenOrEmbeddingContainerUnsync(int n) {
        return this.get(n);
    }

    @Override
    public int tokenCountCurrent() {
        return this.size();
    }

    @Override
    public LexerInputOperation<T> createLexerInputOperation(int n, int n2, Object object) {
        CharSequence charSequence = this.embeddingContainer.token().text();
        int n3 = this.embeddingContainer.tokenStartOffset();
        if (charSequence == null) {
            throw new IllegalStateException("Text of parent token is null. tokenStartOffset=" + n3 + ", tokenIndex=" + n + ", relexOffset=" + n2 + ", relexState=" + object + ", languagePath=" + this.languagePath() + ", inited=" + this.isInited());
        }
        int n4 = n3 + charSequence.length() - this.embedding.endSkipLength();
        return new TextLexerInputOperation(this, n, object, charSequence, n3, n2, n4);
    }

    @Override
    public boolean isFullyLexed() {
        return true;
    }

    @Override
    public void replaceTokens(TokenListChange<T> tokenListChange, int n, int n2) {
        AbstractToken abstractToken;
        Object object2;
        List<Object> list;
        int n3;
        int n4 = tokenListChange.index();
        Object[] objectArray = new Object[n];
        this.copyElements(n4, n4 + n, objectArray, 0);
        int n5 = tokenListChange.offset();
        for (n3 = 0; n3 < n; ++n3) {
            list = objectArray[n3];
            if (list.getClass() == EmbeddingContainer.class) {
                object2 = (EmbeddingContainer)((Object)list);
                ((EmbeddingContainer)object2).updateStatusAndInvalidate();
                abstractToken = ((EmbeddingContainer)object2).token();
            } else {
                abstractToken = (AbstractToken)((Object)list);
            }
            if (!abstractToken.isFlyweight()) {
                this.updateElementOffsetRemove(abstractToken);
                abstractToken.setTokenList(null);
            }
            n5 += abstractToken.length();
        }
        this.remove(n4, n);
        this.laState.remove(n4, n);
        tokenListChange.setRemovedTokens(objectArray);
        tokenListChange.setRemovedEndOffset(n5);
        n3 = this.startOffset();
        if (this.offsetGapStart() != tokenListChange.offset() - n3) {
            this.moveOffsetGap(tokenListChange.offset() - n3, Math.min(n4, tokenListChange.offsetGapIndex()));
        }
        this.updateOffsetGapLength(-n2);
        list = tokenListChange.addedTokensOrBranches();
        if (list != null) {
            for (Object object2 : list) {
                AbstractToken abstractToken2 = (AbstractToken)object2;
                this.updateElementOffsetAdd(abstractToken2);
            }
            this.addAll(n4, list);
            this.laState = this.laState.addAll(n4, tokenListChange.laState());
            tokenListChange.syncAddedTokenCount();
            if (n == 1 && list.size() == 1) {
                abstractToken = LexerUtilsConstants.token(objectArray[0]);
                object2 = tokenListChange.addedToken(0);
                if (abstractToken.id() == ((AbstractToken)object2).id() && abstractToken.partType() == ((AbstractToken)object2).partType()) {
                    tokenListChange.markBoundsChange();
                }
            }
        }
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }

    public EmbeddingContainer<?> embeddingContainer() {
        return this.embeddingContainer;
    }

    public void setEmbeddingContainer(EmbeddingContainer<?> embeddingContainer) {
        this.embeddingContainer = embeddingContainer;
    }

    public String toStringHeader() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("ETL: <").append(this.startOffset());
        stringBuilder.append(",").append(this.endOffset());
        stringBuilder.append(">");
        stringBuilder.append(" IHC=").append(System.identityHashCode(this));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.toStringHeader());
        LexerUtilsConstants.appendTokenList(stringBuilder, this);
        return stringBuilder.toString();
    }
}

