/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.xml.nbprefuse.util.GraphUtilities;
import org.openide.util.NbBundle;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.visual.AggregateItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public final class NodeExpansionMouseControl
extends ControlAdapter {
    private JPopupMenu popup = new JPopupMenu();
    private VisualItem vItem;
    private JMenuItem menuItem = new JMenuItem();

    public NodeExpansionMouseControl(final Visualization visualization, final String string) {
        this.menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NodeExpansionMouseControl.this.vItem != null && NodeExpansionMouseControl.this.vItem instanceof VisualItem) {
                    NodeItem nodeItem = null;
                    nodeItem = NodeExpansionMouseControl.this.vItem.canGetBoolean("is-file-group-aggregate") && NodeExpansionMouseControl.this.vItem.getBoolean("is-file-group-aggregate") ? NodeExpansionMouseControl.this.findFileNode(NodeExpansionMouseControl.this.vItem.getInt("id"), (VisualItem)AggregateItem.class.cast(NodeExpansionMouseControl.this.vItem)) : (NodeItem)NodeItem.class.cast(NodeExpansionMouseControl.this.vItem);
                    if (nodeItem.canGetBoolean("is-file-node") && nodeItem.getBoolean("is-file-node")) {
                        GraphUtilities.expandCollapseFileNode(nodeItem);
                        if (string != null) {
                            visualization.run(string);
                        }
                    }
                }
            }
        });
        this.popup.add(this.menuItem);
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        super.itemReleased(visualItem, mouseEvent);
        this.vItem = visualItem;
        this.maybeShowPopup(mouseEvent);
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        super.itemPressed(visualItem, mouseEvent);
        this.vItem = visualItem;
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            NodeItem nodeItem = null;
            if (this.vItem.canGetBoolean("is-file-group-aggregate") && this.vItem.getBoolean("is-file-group-aggregate")) {
                nodeItem = this.findFileNode(this.vItem.getInt("id"), (VisualItem)AggregateItem.class.cast(this.vItem));
            }
            if (this.vItem.canGetBoolean("is-file-node") && this.vItem.getBoolean("is-file-node")) {
                nodeItem = (NodeItem)NodeItem.class.cast(this.vItem);
            }
            if (nodeItem == null) {
                return;
            }
            boolean bl = nodeItem.getBoolean("is-expanded");
            this.menuItem.setText(NbBundle.getMessage(NodeExpansionMouseControl.class, (String)(bl ? "LBL_collapse" : "LBL_expand")));
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private NodeItem findFileNode(int n, VisualItem visualItem) {
        NodeItem nodeItem = null;
        AggregateItem aggregateItem = (AggregateItem)AggregateItem.class.cast(visualItem);
        Iterator iterator = aggregateItem.items();
        while (iterator.hasNext()) {
            VisualItem visualItem2 = (VisualItem)iterator.next();
            int n2 = -1;
            if (!visualItem2.canGetInt("file-node-file-group") || (n2 = visualItem2.getInt("file-node-file-group")) != n || !visualItem2.canGetBoolean("is-expanded")) continue;
            nodeItem = (NodeItem)NodeItem.class.cast(visualItem2);
            break;
        }
        return nodeItem;
    }
}

