/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.RSSFeed;
import org.netbeans.modules.welcome.content.RSSFeedReaderPanel;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.content.WebLink;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Utilities;

class DemoPanel
extends RSSFeedReaderPanel {
    public DemoPanel() {
        super(BundleSupport.getURL("Demo"));
    }

    protected JComponent buildContent(String string, boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        DemoRSSFeed demoRSSFeed = new DemoRSSFeed(string);
        jPanel.add((Component)demoRSSFeed, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.buildBottomContent(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    protected JComponent buildBottomContent() {
        WebLink webLink = new WebLink("AllDemos", false);
        BundleSupport.setAccessibilityProperties(webLink, "AllDemos");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)webLink, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private static class MaxSizeImageIcon
    implements Icon,
    Constants {
        private static final int MAX_IMAGE_WIDTH = 202;
        private static final int MAX_IMAGE_HEIGHT = 142;
        private Image content;
        private Image frame;

        public MaxSizeImageIcon(Image image) {
            this.content = image;
            this.frame = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/picture_frame.png");
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = n;
            int n4 = n2;
            if (this.content.getWidth(null) > 202) {
                n3 += (this.content.getWidth(null) - 202) / 2;
            }
            if (this.content.getHeight(null) > 142) {
                n4 += (this.content.getHeight(null) - 142) / 2;
            }
            graphics.drawImage(this.content, n, n2, n + Math.min(202, this.content.getWidth(null)), n2 + Math.min(142, this.content.getHeight(null)), n3, n4, n3 + Math.min(202, this.content.getWidth(null)), n4 + Math.min(142, this.content.getHeight(null)), null);
            graphics.drawImage(this.frame, n, n2, component);
        }

        public int getIconWidth() {
            return 202;
        }

        public int getIconHeight() {
            return 142;
        }
    }

    private static class ImageLabel
    extends JLabel
    implements Constants,
    MouseListener {
        private String url;
        private boolean visited = false;

        public ImageLabel(String string, ImageIcon imageIcon, String string2) {
            super(new MaxSizeImageIcon(imageIcon.getImage()));
            this.url = string;
            if (null != string2) {
                this.setToolTipText("<html>" + string2);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                this.visited = true;
                Utils.showURL(this.url);
                this.mouseEntered(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Color color = Utils.getColor(this.visited ? "VisitedLinkColor" : "MouseOverLinkColor");
            this.setBorder(BorderFactory.createLineBorder(color, 1));
            StatusDisplayer.getDefault().setStatusText(this.url);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            StatusDisplayer.getDefault().setStatusText("");
        }

        public JToolTip createToolTip() {
            JToolTip jToolTip = super.createToolTip();
            JLabel jLabel = new JLabel(this.getToolTipText());
            Dimension dimension = jLabel.getPreferredSize();
            FontMetrics fontMetrics = jToolTip.getFontMetrics(jToolTip.getFont());
            int n = dimension.width / 500;
            if (dimension.width % 500 > 0) {
                ++n;
            }
            dimension.height = Math.min(n * fontMetrics.getHeight() + 10, 300);
            dimension.width = 500;
            jToolTip.setPreferredSize(dimension);
            return jToolTip;
        }
    }

    class DemoRSSFeed
    extends RSSFeed {
        public DemoRSSFeed(String string) {
            super(string, false);
        }

        protected Component createFeedItemComponent(RSSFeed.FeedItem feedItem) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            int n = 0;
            if (feedItem.isValid()) {
                WebLink webLink = new WebLink(feedItem.title, feedItem.link, false);
                webLink.getAccessibleContext().setAccessibleName(BundleSupport.getAccessibilityName("WebLink", feedItem.title));
                webLink.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("WebLink", feedItem.link));
                webLink.setFont(BUTTON_FONT);
                jPanel.add((Component)webLink, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 2, 10), 0, 0));
                if (feedItem.enclosureUrl != null) {
                    jPanel.add((Component)new ImageLabel(feedItem.link, this.getImage(feedItem.enclosureUrl), feedItem.description), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
                } else {
                    JLabel jLabel = new JLabel(BundleSupport.getLabel("NoScreenShot"));
                    jLabel.setHorizontalAlignment(0);
                    jLabel.setVerticalAlignment(0);
                    jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 10), 0, 0));
                }
            } else {
                jPanel.add((Component)new JLabel(BundleSupport.getLabel("ErrLoadingFeed")), new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
                JButton jButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)BundleSupport.getLabel("Reload"));
                jButton.setOpaque(false);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DemoRSSFeed.this.lastReload = 0L;
                        DemoRSSFeed.this.reload();
                    }
                });
                jPanel.add((Component)jButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 5), 0, 0));
            }
            return jPanel;
        }

        protected int getMaxItemCount() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImageIcon getImage(String string) {
            Closeable closeable;
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            ImageIcon imageIcon = null;
            if (this.isContentCached()) {
                closeable = null;
                try {
                    closeable = new ObjectInputStream(new FileInputStream(this.getCacheFilePath()));
                    imageIcon = (ImageIcon)((ObjectInputStream)closeable).readObject();
                    Logger.getLogger(DemoPanel.class.getName()).log(Level.FINE, "Demo image loaded from: " + this.getCacheFilePath());
                }
                catch (Exception exception) {
                    imageIcon = null;
                }
                finally {
                    if (null != closeable) {
                        try {
                            ((ObjectInputStream)closeable).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (null == imageIcon) {
                closeable = null;
                try {
                    URLConnection uRLConnection = uRL.openConnection();
                    boolean bl = uRLConnection.getDefaultUseCaches();
                    uRLConnection.setDefaultUseCaches(true);
                    imageIcon = new ImageIcon(uRL);
                    uRLConnection.setDefaultUseCaches(bl);
                    closeable = new ObjectOutputStream(new FileOutputStream(this.getCacheFilePath()));
                    ((ObjectOutputStream)closeable).writeObject(imageIcon);
                }
                catch (Exception exception) {
                    Logger.getLogger(DemoPanel.class.getName()).log(Level.FINE, "Error while caching Welcome Page demo image", exception);
                    imageIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/broken_image.png"));
                }
                finally {
                    if (null != closeable) {
                        try {
                            ((ObjectOutputStream)closeable).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return imageIcon;
        }

        private File getCacheFilePath() throws IOException {
            File file = Utils.getCacheStore();
            file = new File(file, "demoimage");
            file.getParentFile().mkdirs();
            file.createNewFile();
            return file;
        }
    }
}

