/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.util.Utilities;

abstract class AbstractTab
extends JPanel
implements Scrollable,
Constants {
    private boolean initialized = false;
    private Image imgBottomStripWest;
    private Image imgBottomStripCenter;
    private Image imgBottomStripEast;
    private Image imgTopStripWest;
    private Image imgTopStripCenter;
    private Image imgMiddleStripEast;
    private Image imgMiddleStripCenter;

    public AbstractTab() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.imgBottomStripCenter = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_center.png");
        this.imgBottomStripWest = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_west.png");
        this.imgBottomStripEast = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_east.png");
        this.imgTopStripCenter = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_top_center.png");
        this.imgTopStripWest = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_top_west.png");
        this.imgMiddleStripCenter = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_middle_center.png");
        this.imgMiddleStripEast = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_middle_east.png");
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.buildContent();
            this.initialized = true;
        }
    }

    protected abstract void buildContent();

    protected abstract Point getTopStripOrigin();

    protected abstract Point getMiddleStripOrigin();

    protected abstract Point getBottomStripOrigin();

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (null != this.getParent() && this.getParent().getHeight() > 0 && this.getParent().getHeight() > dimension.height) {
            dimension.height = this.getParent().getHeight();
        }
        if (null != this.getParent() && this.getParent().getWidth() > 0) {
            if (dimension.width > this.getParent().getWidth()) {
                dimension.width = Math.max(this.getParent().getWidth(), 600 + (int)((double)(FONT_SIZE - 11) / 11.0 * 600.0));
                if (this.getParent().getParent() instanceof JScrollPane && ((JScrollPane)this.getParent().getParent()).getVerticalScrollBar().isVisible()) {
                    dimension.width -= ((JScrollPane)this.getParent().getParent()).getVerticalScrollBar().getWidth();
                }
            } else if (dimension.width < this.getParent().getWidth()) {
                dimension.width = this.getParent().getWidth();
            }
        }
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return Constants.FONT_SIZE;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 30 * Constants.FONT_SIZE;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        Point point = this.getTopStripOrigin();
        graphics.drawImage(this.imgTopStripWest, point.x, point.y, null);
        for (n = point.x + this.imgTopStripWest.getWidth(null); n < n2; ++n) {
            graphics.drawImage(this.imgTopStripCenter, n, point.y, null);
        }
        point = this.getMiddleStripOrigin();
        graphics.drawImage(this.imgMiddleStripEast, point.x - this.imgMiddleStripEast.getWidth(null), point.y, null);
        for (n = point.x - this.imgMiddleStripEast.getWidth(null); n >= 0; --n) {
            graphics.drawImage(this.imgMiddleStripCenter, n, point.y, null);
        }
        point = this.getBottomStripOrigin();
        n = this.imgBottomStripEast.getWidth(null);
        int n3 = this.imgBottomStripEast.getHeight(null);
        int n4 = this.imgBottomStripWest.getWidth(null);
        int n5 = this.imgBottomStripWest.getHeight(null);
        graphics.drawImage(this.imgBottomStripEast, n2 - n - 1, point.y - n3 - 1, null);
        int n6 = Math.max(100, n2 - n - n4 - 150);
        graphics.drawImage(this.imgBottomStripWest, n2 - n - 1 - n6 - n4, point.y - n5 - 1, null);
        for (int i = 0; i < n6; ++i) {
            graphics.drawImage(this.imgBottomStripCenter, n2 - n - n6 - 1 + i, point.y - n5 - 1, null);
        }
    }
}

