/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PickOrCreateFieldPanel
extends JPanel {
    private Object[] availableFields;
    private DefaultComboBoxModel mdlAvailableFields = new DefaultComboBoxModel();
    private FieldNameValidator nameValidator = null;
    private Border brdrBlack = BorderFactory.createLineBorder(Color.BLACK);
    private DialogDescriptor dlgDescriptor = null;
    private JButton btnFindType;
    private ButtonGroup buttonGroup1;
    private JLabel lblError;
    private JLabel lblErrorMsg;
    private JLabel lblName;
    private JLabel lblType;
    private JComboBox lstExistingFields;
    private JPanel pnlErrorMsg;
    private JRadioButton radioCreateNewField;
    private JRadioButton radioPickUpExistingField;
    private JTextField txtNewFieldName;
    private JTextField txtType;

    public PickOrCreateFieldPanel() {
        this.initComponents();
        this.radioPickUpExistingField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected();
                PickOrCreateFieldPanel.this.lstExistingFields.setEnabled(bl);
                PickOrCreateFieldPanel.this.txtNewFieldName.setEnabled(!PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected());
                PickOrCreateFieldPanel.this.txtType.setEnabled(!PickOrCreateFieldPanel.this.radioPickUpExistingField.isSelected());
            }
        });
        this.lstExistingFields.setModel(this.mdlAvailableFields);
        this.txtNewFieldName.setSelectionEnd(this.txtNewFieldName.getText().length() - 1);
        this.txtNewFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                NameStatus nameStatus = NameStatus.VALID;
                if (PickOrCreateFieldPanel.this.nameValidator != null) {
                    nameStatus = PickOrCreateFieldPanel.this.nameValidator.checkName(PickOrCreateFieldPanel.this.getNewIdName());
                }
                PickOrCreateFieldPanel.this.setFieldNameStatus(nameStatus);
            }
        });
        this.setNameValidator(new DefaultFieldNameValidator());
        this.setFieldNameStatus(NameStatus.VALID);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.radioPickUpExistingField = new JRadioButton();
        this.lstExistingFields = new JComboBox();
        this.radioCreateNewField = new JRadioButton();
        this.lblName = new JLabel();
        this.txtNewFieldName = new JTextField();
        this.lblType = new JLabel();
        this.txtType = new JTextField();
        this.btnFindType = new JButton();
        this.pnlErrorMsg = new JPanel();
        this.lblErrorMsg = new JLabel();
        this.lblError = new JLabel();
        this.buttonGroup1.add(this.radioPickUpExistingField);
        this.radioPickUpExistingField.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/jpa/verification/fixes/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.radioPickUpExistingField, (String)resourceBundle.getString("LBL_PickExistingField"));
        this.radioPickUpExistingField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioPickUpExistingField.setMargin(new Insets(0, 0, 0, 0));
        this.lstExistingFields.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroup1.add(this.radioCreateNewField);
        Mnemonics.setLocalizedText((AbstractButton)this.radioCreateNewField, (String)resourceBundle.getString("LBL_CreateNewField"));
        this.radioCreateNewField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.radioCreateNewField.setMargin(new Insets(0, 0, 0, 0));
        this.lblName.setLabelFor(this.txtNewFieldName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)resourceBundle.getString("LBL_FieldName"));
        this.txtNewFieldName.setText(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.txtNewFieldName.text"));
        this.txtNewFieldName.setEnabled(false);
        this.lblType.setLabelFor(this.txtType);
        Mnemonics.setLocalizedText((JLabel)this.lblType, (String)resourceBundle.getString("LBL_FieldType"));
        this.lblType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.lblType.AccessibleContext.accessibleName"));
        this.txtType.setText(NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"PickOrCreateFieldPanel.txtType.text"));
        this.txtType.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.btnFindType, (String)resourceBundle.getString("LBL_FindType"));
        this.btnFindType.setEnabled(false);
        this.btnFindType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickOrCreateFieldPanel.this.btnFindTypeActionPerformed(actionEvent);
            }
        });
        this.pnlErrorMsg.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlErrorMsg.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblErrorMsg, (String)resourceBundle.getString("MSG_IllegalJavaID"));
        this.lblError.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.lblError, (String)resourceBundle.getString("LBL_Error"));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlErrorMsg);
        this.pnlErrorMsg.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblError).addPreferredGap(0).add((Component)this.lblErrorMsg, -1, 342, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblError).add((Component)this.lblErrorMsg)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.radioPickUpExistingField).addPreferredGap(0).add((Component)this.lstExistingFields, 0, 285, Short.MAX_VALUE)).add((Component)this.radioCreateNewField).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.pnlErrorMsg, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.lblName).add((Component)this.lblType)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.txtType, -1, 274, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnFindType)).add((Component)this.txtNewFieldName, -1, 367, Short.MAX_VALUE)))))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.radioPickUpExistingField).add((Component)this.lstExistingFields, -2, -1, -2)).addPreferredGap(0).add((Component)this.radioCreateNewField).add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtNewFieldName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblType).add((Component)this.btnFindType).add((Component)this.txtType, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlErrorMsg, -2, -1, -2).addContainerGap()));
    }

    private void btnFindTypeActionPerformed(ActionEvent actionEvent) {
    }

    public void setAvailableFields(Object[] objectArray) {
        this.availableFields = objectArray;
        this.mdlAvailableFields.removeAllElements();
        if (objectArray == null || objectArray.length == 0) {
            this.setChoosingExistingFieldEnabled(false);
        } else {
            this.setChoosingExistingFieldEnabled(true);
            for (int i = 0; i < objectArray.length; ++i) {
                this.mdlAvailableFields.addElement(objectArray[i]);
            }
        }
    }

    public void setChoosingExistingFieldEnabled(boolean bl) {
        if (!bl) {
            this.radioCreateNewField.setSelected(true);
        }
        this.radioPickUpExistingField.setEnabled(bl);
    }

    public boolean wasCreateNewFieldSelected() {
        return this.radioCreateNewField.isSelected();
    }

    public String getNewIdName() {
        return this.txtNewFieldName.getText();
    }

    public Object getSelectedField() {
        return this.lstExistingFields.getSelectedItem();
    }

    public String getSelectedIdType() {
        return this.txtType.getText();
    }

    public void setType(String string) {
        this.txtType.setText(string);
    }

    public void setNameValidator(FieldNameValidator fieldNameValidator) {
        this.nameValidator = fieldNameValidator;
    }

    public void setExistingFieldNames(Set<String> set) {
        this.nameValidator.setExistingFieldNames(set);
    }

    public void setSelelectableType(boolean bl) {
        this.txtType.setVisible(bl);
        this.btnFindType.setVisible(bl);
        this.lblType.setVisible(bl);
    }

    void setDefaultFieldName(String string) {
        this.txtNewFieldName.setText(string);
    }

    private void setErrorPanelVisible(boolean bl) {
        this.lblErrorMsg.setVisible(bl);
        this.lblError.setVisible(bl);
        this.pnlErrorMsg.setBorder(bl ? this.brdrBlack : null);
    }

    public void setFieldNameStatus(NameStatus nameStatus) {
        boolean bl = nameStatus == NameStatus.VALID;
        this.setErrorPanelVisible(!bl);
        if (this.dlgDescriptor != null) {
            this.dlgDescriptor.setValid(bl);
        }
        String string = null;
        String string2 = this.txtNewFieldName.getText();
        switch (nameStatus) {
            case ILLEGAL_JAVA_ID: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalJavaID", (Object)string2);
                break;
            }
            case ILLEGAL_SQL_KEYWORD: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalSQLKeyWord", (Object)string2);
                break;
            }
            case DUPLICATE: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_DuplicateVariableName", (Object)string2);
            }
        }
        this.lblErrorMsg.setText(string);
    }

    public void setDlgDescriptor(DialogDescriptor dialogDescriptor) {
        this.dlgDescriptor = dialogDescriptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultFieldNameValidator
    implements FieldNameValidator {
        private Set<String> existingFieldNames;

        @Override
        public void setExistingFieldNames(Set<String> set) {
            this.existingFieldNames = set;
        }

        @Override
        public NameStatus checkName(String string) {
            if (!Utilities.isJavaIdentifier((String)string)) {
                return NameStatus.ILLEGAL_JAVA_ID;
            }
            if (JavaPersistenceQLKeywords.isKeyword((String)string)) {
                return NameStatus.ILLEGAL_SQL_KEYWORD;
            }
            if (this.existingFieldNames != null && this.existingFieldNames.contains(string)) {
                return NameStatus.DUPLICATE;
            }
            return NameStatus.VALID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FieldNameValidator {
        public NameStatus checkName(String var1);

        public void setExistingFieldNames(Set<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameStatus {
        VALID,
        ILLEGAL_JAVA_ID,
        ILLEGAL_SQL_KEYWORD,
        DUPLICATE;

    }
}

