/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.jpa.verification.fixes.PickOrCreateFieldPanel;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateRelationshipPanel
extends JPanel {
    private Collection<String> availableFields;
    private DefaultComboBoxModel mdlAvailableFields = new DefaultComboBoxModel();
    private FieldNameValidator nameValidator = null;
    private Border brdrBlack = BorderFactory.createLineBorder(Color.BLACK);
    private DialogDescriptor dlgDescriptor = null;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JLabel jLabel1;
    private JLabel lblError;
    private JLabel lblErrorMsg;
    private JLabel lblName;
    private JComboBox lstExistingFields;
    private JPanel pnlErrorMsg;
    private JRadioButton radioCreateNewField;
    private JRadioButton radioInversedSide;
    private JRadioButton radioOwningSide;
    private JRadioButton radioPickUpExistingField;
    private JTextField txtNewFieldName;

    public CreateRelationshipPanel() {
        this.initComponents();
        this.radioPickUpExistingField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = CreateRelationshipPanel.this.radioPickUpExistingField.isSelected();
                CreateRelationshipPanel.this.lstExistingFields.setEnabled(bl);
                CreateRelationshipPanel.this.txtNewFieldName.setEnabled(!CreateRelationshipPanel.this.radioPickUpExistingField.isSelected());
            }
        });
        this.lstExistingFields.setModel(this.mdlAvailableFields);
        this.txtNewFieldName.setSelectionEnd(this.txtNewFieldName.getText().length() - 1);
        this.txtNewFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                NameStatus nameStatus = NameStatus.VALID;
                if (CreateRelationshipPanel.this.nameValidator != null) {
                    nameStatus = CreateRelationshipPanel.this.nameValidator.checkName(CreateRelationshipPanel.this.getNewIdName());
                }
                CreateRelationshipPanel.this.setFieldNameStatus(nameStatus);
            }
        });
        this.setNameValidator(new DefaultFieldNameValidator());
        this.setFieldNameStatus(NameStatus.VALID);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.radioPickUpExistingField = new JRadioButton();
        this.lstExistingFields = new JComboBox();
        this.radioCreateNewField = new JRadioButton();
        this.lblName = new JLabel();
        this.txtNewFieldName = new JTextField();
        this.pnlErrorMsg = new JPanel();
        this.lblErrorMsg = new JLabel();
        this.lblError = new JLabel();
        this.jLabel1 = new JLabel();
        this.radioOwningSide = new JRadioButton();
        this.radioInversedSide = new JRadioButton();
        this.buttonGroup1.add(this.radioPickUpExistingField);
        this.radioPickUpExistingField.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/jpa/verification/fixes/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.radioPickUpExistingField, (String)resourceBundle.getString("LBL_PickExistingField"));
        this.radioPickUpExistingField.setMargin(new Insets(0, 0, 0, 0));
        this.lstExistingFields.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroup1.add(this.radioCreateNewField);
        Mnemonics.setLocalizedText((AbstractButton)this.radioCreateNewField, (String)resourceBundle.getString("LBL_CreateNewField"));
        this.radioCreateNewField.setMargin(new Insets(0, 0, 0, 0));
        this.lblName.setLabelFor(this.txtNewFieldName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)resourceBundle.getString("LBL_FieldName"));
        this.txtNewFieldName.setText(NbBundle.getMessage(CreateRelationshipPanel.class, (String)"PickOrCreateFieldPanel.txtNewFieldName.text"));
        this.txtNewFieldName.setEnabled(false);
        this.pnlErrorMsg.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pnlErrorMsg.setFocusable(false);
        Mnemonics.setLocalizedText((JLabel)this.lblErrorMsg, (String)resourceBundle.getString("MSG_IllegalJavaID"));
        this.lblError.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.lblError, (String)resourceBundle.getString("LBL_Error"));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlErrorMsg);
        this.pnlErrorMsg.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblError).addPreferredGap(0).add((Component)this.lblErrorMsg, -1, 396, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblError).add((Component)this.lblErrorMsg)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CreateRelationshipPanel.class, (String)"CreateRelationshipPanel.jLabel1.text"));
        this.buttonGroup2.add(this.radioOwningSide);
        this.radioOwningSide.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioOwningSide, (String)NbBundle.getMessage(CreateRelationshipPanel.class, (String)"CreateRelationshipPanel.radioOwningSide.text"));
        this.radioOwningSide.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup2.add(this.radioInversedSide);
        Mnemonics.setLocalizedText((AbstractButton)this.radioInversedSide, (String)NbBundle.getMessage(CreateRelationshipPanel.class, (String)"CreateRelationshipPanel.radioInversedSide.text"));
        this.radioInversedSide.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.radioPickUpExistingField).addPreferredGap(0).add((Component)this.lstExistingFields, 0, 398, Short.MAX_VALUE)).add((Component)this.radioCreateNewField).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((Component)this.lblName).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.pnlErrorMsg, -1, -1, Short.MAX_VALUE).add((Component)this.txtNewFieldName, -1, 471, Short.MAX_VALUE))).add((Component)this.radioOwningSide).add((Component)this.radioInversedSide).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.radioPickUpExistingField).add((Component)this.lstExistingFields, -2, -1, -2)).addPreferredGap(0).add((Component)this.radioCreateNewField).add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtNewFieldName, -2, -1, -2)).addPreferredGap(0).add((Component)this.pnlErrorMsg, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.radioOwningSide).addPreferredGap(0, 10, Short.MAX_VALUE).add((Component)this.radioInversedSide).add(8, 8, 8)));
    }

    public void setAvailableFields(Collection<String> collection) {
        this.availableFields = collection;
        this.mdlAvailableFields.removeAllElements();
        if (collection.size() == 0) {
            this.setChoosingExistingFieldEnabled(false);
        } else {
            this.setChoosingExistingFieldEnabled(true);
            for (String string : collection) {
                this.mdlAvailableFields.addElement(string);
            }
        }
    }

    public void setChoosingExistingFieldEnabled(boolean bl) {
        if (!bl) {
            this.radioCreateNewField.setSelected(true);
        }
        this.radioPickUpExistingField.setEnabled(bl);
    }

    public boolean wasCreateNewFieldSelected() {
        return this.radioCreateNewField.isSelected();
    }

    public String getNewIdName() {
        return this.txtNewFieldName.getText();
    }

    public Object getSelectedField() {
        return this.lstExistingFields.getSelectedItem();
    }

    public void setNameValidator(FieldNameValidator fieldNameValidator) {
        this.nameValidator = fieldNameValidator;
    }

    public void setExistingFieldNames(Collection<String> collection) {
        this.nameValidator.setExistingFieldNames(collection);
    }

    void setDefaultFieldName(String string) {
        this.txtNewFieldName.setText(string);
    }

    private void setErrorPanelVisible(boolean bl) {
        this.lblErrorMsg.setVisible(bl);
        this.lblError.setVisible(bl);
        this.pnlErrorMsg.setBorder(bl ? this.brdrBlack : null);
    }

    public void setFieldNameStatus(NameStatus nameStatus) {
        String string;
        boolean bl = nameStatus == NameStatus.VALID;
        this.setErrorPanelVisible(!bl);
        if (this.dlgDescriptor != null) {
            this.dlgDescriptor.setValid(bl);
        }
        String string2 = this.txtNewFieldName.getText();
        switch (nameStatus) {
            case ILLEGAL_JAVA_ID: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalJavaID", (Object)string2);
                break;
            }
            case ILLEGAL_SQL_KEYWORD: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_IllegalSQLKeyWord", (Object)string2);
                break;
            }
            case DUPLICATE: {
                string = NbBundle.getMessage(PickOrCreateFieldPanel.class, (String)"MSG_DuplicateVariableName", (Object)string2);
                break;
            }
            default: {
                string = null;
            }
        }
        this.lblErrorMsg.setText(string);
    }

    public void setEntityClassNames(String string, String string2) {
        this.radioOwningSide.setText(NbBundle.getMessage(CreateRelationshipPanel.class, (String)"CreateRelationshipPanel.radioOwningSide.text", (Object)string));
        this.radioInversedSide.setText(NbBundle.getMessage(CreateRelationshipPanel.class, (String)"CreateRelationshipPanel.radioInversedSide.text", (Object)string2));
    }

    public void setAvailableSelection(AvailableSelection availableSelection) {
        switch (availableSelection) {
            case INVERSE_ONLY: {
                this.radioInversedSide.setSelected(true);
                this.radioOwningSide.setEnabled(false);
                break;
            }
            case OWNING_ONLY: {
                this.radioInversedSide.setEnabled(false);
            }
        }
    }

    public boolean owningSide() {
        return this.radioOwningSide.isSelected();
    }

    public void setDlgDescriptor(DialogDescriptor dialogDescriptor) {
        this.dlgDescriptor = dialogDescriptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultFieldNameValidator
    implements FieldNameValidator {
        private Collection<String> existingFieldNames;

        @Override
        public void setExistingFieldNames(Collection<String> collection) {
            this.existingFieldNames = collection;
        }

        @Override
        public NameStatus checkName(String string) {
            if (!Utilities.isJavaIdentifier((String)string)) {
                return NameStatus.ILLEGAL_JAVA_ID;
            }
            if (JavaPersistenceQLKeywords.isKeyword((String)string)) {
                return NameStatus.ILLEGAL_SQL_KEYWORD;
            }
            if (this.existingFieldNames != null && this.existingFieldNames.contains(string)) {
                return NameStatus.DUPLICATE;
            }
            return NameStatus.VALID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FieldNameValidator {
        public NameStatus checkName(String var1);

        public void setExistingFieldNames(Collection<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AvailableSelection {
        INVERSE_ONLY,
        OWNING_ONLY,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameStatus {
        VALID,
        ILLEGAL_JAVA_ID,
        ILLEGAL_SQL_KEYWORD,
        DUPLICATE;

    }
}

