/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAVerificationTaskProvider
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public JPAVerificationTaskProvider() {
        super(NbBundle.getMessage(JPAVerificationTaskProvider.class, (String)"LBL_TaskList_DisplayName"), NbBundle.getMessage(JPAVerificationTaskProvider.class, (String)"LBL_TaskList_Desc"), null);
    }

    public List<? extends org.netbeans.spi.tasklist.Task> scan(FileObject fileObject) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        JPAProblemFinder.ProblemFinderCompControl problemFinderCompControl = new JPAProblemFinder.ProblemFinderCompControl(fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)problemFinderCompControl, true);
            }
            catch (IOException iOException) {
                JPAProblemFinder.LOG.log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        ArrayList<org.netbeans.spi.tasklist.Task> arrayList = new ArrayList<org.netbeans.spi.tasklist.Task>();
        for (ErrorDescription errorDescription : problemFinderCompControl.getProblemsFound()) {
            try {
                org.netbeans.spi.tasklist.Task task = org.netbeans.spi.tasklist.Task.create((FileObject)fileObject, (String)JPAVerificationTaskProvider.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)errorDescription.getRange().getBegin().getLine());
                arrayList.add(task);
            }
            catch (IOException iOException) {
                JPAProblemFinder.LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        return arrayList;
    }

    public void attach(FileTaskScanner.Callback callback) {
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }
}

