/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.jdkselection;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkConfiguration {
    private static final String NS_GENERAL = "http://www.netbeans.org/ns/project/1";
    private static final String NBJDK_PROPERTIES = "nbproject/nbjdk.properties";
    private static final String NBJDK_ACTIVE = "nbjdk.active";
    public static final String NBJDK_XML = "nbproject/nbjdk.xml";
    public static final String JDK_XML = "nbproject/jdk.xml";
    private static final String PLATFORM_ID_DEFAULT = "default_platform";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;

    public JdkConfiguration(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
    }

    private void initialize() throws IOException {
        this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                JdkConfiguration.this.createJdkXml();
                if (JdkConfiguration.this.project.getProjectDirectory().getFileObject(JdkConfiguration.NBJDK_XML) != null) {
                    return;
                }
                Element element = Util.getPrimaryConfigurationData((AntProjectHelper)JdkConfiguration.this.helper);
                Document document = JdkConfiguration.this.createNbjdkXmlSkeleton();
                JdkConfiguration.this.rebindAllActions(element, document);
                JdkConfiguration.this.writeXML(document, JdkConfiguration.NBJDK_XML);
                Util.putPrimaryConfigurationData((AntProjectHelper)JdkConfiguration.this.helper, (Element)element);
                ProjectManager.getDefault().saveProject(JdkConfiguration.this.project);
            }
        });
    }

    private void createJdkXml() throws IOException {
        ProjectManager.getDefault().saveProject(this.project);
        new GeneratedFilesHelper(this.helper).refreshBuildScript(JDK_XML, JdkConfiguration.class.getResource("jdk.xsl"), true);
    }

    public static void insertJdkXmlImport(Document document) {
        NodeList nodeList = document.getElementsByTagName("import");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("file").equals("jdk.xml")) continue;
            return;
        }
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("property");
        element2.setAttribute("file", NBJDK_PROPERTIES);
        element.appendChild(element2);
        element2 = document.createElement("property");
        element2.setAttribute("name", "user.properties.file");
        element2.setAttribute("location", "${netbeans.user}/build.properties");
        element.appendChild(element2);
        element2 = document.createElement("property");
        element2.setAttribute("file", "${user.properties.file}");
        element.appendChild(element2);
        Element element3 = document.createElement("import");
        element3.setAttribute("file", "jdk.xml");
        element.appendChild(element3);
    }

    private Document createNbjdkXmlSkeleton() {
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        element.setAttribute("name", ProjectUtils.getInformation((Project)this.project).getName());
        element.setAttribute("basedir", "..");
        JdkConfiguration.insertJdkXmlImport(document);
        return document;
    }

    private void rebindAllActions(Element element, Document document) {
        Element element2;
        Object object;
        Element element3 = document.getDocumentElement();
        HashSet<String> hashSet = new HashSet<String>();
        Element element4 = Util.findElement((Element)element, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element4 != null) {
            object = Util.findSubElements((Element)element4).iterator();
            while (object.hasNext()) {
                element2 = (Element)object.next();
                this.rebindAction(element2, element3, hashSet);
            }
        }
        if ((object = Util.findElement((Element)element, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null && (element2 = Util.findElement((Element)object, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
            for (Element element5 : Util.findSubElements((Element)element2)) {
                if (!element5.getLocalName().equals("action")) continue;
                this.rebindAction(element5, element3, hashSet);
            }
        }
    }

    private void rebindAction(Element element, Element element2, Set<String> set) {
        String string;
        Element element3 = Util.findElement((Element)element, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (element3 != null) {
            string = Util.findText((Element)element3);
            element.removeChild(element3);
        } else {
            string = "build.xml";
        }
        element3 = element.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
        element3.appendChild(element.getOwnerDocument().createTextNode(NBJDK_XML));
        element.insertBefore(element3, element.getFirstChild());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : Util.findSubElements((Element)element)) {
            if (!object.getLocalName().equals("target")) continue;
            arrayList.add(Util.findText((Element)object));
        }
        if (arrayList.isEmpty()) {
            arrayList.add(null);
        }
        String string2 = this.evaluator.evaluate(string);
        for (String string3 : arrayList) {
            if (!set.add(string3)) continue;
            JdkConfiguration.createOverride(element2, string3, string2);
        }
    }

    private static void createOverride(Element element, String string, String string2) {
        Element element2 = element.getOwnerDocument().createElement("target");
        if (string != null) {
            element2.setAttribute("name", string);
        }
        String string3 = string != null && string.indexOf("debug") != -1 ? "-jdk-init,-jdk-presetdef-nbjpdastart" : "-jdk-init";
        element2.setAttribute("depends", string3);
        Element element3 = element.getOwnerDocument().createElement("ant");
        if (string != null) {
            element3.setAttribute("target", string);
        }
        if (!string2.equals("build.xml")) {
            element3.setAttribute("antfile", string2);
        }
        element3.setAttribute("inheritall", "false");
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML(Document document, String string) throws IOException {
        FileObject fileObject = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)string);
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public JavaPlatform getSelectedPlatform() {
        EditableProperties editableProperties = this.helper.getProperties(NBJDK_PROPERTIES);
        String string = editableProperties.getProperty(NBJDK_ACTIVE);
        if (string != null) {
            for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                if (!string.equals(JdkConfiguration.getPlatformID(javaPlatform))) continue;
                return javaPlatform;
            }
        }
        return null;
    }

    public void setSelectedPlatform(JavaPlatform javaPlatform) throws IOException {
        assert (javaPlatform != null);
        this.initialize();
        EditableProperties editableProperties = this.helper.getProperties(NBJDK_PROPERTIES);
        editableProperties.setProperty(NBJDK_ACTIVE, JdkConfiguration.getPlatformID(javaPlatform));
        this.helper.putProperties(NBJDK_PROPERTIES, editableProperties);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private static String getPlatformID(JavaPlatform javaPlatform) {
        String string = (String)javaPlatform.getProperties().get("platform.ant.name");
        if (string != null) {
            return string;
        }
        return PLATFORM_ID_DEFAULT;
    }
}

