/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Element;

final class SourceLevelQueryImpl
implements SourceLevelQueryImplementation,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map<FileObject, String> sourceLevels = new WeakHashMap<FileObject, String>();

    public SourceLevelQueryImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, AuxiliaryConfiguration auxiliaryConfiguration) {
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.aux = auxiliaryConfiguration;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    public String getSourceLevel(final FileObject fileObject) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                return SourceLevelQueryImpl.this.getSourceLevelImpl(fileObject);
            }
        });
    }

    private synchronized String getSourceLevelImpl(FileObject fileObject) {
        for (Map.Entry<FileObject, String> entry : this.sourceLevels.entrySet()) {
            Object object = entry.getKey();
            if (object != fileObject && !FileUtil.isParentOf((FileObject)object, (FileObject)fileObject)) continue;
            return entry.getValue();
        }
        Element element = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (element == null) {
            return null;
        }
        for (Object object : Util.findSubElements((Element)element)) {
            assert (object.getLocalName().equals("compilation-unit")) : object;
            List<FileObject> list = Classpaths.findPackageRoots(this.helper, this.evaluator, (Element)object);
            for (FileObject fileObject2 : list) {
                if (fileObject2 != fileObject && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) continue;
                String string = this.getLevel((Element)object);
                for (FileObject fileObject3 : list) {
                    this.sourceLevels.put(fileObject3, string);
                }
                return string;
            }
        }
        return null;
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        SourceLevelQueryImpl sourceLevelQueryImpl = this;
        synchronized (sourceLevelQueryImpl) {
            this.sourceLevels.clear();
        }
    }

    private String getLevel(Element element) {
        Element element2 = Util.findElement((Element)element, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/2");
        if (element2 != null) {
            return Util.findText((Element)element2);
        }
        return null;
    }
}

