/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.ruby.hints.infrastructure.RulesManager;
import org.netbeans.modules.ruby.hints.options.HintsPanelLogic;
import org.netbeans.modules.ruby.hints.options.HintsSettings;
import org.netbeans.modules.ruby.hints.spi.UserConfigurableRule;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class HintsPanel
extends JPanel
implements TreeCellRenderer {
    private DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private JCheckBox renderer = new JCheckBox();
    private HintsPanelLogic logic;
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JTree errorTree;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JCheckBox toProblemCheckBox;
    private JPanel treePanel;

    HintsPanel() {
        this.initComponents();
        this.descriptionTextArea.setContentType("text/html");
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.errorTree.setCellRenderer(this);
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsError"));
        defaultComboBoxModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsWarning"));
        defaultComboBoxModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_WarningOnCurrentLine"));
        this.severityComboBox.setModel(defaultComboBoxModel);
        this.toProblemCheckBox.setVisible(false);
        this.update();
        this.errorTree.setModel(RulesManager.getInstance().getHintsTreeModel());
        for (int i = this.errorTree.getRowCount(); i >= 0; --i) {
            this.errorTree.expandRow(i);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new JTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.toProblemCheckBox = new JCheckBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(320);
        this.jSplitPane1.setOpaque(false);
        this.treePanel.setOpaque(false);
        this.treePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.errorTree);
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.optionsPanel.add((Component)this.severityLabel, gridBagConstraints);
        this.severityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.optionsPanel.add((Component)this.severityComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.toProblemCheckBox, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_InTasklist_CheckBox"));
        this.toProblemCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.toProblemCheckBox, gridBagConstraints);
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.optionsPanel.add((Component)this.customizerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.detailsPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setLayout(new GridBagLayout());
        this.descriptionTextArea.setEditable(false);
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.descriptionPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.descriptionPanel.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.detailsPanel.add((Component)this.descriptionPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    synchronized void update() {
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.severityComboBox, this.toProblemCheckBox, this.customizerPanel, this.descriptionTextArea);
    }

    void cancel() {
        if (this.logic != null) {
            this.logic.disconnect();
            this.logic = null;
        }
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    void applyChanges() {
        if (this.logic != null) {
            this.logic.applyChanges();
            this.logic.disconnect();
            this.logic = null;
        }
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.renderer.setBackground(bl ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(bl ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 instanceof FileObject) {
            FileObject fileObject = (FileObject)object2;
            this.renderer.setText(this.getFileObjectLocalizedName(fileObject));
            this.renderer.setSelected(this.logic.isSelected((DefaultMutableTreeNode)object));
        } else if (object2 instanceof UserConfigurableRule) {
            UserConfigurableRule userConfigurableRule = (UserConfigurableRule)object2;
            this.renderer.setText(userConfigurableRule.getDisplayName());
            Preferences preferences = this.logic.getCurrentPrefernces(userConfigurableRule);
            this.renderer.setSelected(HintsSettings.isEnabled(userConfigurableRule, preferences));
        } else {
            this.renderer.setText(object.toString());
        }
        return this.renderer;
    }

    private String getFileObjectLocalizedName(FileObject fileObject) {
        Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
        if (object instanceof String) {
            String string = (String)object;
            try {
                ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
                String string2 = resourceBundle.getString(fileObject.getPath());
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fileObject.getPath();
    }
}

