/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jruby.ast.ClassNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.NbUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.hints.introduce.DuplicateDetector;
import org.netbeans.modules.ruby.hints.introduce.InputOutputVarFinder;
import org.netbeans.modules.ruby.hints.introduce.IntroduceFieldPanel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceHint;
import org.netbeans.modules.ruby.hints.introduce.IntroduceKind;
import org.netbeans.modules.ruby.hints.introduce.IntroduceMethodPanel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceVariablePanel;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntroduceFix
implements PreviewableFix {
    private static final boolean FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    private static final boolean COMMENT_NEW_ELEMENTS = !Boolean.getBoolean("ruby.create.nocomments");
    private final CompilationInfo info;
    private final OffsetRange lexRange;
    private final OffsetRange astRange;
    private final IntroduceKind kind;
    private final List<Node> nodes;
    private BaseDocument doc;
    private int commentOffset = -1;

    IntroduceFix(CompilationInfo compilationInfo, List<Node> list, OffsetRange offsetRange, OffsetRange offsetRange2, IntroduceKind introduceKind) {
        this.info = compilationInfo;
        this.nodes = list;
        this.lexRange = offsetRange;
        this.astRange = offsetRange2;
        this.kind = introduceKind;
    }

    public String getKeyExt() {
        switch (this.kind) {
            case CREATE_CONSTANT: {
                return "IntroduceConstant";
            }
            case CREATE_VARIABLE: {
                return "IntroduceVariable";
            }
            case CREATE_METHOD: {
                return "IntroduceMethod";
            }
            case CREATE_FIELD: {
                return "IntroduceField";
            }
        }
        throw new IllegalStateException(this.kind.toString());
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
    }

    @Override
    public void implement() throws Exception {
        String string;
        String string2;
        int n;
        JTextComponent jTextComponent;
        String string3 = IntroduceHint.testName;
        EditList editList = this.createEdits(string3);
        if (editList == null) {
            return;
        }
        Position position = null;
        position = editList.apply(this.commentOffset);
        if (position != null && (jTextComponent = NbUtilities.getPaneFor((FileObject)this.info.getFileObject())) != null && (n = position.getOffset()) + (string2 = this.getCommentText()).length() <= this.doc.getLength() && string2.equals(string = this.doc.getText(n, string2.length()))) {
            jTextComponent.select(n, n + string2.length());
        }
    }

    private String getCommentText() throws MissingResourceException {
        return NbBundle.getMessage(IntroduceHint.class, (String)"DefaultMethodComment");
    }

    @Override
    public EditList getEditList() {
        String string = "new_name";
        try {
            return this.createEdits(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private EditList createEdits(String string) throws Exception {
        try {
            this.doc = (BaseDocument)this.info.getDocument();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
        String string2 = AstUtilities.guessName((CompilationInfo)this.info, (OffsetRange)this.lexRange, (OffsetRange)this.astRange);
        RubyIndex rubyIndex = RubyIndex.get((Index)this.info.getIndex("text/x-ruby"));
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        List<Object> list = null;
        if (string == null) {
            switch (this.kind) {
                case CREATE_CONSTANT: 
                case CREATE_VARIABLE: {
                    Object object;
                    Node node = this.nodes.get(0);
                    Node node2 = this.nodes.get(this.nodes.size() - 1);
                    Node node3 = AstUtilities.getRoot((CompilationInfo)this.info);
                    int n = 1;
                    if (this.kind == IntroduceKind.CREATE_CONSTANT) {
                        object = AstUtilities.findClass((AstPath)astPath);
                        if (object != null) {
                            node3 = object;
                        }
                        n = (list = DuplicateDetector.findDuplicates(this.info, this.doc, node3, this.nodes, node, node2)) == null ? 1 : list.size();
                    }
                    object = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    Set set = this.kind == IntroduceKind.CREATE_CONSTANT ? AstUtilities.getUsedConstants((RubyIndex)rubyIndex, (AstPath)astPath) : AstUtilities.getUsedLocalNames((AstPath)astPath, (Node)astPath.leaf());
                    IntroduceVariablePanel introduceVariablePanel = new IntroduceVariablePanel(n, string2, this.kind == IntroduceKind.CREATE_CONSTANT, (JButton)object, set);
                    String string3 = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceVariablePanel, string3, true, new Object[]{object, jButton}, object, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != object) {
                        return null;
                    }
                    string = introduceVariablePanel.getVariableName();
                    if (introduceVariablePanel.isReplaceAll()) break;
                    list = Collections.emptyList();
                    break;
                }
                case CREATE_FIELD: {
                    int n = 1;
                    JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton jButton2 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    int[] nArray = new int[1];
                    Set set = AstUtilities.getUsedFields((RubyIndex)rubyIndex, (AstPath)astPath);
                    IntroduceFieldPanel introduceFieldPanel = new IntroduceFieldPanel(string2, nArray, n, jButton, set);
                    String string4 = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceFieldPanel, string4, true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                        return null;
                    }
                    string = introduceFieldPanel.getFieldName();
                    if (introduceFieldPanel.isReplaceAll()) break;
                    list = Collections.emptyList();
                    break;
                }
                case CREATE_METHOD: {
                    JButton jButton = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
                    JButton jButton3 = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
                    Set set = AstUtilities.getUsedMethods((RubyIndex)rubyIndex, (AstPath)astPath);
                    IntroduceMethodPanel introduceMethodPanel = new IntroduceMethodPanel("", set);
                    introduceMethodPanel.setOkButton(jButton);
                    String string5 = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)introduceMethodPanel, string5, true, new Object[]{jButton, jButton3}, (Object)jButton, 0, null, null);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) != jButton) {
                        return null;
                    }
                    string = introduceMethodPanel.getMethodName();
                    break;
                }
            }
        }
        if (this.kind == IntroduceKind.CREATE_FIELD) {
            string = "@" + string;
        } else if (this.kind == IntroduceKind.CREATE_CONSTANT) {
            string = string.toUpperCase();
        }
        if (this.kind == IntroduceKind.CREATE_CONSTANT || this.kind == IntroduceKind.CREATE_VARIABLE || this.kind == IntroduceKind.CREATE_FIELD) {
            return this.introduceExp(string, list);
        }
        assert (this.kind == IntroduceKind.CREATE_METHOD);
        return this.extractMethod(string);
    }

    private EditList introduceExp(String string, List<OffsetRange> list) throws BadLocationException {
        int n;
        boolean bl;
        boolean bl2 = bl = this.kind == IntroduceKind.CREATE_CONSTANT;
        if (bl) {
            n = this.findClassBegin();
            if (n == -1) {
                n = this.findMethodBegin();
            }
            n = n == -1 ? this.findStatementBegin() : Utilities.getRowStart((BaseDocument)this.doc, (int)n);
        } else {
            n = this.findStatementBegin();
        }
        int n2 = this.lexRange.getStart();
        int n3 = this.lexRange.getEnd();
        assert (n <= n2);
        StringBuilder stringBuilder = new StringBuilder();
        if (bl && COMMENT_NEW_ELEMENTS) {
            stringBuilder.append("# ");
        }
        int n4 = stringBuilder.length();
        if (bl && COMMENT_NEW_ELEMENTS) {
            stringBuilder.append(this.getCommentText());
            stringBuilder.append("\n");
        }
        stringBuilder.append(string);
        stringBuilder.append(" = ");
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        boolean bl3 = false;
        if (astPath.leafGrandParent() != null && astPath.leafGrandParent().nodeId == NodeType.HASHNODE) {
            bl3 = true;
        }
        if (bl3) {
            stringBuilder.append("{ ");
        }
        stringBuilder.append(this.doc.getText(n2, n3 - n2));
        if (bl3) {
            stringBuilder.append(" }");
        }
        stringBuilder.append("\n");
        if (bl) {
            stringBuilder.append("\n");
        }
        this.commentOffset = -1;
        if (bl && n > 0 && COMMENT_NEW_ELEMENTS) {
            this.commentOffset = n + n4;
        }
        EditList editList = new EditList(this.doc);
        editList.replace(n2, n3 - n2, string, true, 1);
        editList.replace(n, 0, stringBuilder.toString(), true, 2);
        if (list != null && list.size() > 1) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(n2);
            hashSet.add(n);
            for (OffsetRange offsetRange : list) {
                int n5 = offsetRange.getStart();
                if (hashSet.contains(n5)) continue;
                editList.replace(n5, offsetRange.getLength(), string, true, 0);
                hashSet.add(n5);
            }
        }
        return editList;
    }

    private EditList extractMethod(String string) throws BadLocationException {
        Node node = this.nodes.get(0);
        Node node2 = this.nodes.get(this.nodes.size() - 1);
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart() + this.astRange.getLength() / 2);
        List list = AstUtilities.getApplicableBlocks((AstPath)astPath, (boolean)true);
        InputOutputVarFinder inputOutputVarFinder = new InputOutputVarFinder(node, node2, list);
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker((ParseTreeVisitor)inputOutputVarFinder);
        Node node3 = AstUtilities.findLocalScope((Node)astPath.leaf(), (AstPath)astPath);
        parseTreeWalker.walk(node3);
        Set<String> set = inputOutputVarFinder.getInputVars();
        Set<String> set2 = inputOutputVarFinder.getOutputVars();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>(set2);
        Collections.sort(arrayList2);
        int n = this.findMethodEnd();
        StringBuilder stringBuilder = new StringBuilder();
        EditList editList = new EditList(this.doc);
        boolean bl = n < this.astRange.getStart();
        stringBuilder.append("\n");
        if (!bl) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("# ");
        int n2 = stringBuilder.length();
        stringBuilder.append(this.getCommentText());
        stringBuilder.append("\n");
        stringBuilder.append("def ");
        stringBuilder.append(string);
        if (arrayList.size() > 0) {
            if (FORCE_COMPLETION_SPACES) {
                this.appendCommaList(stringBuilder, arrayList, " ", "");
            } else {
                this.appendCommaList(stringBuilder, arrayList, "(", ")");
            }
        }
        stringBuilder.append('\n');
        int n3 = this.lexRange.getStart();
        int n4 = this.lexRange.getEnd();
        stringBuilder.append(this.doc.getText(n3, n4 - n3));
        stringBuilder.append('\n');
        if (arrayList2.size() > 0) {
            this.appendCommaList(stringBuilder, arrayList2, arrayList2.size() == 1 ? "" : "return ", "\n");
        }
        stringBuilder.append("end");
        if (bl) {
            stringBuilder.append("\n");
        }
        editList.replace(n, 0, stringBuilder.toString(), true, 0);
        this.commentOffset = n + n2;
        stringBuilder = new StringBuilder();
        if (arrayList2.size() > 0) {
            this.appendCommaList(stringBuilder, arrayList2, null, null);
            stringBuilder.append(" = ");
        }
        stringBuilder.append(string);
        if (arrayList.size() > 0) {
            if (FORCE_COMPLETION_SPACES) {
                this.appendCommaList(stringBuilder, arrayList, " ", "");
            } else {
                this.appendCommaList(stringBuilder, arrayList, "(", ")");
            }
        }
        editList.replace(n3, n4 - n3, stringBuilder.toString(), true, 0);
        return editList;
    }

    private void appendCommaList(StringBuilder stringBuilder, List<String> list, String string, String string2) {
        if (string != null) {
            stringBuilder.append(string);
        }
        boolean bl = true;
        for (String string3 : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string3);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
    }

    private int findClassBegin() throws BadLocationException {
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        ClassNode classNode = AstUtilities.findClass((AstPath)astPath);
        if (classNode != null) {
            int n = Utilities.getRowEnd((BaseDocument)this.doc, (int)classNode.getPosition().getStartOffset()) + 1;
            return Math.min(LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)n), this.doc.getLength());
        }
        return -1;
    }

    private int findStatementBegin() throws BadLocationException {
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        ListIterator listIterator = astPath.leafToRoot();
        Node node = null;
        boolean bl = false;
        block0: while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.nodeId == NodeType.NEWLINENODE) {
                if (node == null) break;
                bl = true;
                Node node3 = node2;
                Node node4 = node2;
                while (listIterator.hasNext()) {
                    node2 = (Node)listIterator.next();
                    if (node2.nodeId == NodeType.NEWLINENODE) {
                        int n = Math.min(LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)node4.getPosition().getStartOffset()), this.doc.getLength());
                        int n2 = Math.min(LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)node2.getPosition().getStartOffset()), this.doc.getLength());
                        if (node3 == null || n2 == -1 || n == -1 || Utilities.getRowStart((BaseDocument)this.doc, (int)n) != Utilities.getRowStart((BaseDocument)this.doc, (int)n2)) break block0;
                        node = node3;
                        break block0;
                    }
                    node3 = node2;
                }
                break;
            }
            node = node2;
        }
        if (bl) {
            return Math.min(LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)node.getPosition().getStartOffset()), this.doc.getLength());
        }
        return Utilities.getRowFirstNonWhite((BaseDocument)this.doc, (int)this.lexRange.getStart());
    }

    private int findMethodEnd() throws BadLocationException {
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        for (Node node : astPath) {
            if (node.nodeId == NodeType.DEFNNODE || node.nodeId == NodeType.DEFSNODE) {
                return Math.min(LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)node.getPosition().getEndOffset()), this.doc.getLength());
            }
            if (node.nodeId != NodeType.CLASSNODE && node.nodeId != NodeType.SCLASSNODE && node.nodeId != NodeType.MODULENODE) continue;
            int n = LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)node.getPosition().getStartOffset());
            return Utilities.getRowEnd((BaseDocument)this.doc, (int)n);
        }
        return this.doc.getLength();
    }

    private int findMethodBegin() throws BadLocationException {
        AstPath astPath = new AstPath(AstUtilities.getRoot((CompilationInfo)this.info), this.astRange.getStart());
        MethodDefNode methodDefNode = AstUtilities.findMethod((AstPath)astPath);
        if (methodDefNode != null) {
            OffsetRange offsetRange;
            int n = methodDefNode.getPosition().getStartOffset();
            int n2 = LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)n);
            if (n2 != -1 && (offsetRange = LexUtilities.findRDocRange((BaseDocument)this.doc, (int)n)) != OffsetRange.NONE) {
                return offsetRange.getStart();
            }
            return LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)n);
        }
        return -1;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public boolean canPreview() {
        return true;
    }
}

