/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.infrastructure;

import java.util.ArrayList;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.ruby.hints.infrastructure.RubyHintsProvider;
import org.netbeans.modules.ruby.hints.infrastructure.RulesManager;
import org.netbeans.modules.ruby.hints.options.HintsAdvancedOption;
import org.netbeans.modules.ruby.hints.options.HintsSettings;
import org.netbeans.modules.ruby.hints.spi.UserConfigurableRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DisableHintFix
implements EnhancedFix {
    private final UserConfigurableRule rule;
    private final CompilationInfo info;
    private final int caretPos;
    private final String sortText;

    public DisableHintFix(UserConfigurableRule userConfigurableRule, CompilationInfo compilationInfo, int n, String string) {
        this.rule = userConfigurableRule;
        this.info = compilationInfo;
        this.caretPos = n;
        this.sortText = string;
    }

    public String getText() {
        return NbBundle.getMessage(HintsAdvancedOption.class, (String)"DisableHint");
    }

    public ChangeInfo implement() throws Exception {
        HintsSettings.setEnabled(RulesManager.getInstance().getPreferences(this.rule, null), false);
        RubyHintsProvider rubyHintsProvider = new RubyHintsProvider();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (this.caretPos == -1) {
            rubyHintsProvider.computeHints(this.info, arrayList);
            HintsController.setErrors((FileObject)this.info.getFileObject(), (String)"org.netbeans.modules.gsfret.hints.infrastructure.HintsTask", arrayList);
        } else {
            rubyHintsProvider.computeSuggestions(this.info, arrayList, this.caretPos);
            HintsController.setErrors((FileObject)this.info.getFileObject(), (String)"org.netbeans.modules.gsfret.hints.infrastructure.SuggestionsTask", arrayList);
        }
        return null;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }
}

