/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.IfNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertIfToUnless
implements AstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        IfNode ifNode = (IfNode)node;
        Node node2 = ifNode.getCondition();
        if (node2 == null) {
            return;
        }
        if (ifNode.getElseBody() != null && ifNode.getElseBody().nodeId == NodeType.IFNODE) {
            return;
        }
        if (node2.nodeId == NodeType.NOTNODE || node2.nodeId == NodeType.NEWLINENODE && node2.childNodes().size() == 1 && ((Node)node2.childNodes().get((int)0)).nodeId == NodeType.NOTNODE) {
            try {
                TokenSequence tokenSequence;
                ConvertToUnlessFix convertToUnlessFix;
                BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
                int n = ConvertIfToUnless.findKeywordOffset(compilationInfo, ifNode);
                if (n == -1 || n > baseDocument.getLength() - 1) {
                    return;
                }
                OffsetRange offsetRange = AstUtilities.getRange((Node)node);
                if (RubyUtils.isRhtmlFile((FileObject)compilationInfo.getFileObject())) {
                    if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) == OffsetRange.NONE) {
                        return;
                    }
                    try {
                        baseDocument.readLock();
                        convertToUnlessFix = TokenHierarchy.get((Document)baseDocument);
                        tokenSequence = convertToUnlessFix.tokenSequence();
                        tokenSequence.move(offsetRange.getStart());
                        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                            return;
                        }
                        if (tokenSequence.offset() + tokenSequence.token().length() < offsetRange.getEnd()) {
                            return;
                        }
                    }
                    finally {
                        if (baseDocument != null) {
                            baseDocument.readUnlock();
                        }
                    }
                }
                if ((convertToUnlessFix = new ConvertToUnlessFix(compilationInfo, ifNode)).getEditList() == null) {
                    return;
                }
                tokenSequence = Collections.singletonList(convertToUnlessFix);
                String string = NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
                Description description = new Description(this, string, compilationInfo.getFileObject(), offsetRange, (List<Fix>)tokenSequence, 500);
                list.add(description);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    @Override
    public String getId() {
        return "ConvertIfToUnless";
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnless");
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    static int findKeywordOffset(CompilationInfo compilationInfo, IfNode ifNode) throws IOException, BadLocationException {
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        int n = ifNode.getPosition().getStartOffset();
        int n2 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)n);
        if (n2 == -1 || n2 > baseDocument.getLength()) {
            return -1;
        }
        String string = baseDocument.getText(n2, 2);
        if (string.equals("if")) {
            if (n2 > 3 && "elsif".equals(string = baseDocument.getText(n2 - 3, 5))) {
                return -1;
            }
            return n2;
        }
        if (string.equals("un")) {
            return n2;
        }
        int n3 = LexUtilities.getLexerOffset((CompilationInfo)compilationInfo, (int)AstUtilities.getRange((Node)ifNode.getCondition()).getStart());
        int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3);
        if (n4 != -1 && n4 < n3) {
            String string2 = baseDocument.getText(n4, n3 - n4).trim();
            if (string2.endsWith("elsif")) {
                return -1;
            }
            if (string2.endsWith("if")) {
                return n4 + string2.length() - 2;
            }
            if (string2.endsWith("unless")) {
                return n4 + string2.length() - 6;
            }
        }
        return -1;
    }

    private class ConvertToUnlessFix
    implements PreviewableFix {
        private CompilationInfo info;
        private IfNode ifNode;

        public ConvertToUnlessFix(CompilationInfo compilationInfo, IfNode ifNode) {
            this.info = compilationInfo;
            this.ifNode = ifNode;
        }

        public String getDescription() {
            String string;
            String string2;
            String string3 = "if";
            String string4 = "unless";
            if (this.ifNode.getThenBody() != null) {
                string2 = string3;
                string = string4;
            } else {
                string2 = string4;
                string = string3;
            }
            return NbBundle.getMessage(ConvertIfToUnless.class, (String)"ConvertIfToUnlessFix", (Object)string2, (Object)string);
        }

        public void implement() throws Exception {
            EditList editList = this.getEditList();
            if (editList != null) {
                editList.apply();
            }
        }

        public EditList getEditList() {
            try {
                int n;
                int n2;
                BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
                Node node = this.ifNode.getCondition();
                if (node.nodeId != NodeType.NOTNODE) {
                    Node node2;
                    assert (node.nodeId == NodeType.NEWLINENODE);
                    Node node3 = node2 = node.childNodes().size() == 1 ? (Node)node.childNodes().get(0) : null;
                    if (node2 != null && node2.nodeId == NodeType.NOTNODE) {
                        node = node2;
                    } else {
                        assert (false) : node2;
                        return null;
                    }
                }
                int n3 = 1;
                int n4 = AstUtilities.getRange((Node)node).getStart();
                int n5 = LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)n4);
                if (n5 == -1 || n5 > baseDocument.getLength() - 1) {
                    return null;
                }
                int n6 = this.ifNode.getPosition().getStartOffset();
                int n7 = LexUtilities.getLexerOffset((CompilationInfo)this.info, (int)n6);
                if (n7 == -1 || n7 > baseDocument.getLength()) {
                    return null;
                }
                boolean bl = false;
                char c = baseDocument.getText(n5, 1).charAt(0);
                if (c != '!') {
                    n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5);
                    String string = baseDocument.getText(n5, n2 - n5);
                    n = string.indexOf("!=");
                    if (n == -1) {
                        n = string.indexOf("!~");
                        if (n != -1) {
                            n5 += n;
                        } else {
                            String string2;
                            boolean bl2 = false;
                            if (n5 < baseDocument.getLength() - 3 && "not".equals(string2 = baseDocument.getText(n5, 3))) {
                                n3 = 3;
                                if (n5 < baseDocument.getLength() - 4 && "not ".equals(string2 = baseDocument.getText(n5, 4))) {
                                    n3 = 4;
                                }
                                bl2 = true;
                            }
                            if (!bl2) {
                                assert (false) : string;
                                return null;
                            }
                        }
                    } else {
                        n5 += n;
                        bl = true;
                    }
                }
                if ((n2 = ConvertIfToUnless.findKeywordOffset(this.info, this.ifNode)) == -1 || n2 > baseDocument.getLength() - 1) {
                    return null;
                }
                assert (n2 < n5);
                char c2 = baseDocument.getText(n2, 1).charAt(0);
                n = c2 == 'i' ? 1 : 0;
                EditList editList = new EditList(baseDocument);
                if (bl) {
                    editList.replace(n5, 1, "=", false, 0);
                } else {
                    editList.replace(n5, n3, null, false, 0);
                }
                if (n != 0) {
                    editList.replace(n2, 2, "unless", false, 1);
                } else {
                    editList.replace(n2, 6, "if", false, 1);
                }
                return editList;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return null;
            }
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

