/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelCaseNames
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        hashSet.add(NodeType.LOCALASGNNODE);
        hashSet.add(NodeType.DEFNNODE);
        hashSet.add(NodeType.DEFSNODE);
        return hashSet;
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        org.jruby.ast.Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        String string = ((INameNode)node).getName();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            String string2 = node.nodeId == NodeType.LOCALASGNNODE ? "InvalidLocalName" : "InvalidMethodName";
            String string3 = NbBundle.getMessage(CamelCaseNames.class, (String)string2);
            OffsetRange offsetRange = AstUtilities.getNameRange((org.jruby.ast.Node)node);
            if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                ArrayList<Fix> arrayList = new ArrayList<Fix>(2);
                org.jruby.ast.Node node2 = AstUtilities.getRoot((CompilationInfo)compilationInfo);
                AstPath astPath = new AstPath(node2, node);
                if (node.nodeId == NodeType.LOCALASGNNODE) {
                    arrayList.add(new RenameFix(compilationInfo, astPath, RubyUtils.camelToUnderlinedName((String)string)));
                }
                arrayList.add(new RenameFix(compilationInfo, astPath, null));
                Description description = new Description(this, string3, compilationInfo.getFileObject(), offsetRange, arrayList, 1500);
                list.add(description);
            }
            return;
        }
    }

    @Override
    public String getId() {
        return "Camelcase_Names";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNames");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNamesDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameFix
    implements PreviewableFix,
    Runnable {
        private CompilationInfo info;
        private AstPath path;
        private String newName;

        RenameFix(CompilationInfo compilationInfo, AstPath astPath, String string) {
            this.info = compilationInfo;
            this.path = astPath;
            this.newName = string;
        }

        @Override
        public String getDescription() {
            if (this.newName != null) {
                return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameTo", (Object)this.newName);
            }
            return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameVar");
        }

        private Set<OffsetRange> getRanges() {
            org.jruby.ast.Node node = this.path.leaf();
            assert (node.nodeId == NodeType.LOCALASGNNODE);
            String string = ((INameNode)node).getName();
            org.jruby.ast.Node node2 = AstUtilities.findLocalScope((org.jruby.ast.Node)node, (AstPath)this.path);
            HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
            this.addLocalRegions(node2, string, hashSet);
            return hashSet;
        }

        private String getOldName() {
            org.jruby.ast.Node node = this.path.leaf();
            assert (node.nodeId == NodeType.LOCALASGNNODE);
            String string = ((INameNode)node).getName();
            return string;
        }

        private EditList getEditList(String string) throws Exception {
            int n = this.getOldName().length();
            Set<OffsetRange> set = this.getRanges();
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            EditList editList = new EditList(baseDocument);
            for (OffsetRange offsetRange : set) {
                editList.replace(offsetRange.getStart(), n, string, false, 0);
                assert (offsetRange.getLength() == n);
            }
            return editList;
        }

        @Override
        public boolean canPreview() {
            return this.newName != null;
        }

        @Override
        public EditList getEditList() throws Exception {
            return this.getEditList(this.newName != null ? this.newName : "new_name");
        }

        @Override
        public void implement() throws Exception {
            if (this.newName != null) {
                EditList editList = this.getEditList(this.newName);
                editList.apply();
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.info.getFileObject());
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                Node node = dataObject.getNodeDelegate();
                InstanceContent instanceContent = new InstanceContent();
                instanceContent.add((Object)editorCookie);
                instanceContent.add((Object)node);
                AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
                Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
                action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }

        private void addLocalRegions(org.jruby.ast.Node node, String string, Set<OffsetRange> set) {
            List list;
            if ((node.nodeId == NodeType.LOCALASGNNODE || node.nodeId == NodeType.LOCALVARNODE) && string.equals(((INameNode)node).getName())) {
                list = AstUtilities.getNameRange((org.jruby.ast.Node)node);
                if ((list = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)list)) != OffsetRange.NONE) {
                    set.add((OffsetRange)list);
                }
            }
            list = node.childNodes();
            for (org.jruby.ast.Node node2 : list) {
                if (node2 instanceof MethodDefNode) continue;
                this.addLocalRegions(node2, string, set);
            }
        }

        @Override
        public boolean isSafe() {
            return false;
        }

        @Override
        public boolean isInteractive() {
            return true;
        }
    }
}

