/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.util.List;
import org.netbeans.modules.bpel.refactoring.Util;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.model.visitor.ChildVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WsdlVisitor
extends ChildVisitor {
    private Referenceable myTarget;
    private List<Component> myUsage;

    WsdlVisitor(List<Component> list, Referenceable referenceable) {
        this.myUsage = list;
        this.myTarget = referenceable;
    }

    public void visit(ExtensibilityElement extensibilityElement) {
        this.checkUsages((Component)extensibilityElement);
        if (extensibilityElement instanceof CorrelationProperty) {
            this.visitProperty((CorrelationProperty)extensibilityElement);
        } else if (extensibilityElement instanceof PropertyAlias) {
            this.visitAlias((PropertyAlias)extensibilityElement);
        } else if (extensibilityElement instanceof PartnerLinkType) {
            this.visitPartnerLinkType((PartnerLinkType)extensibilityElement);
        }
    }

    private void visitProperty(CorrelationProperty correlationProperty) {
        Util.visit((NamedComponentReference<GlobalType>)correlationProperty.getType(), (NamedComponentReference<GlobalElement>)correlationProperty.getElement(), this.myTarget, (Component)correlationProperty, this.myUsage);
    }

    private void visitAlias(PropertyAlias propertyAlias) {
        Util.visit((NamedComponentReference<GlobalType>)propertyAlias.getType(), (NamedComponentReference<GlobalElement>)propertyAlias.getElement(), this.myTarget, (Component)propertyAlias, this.myUsage);
        Util.visit((Reference)propertyAlias.getMessageType(), this.myTarget, (Component)propertyAlias, this.myUsage);
        Util.visit((Reference)propertyAlias.getPropertyName(), this.myTarget, (Component)propertyAlias, this.myUsage);
        if (this.myTarget instanceof Part) {
            this.visit(propertyAlias, (Part)this.myTarget);
        }
        if (!(this.myTarget instanceof Named)) {
            return;
        }
        Query query = propertyAlias.getQuery();
        if (Util.checkQuery(query, ((Named)this.myTarget).getName()) != -1) {
            this.myUsage.add((Component)query);
        }
    }

    private void visitPartnerLinkType(PartnerLinkType partnerLinkType) {
        this.visitRole(partnerLinkType.getRole1());
        this.visitRole(partnerLinkType.getRole2());
    }

    private void visitRole(Role role) {
        if (role == null) {
            return;
        }
        Util.visit((Reference)role.getPortType(), this.myTarget, (Component)role, this.myUsage);
        this.checkUsages((Component)role);
    }

    private void visit(PropertyAlias propertyAlias, Part part) {
        if (!part.getName().equals(propertyAlias.getPart())) {
            return;
        }
        NamedComponentReference namedComponentReference = propertyAlias.getMessageType();
        if (namedComponentReference == null || namedComponentReference.get() == null) {
            return;
        }
        if (namedComponentReference.get().equals(part.getParent())) {
            this.myUsage.add((Component)propertyAlias);
        }
    }

    private void checkUsages(Component component) {
        if (this.myTarget.equals(component)) {
            this.myUsage.add(component);
        }
    }
}

