/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.util.List;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.FinalCounterValue;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromPart;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.RepeatEvery;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.Source;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.Target;
import org.netbeans.modules.bpel.model.api.Throw;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.ToPart;
import org.netbeans.modules.bpel.model.api.Validate;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitorAdaptor;
import org.netbeans.modules.bpel.refactoring.Util;
import org.netbeans.modules.bpel.refactoring.XPath;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BpelVisitor
extends SimpleBpelModelVisitorAdaptor {
    private XPath myXPath;
    private Referenceable myTarget;
    private List<Component> myUsage;

    BpelVisitor(List<Component> list, Referenceable referenceable) {
        if (referenceable instanceof Named) {
            Named named = (Named)referenceable;
            this.myXPath = new XPath(list, named, named.getName());
        }
        this.myUsage = list;
        this.myTarget = referenceable;
    }

    public void visit(Import import_) {
        if (ImportHelper.getWsdlModel((Import)import_) == this.myTarget || ImportHelper.getSchemaModel((Import)import_) == this.myTarget) {
            this.myUsage.add((Component)import_);
        }
    }

    public void visit(PartnerLink partnerLink) {
        Util.visit((Reference)partnerLink.getPartnerLinkType(), this.myTarget, (Component)partnerLink, this.myUsage);
        Util.visit((Reference)partnerLink.getMyRole(), this.myTarget, (Component)partnerLink, this.myUsage);
        Util.visit((Reference)partnerLink.getPartnerRole(), this.myTarget, (Component)partnerLink, this.myUsage);
    }

    public void visit(Validate validate) {
        List list = validate.getVaraibles();
        if (list == null) {
            return;
        }
        for (BpelReference bpelReference : list) {
            Util.visit((Reference)bpelReference, this.myTarget, (Component)validate, this.myUsage);
        }
    }

    public void visit(StartCounterValue startCounterValue) {
        this.visitContentElement((BpelEntity)startCounterValue);
    }

    public void visit(FinalCounterValue finalCounterValue) {
        this.visitContentElement((BpelEntity)finalCounterValue);
    }

    public void visit(Branches branches) {
        this.visitContentElement((BpelEntity)branches);
    }

    public void visit(BooleanExpr booleanExpr) {
        this.visitContentElement((BpelEntity)booleanExpr);
    }

    public void visit(RepeatEvery repeatEvery) {
        this.visitContentElement((BpelEntity)repeatEvery);
    }

    public void visit(DeadlineExpression deadlineExpression) {
        this.visitContentElement((BpelEntity)deadlineExpression);
    }

    public void visit(For for_) {
        this.visitContentElement((BpelEntity)for_);
    }

    public void visit(CorrelationSet correlationSet) {
        List list = correlationSet.getProperties();
        if (list == null) {
            return;
        }
        for (WSDLReference wSDLReference : list) {
            Util.visit((Reference)wSDLReference, this.myTarget, (Component)correlationSet, this.myUsage);
        }
    }

    public void visit(Correlation correlation) {
        Util.visit((Reference)correlation.getSet(), this.myTarget, (Component)correlation, this.myUsage);
    }

    public void visit(Source source) {
        Util.visit((Reference)source.getLink(), this.myTarget, (Component)source, this.myUsage);
    }

    public void visit(Target target) {
        Util.visit((Reference)target.getLink(), this.myTarget, (Component)target, this.myUsage);
    }

    public void visit(From from) {
        Util.visit((Reference)from.getPart(), this.myTarget, (Component)from, this.myUsage);
        Util.visit((Reference)from.getProperty(), this.myTarget, (Component)from, this.myUsage);
        Util.visit((Reference)from.getVariable(), this.myTarget, (Component)from, this.myUsage);
        Util.visit((Reference)from.getPartnerLink(), this.myTarget, (Component)from, this.myUsage);
        this.visitContentElement((BpelEntity)from);
    }

    public void visit(FromPart fromPart) {
        Util.visit((Reference)fromPart.getToVariable(), this.myTarget, (Component)fromPart, this.myUsage);
    }

    public void visit(To to) {
        Util.visit((Reference)to.getPart(), this.myTarget, (Component)to, this.myUsage);
        Util.visit((Reference)to.getProperty(), this.myTarget, (Component)to, this.myUsage);
        Util.visit((Reference)to.getVariable(), this.myTarget, (Component)to, this.myUsage);
        Util.visit((Reference)to.getPartnerLink(), this.myTarget, (Component)to, this.myUsage);
        this.visitContentElement((BpelEntity)to);
    }

    public void visit(ToPart toPart) {
        Util.visit((Reference)toPart.getFromVariable(), this.myTarget, (Component)toPart, this.myUsage);
    }

    private void visitContentElement(BpelEntity bpelEntity) {
        if (this.myXPath != null) {
            this.myXPath.visit(((ContentElement)bpelEntity).getContent(), (Component)bpelEntity);
        }
    }

    public void visit(OnEvent onEvent) {
        Util.visit((Reference)onEvent.getMessageType(), this.myTarget, (Component)onEvent, this.myUsage);
        Util.visit((Reference)onEvent.getPortType(), this.myTarget, (Component)onEvent, this.myUsage);
        Util.visit((Reference)onEvent.getOperation(), this.myTarget, (Component)onEvent, this.myUsage);
        Util.visit((Reference)onEvent.getMessageExchange(), this.myTarget, (Component)onEvent, this.myUsage);
        Util.visit((Reference)onEvent.getPartnerLink(), this.myTarget, (Component)onEvent, this.myUsage);
    }

    public void visit(OnMessage onMessage) {
        Util.visit((Reference)onMessage.getPortType(), this.myTarget, (Component)onMessage, this.myUsage);
        Util.visit((Reference)onMessage.getOperation(), this.myTarget, (Component)onMessage, this.myUsage);
        Util.visit((Reference)onMessage.getMessageExchange(), this.myTarget, (Component)onMessage, this.myUsage);
        Util.visit((Reference)onMessage.getVariable(), this.myTarget, (Component)onMessage, this.myUsage);
        Util.visit((Reference)onMessage.getPartnerLink(), this.myTarget, (Component)onMessage, this.myUsage);
    }

    public void visit(Catch catch_) {
        Util.visit((Reference)catch_.getFaultMessageType(), this.myTarget, (Component)catch_, this.myUsage);
        Util.visit(catch_.getFaultName(), this.myTarget, (Component)catch_, this.myUsage);
        Util.visit((Reference)catch_.getFaultElement(), this.myTarget, (Component)catch_, this.myUsage);
    }

    public void visit(Reply reply) {
        Util.visit(reply.getFaultName(), this.myTarget, (Component)reply, this.myUsage);
        Util.visit((Reference)reply.getPortType(), this.myTarget, (Component)reply, this.myUsage);
        Util.visit((Reference)reply.getOperation(), this.myTarget, (Component)reply, this.myUsage);
        Util.visit((Reference)reply.getMessageExchange(), this.myTarget, (Component)reply, this.myUsage);
        Util.visit((Reference)reply.getVariable(), this.myTarget, (Component)reply, this.myUsage);
        Util.visit((Reference)reply.getPartnerLink(), this.myTarget, (Component)reply, this.myUsage);
    }

    public void visit(Receive receive) {
        Util.visit((Reference)receive.getPortType(), this.myTarget, (Component)receive, this.myUsage);
        Util.visit((Reference)receive.getOperation(), this.myTarget, (Component)receive, this.myUsage);
        Util.visit((Reference)receive.getMessageExchange(), this.myTarget, (Component)receive, this.myUsage);
        Util.visit((Reference)receive.getVariable(), this.myTarget, (Component)receive, this.myUsage);
        Util.visit((Reference)receive.getPartnerLink(), this.myTarget, (Component)receive, this.myUsage);
    }

    public void visit(Invoke invoke) {
        Util.visit((Reference)invoke.getPortType(), this.myTarget, (Component)invoke, this.myUsage);
        Util.visit((Reference)invoke.getOperation(), this.myTarget, (Component)invoke, this.myUsage);
        Util.visit((Reference)invoke.getInputVariable(), this.myTarget, (Component)invoke, this.myUsage);
        Util.visit((Reference)invoke.getOutputVariable(), this.myTarget, (Component)invoke, this.myUsage);
        Util.visit((Reference)invoke.getPartnerLink(), this.myTarget, (Component)invoke, this.myUsage);
        if (invoke.getCompensationHandler() == this.myTarget) {
            this.myUsage.add((Component)invoke);
        }
    }

    public void visit(Scope scope) {
        if (scope.getCompensationHandler() == this.myTarget) {
            this.myUsage.add((Component)scope);
        }
    }

    public void visit(CompensateScope compensateScope) {
        Util.visit((Reference)compensateScope.getTarget(), this.myTarget, (Component)compensateScope, this.myUsage);
    }

    public void visit(Throw throw_) {
        Util.visit(throw_.getFaultName(), this.myTarget, (Component)throw_, this.myUsage);
        Util.visit((Reference)throw_.getFaultVariable(), this.myTarget, (Component)throw_, this.myUsage);
    }

    public void visit(Variable variable) {
        Util.visit((Reference)variable.getMessageType(), this.myTarget, (Component)variable, this.myUsage);
        Util.visit((NamedComponentReference<GlobalType>)variable.getType(), (NamedComponentReference<GlobalElement>)variable.getElement(), this.myTarget, (Component)variable, this.myUsage);
    }
}

