/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.JMXConnection;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JMXConnectionException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class AbstractJMXClient {
    private static I18NBundle sI18NBundle = null;
    protected JMXConnection mJmxConnection;

    protected AbstractJMXClient() {
    }

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    protected JMXConnection getJMXConnection() {
        return this.mJmxConnection;
    }

    protected void setJMXConnection(JMXConnection jmxConn) {
        this.mJmxConnection = jmxConn;
    }

    protected void openJmxConnection() throws JBIRemoteException {
        try {
            this.mJmxConnection.openConnection();
        }
        catch (JMXConnectionException jmxEx) {
            throw new JBIRemoteException(jmxEx);
        }
    }

    protected void closeJmxConnection() throws JBIRemoteException {
        try {
            this.mJmxConnection.closeConnection();
        }
        catch (JMXConnectionException jmxEx) {
            throw new JBIRemoteException(jmxEx);
        }
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] signature) throws JBIRemoteException {
        Object result = null;
        this.openJmxConnection();
        try {
            result = this.mJmxConnection.invokeMBeanOperation(objectName, operationName, params, signature);
        }
        catch (JMXConnectionException jmxEx) {
            throw new JBIRemoteException(jmxEx);
        }
        catch (JBIRemoteException jbiREx) {
            throw jbiREx;
        }
        finally {
            try {
                this.closeJmxConnection();
            }
            catch (Exception ex) {}
        }
        return result;
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, String param) throws JBIRemoteException {
        Object result = null;
        Object[] params = new Object[]{param};
        String[] signature = new String[]{"java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, String param1, String param2) throws JBIRemoteException {
        Object result = null;
        Object[] params = new Object[]{param1, param2};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, String param1, String param2, String param3) throws JBIRemoteException {
        Object result = null;
        Object[] params = new Object[]{param1, param2, param3};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    public Object invokeMBeanOperation(ObjectName objectName, String operationName, String param1, String param2, String param3, String param4) throws JBIRemoteException {
        Object result = null;
        Object[] params = new Object[]{param1, param2, param3, param4};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        return this.invokeMBeanOperation(objectName, operationName, params, signature);
    }

    public Object getMBeanAttribute(ObjectName objectName, String attributeName) throws JBIRemoteException {
        Object result = null;
        this.openJmxConnection();
        try {
            result = this.mJmxConnection.getMBeanAttribute(objectName, attributeName);
        }
        catch (JMXConnectionException jmxEx) {
            throw new JBIRemoteException(jmxEx);
        }
        catch (JBIRemoteException jbiREx) {
            throw jbiREx;
        }
        finally {
            try {
                this.closeJmxConnection();
            }
            catch (Exception ex) {}
        }
        return result;
    }

    public ObjectName getAdminServiceMBeanObjectName() throws JBIRemoteException {
        try {
            ObjectName mbeanName = JBIJMXObjectNames.getAdminServiceMBeanObjectName();
            return mbeanName;
        }
        catch (MalformedObjectNameException objEx) {
            throw new JBIRemoteException(objEx.getMessage(), objEx);
        }
    }

    public ObjectName getJbiAdminUiMBeanObjectName() throws JBIRemoteException {
        try {
            ObjectName mbeanName = JBIJMXObjectNames.getJbiAdminUiMBeanObjectName();
            return mbeanName;
        }
        catch (MalformedObjectNameException objEx) {
            throw new JBIRemoteException(objEx.getMessage(), objEx);
        }
    }
}

