/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.helper.PerformanceDataXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceDataMapReader
extends DefaultHandler
implements PerformanceDataXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private PerformanceData data;
    private Map<String, PerformanceData> dataMap;
    private String performanceDataListVersion;

    public Map<String, PerformanceData> getPerformanceDataMap() {
        return this.dataMap;
    }

    @Override
    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    @Override
    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("PerformanceMeasurementDataList")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.performanceDataListVersion = attributes.getValue("version");
                    if (this.performanceDataListVersion != null && "1.0".equals(this.performanceDataListVersion)) {
                        this.dataMap = new HashMap<String, PerformanceData>();
                    }
                }
            } else if (qName.endsWith("PerformanceMeasurementData") && this.dataMap != null) {
                this.data = new PerformanceData();
            }
            this.qNameStack.push(qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("category")) {
            if (this.data != null) {
                this.data.setCategory(chars);
            }
        } else if (qName.endsWith("endpoint")) {
            if (this.data != null) {
                this.data.setEndpoint(chars);
            }
        } else if (qName.endsWith("sourceClassName")) {
            if (this.data != null) {
                this.data.setSourceClassName(chars);
            }
        } else if (qName.endsWith("numberOfMeasurementObjects")) {
            if (this.data != null) {
                int numberOfMeasurementObjects = Integer.valueOf(chars);
                this.data.setNumberOfMeasurementObjects(numberOfMeasurementObjects);
            }
        } else if (qName.endsWith("numberOfMeasurements")) {
            if (this.data != null) {
                int numberOfMeasurements = Integer.valueOf(chars);
                this.data.setNumberOfMeasurements(numberOfMeasurements);
            }
        } else if (qName.endsWith("average")) {
            if (this.data != null) {
                double average = Double.valueOf(chars);
                this.data.setAverage(average);
            }
        } else if (qName.endsWith("averageWithoutFirstMeasurement")) {
            if (this.data != null) {
                double averageWithoutFirstMeasurement = Double.valueOf(chars);
                this.data.setAverageWithoutFirstMeasurement(averageWithoutFirstMeasurement);
            }
        } else if (qName.endsWith("firstMeasurementTime")) {
            if (this.data != null) {
                double firstMeasurementTime = Double.valueOf(chars);
                this.data.setFirstMeasurementTime(firstMeasurementTime);
            }
        } else if (qName.endsWith("load")) {
            if (this.data != null) {
                double load = Double.valueOf(chars);
                this.data.setLoad(load);
            }
        } else if (qName.endsWith("median")) {
            if (this.data != null) {
                double median = Double.valueOf(chars);
                this.data.setMedian(median);
            }
        } else if (qName.endsWith("throughput")) {
            if (this.data != null) {
                double throughput = Double.valueOf(chars);
                this.data.setThroughput(throughput);
            }
        } else if (qName.endsWith("timeTaken")) {
            if (this.data != null) {
                double timeTaken = Double.valueOf(chars);
                this.data.setTimeTaken(timeTaken);
            }
        } else if (qName.endsWith("totalTime") && this.data != null) {
            double totalTime = Double.valueOf(chars);
            this.data.setTotalTime(totalTime);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null && qName.endsWith("PerformanceMeasurementData") && this.dataMap != null && this.data != null) {
            this.dataMap.put(this.data.getCategory(), this.data);
            this.data = null;
        }
    }

    public static Map<String, PerformanceData> parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        PerformanceDataMapReader parser = new PerformanceDataMapReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getPerformanceDataMap();
    }

    public static Map<String, PerformanceData> parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return PerformanceDataMapReader.parseFromFile(file);
    }

    public static Map<String, PerformanceData> parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        PerformanceDataMapReader parser = new PerformanceDataMapReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getPerformanceDataMap();
    }

    public static Map<String, PerformanceData> parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return PerformanceDataMapReader.parseFromURI(uri);
    }

    public static Map<String, PerformanceData> parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        PerformanceDataMapReader parser = new PerformanceDataMapReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getPerformanceDataMap();
    }

    public static void main(String[] args) {
        String uri = "C:/test/performance/PerformanceMeasurementDataList.xml";
        try {
            Map<String, PerformanceData> map = PerformanceDataMapReader.parseFromFile(uri);
            for (String category : map.keySet()) {
                System.out.println(map.get(category).getDisplayString());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

