/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data;

import java.io.Serializable;
import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class JavaEEVerifierReport
implements Serializable {
    static final long serialVersionUID = -1L;
    String serviceUnitName;
    ArrayList<JavaEEReportItem> reportTable = new ArrayList();
    static String[] JAVAEE_VERIFIER_ITEM_NAMES = new String[]{"Ear Filename", "Reference By", "Reference Class", "JNDI Name", "JNDI Class Type", "Message", "Status"};
    static String[] JAVAEE_VERIFIER_ITEM_DESCRIPTIONS = new String[]{"Ear File Name", "Reference By", "Reference Class", "Jndi Name", "Jndi Class", "Message", "Status"};
    static OpenType[] JAVAEE_VERIFIER_ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER};

    public String getServiceUnitName() {
        return this.serviceUnitName;
    }

    public void setServiceUnitName(String serviceUnitName) {
        this.serviceUnitName = serviceUnitName;
    }

    public ArrayList getJavaEEVerifierReport() {
        return this.reportTable;
    }

    public void setJavaEEVerifierReport(TabularData javaEEReportTable) {
        if (javaEEReportTable != null) {
            for (CompositeData cdata : javaEEReportTable.values()) {
                JavaEEReportItem reportItem = new JavaEEReportItem();
                reportItem.setEarFileName((String)cdata.get("Ear Filename"));
                reportItem.setReferenceBy((String)cdata.get("Referrence By"));
                reportItem.setReferenceClass((String)cdata.get("Referrence Class"));
                reportItem.setJndiName((String)cdata.get("JNDI Name"));
                reportItem.setJndiClass((String)cdata.get("JNDI Class Type"));
                reportItem.setMessage((String)cdata.get("Message"));
                reportItem.setStatus((Integer)cdata.get("Status"));
                this.reportTable.add(reportItem);
            }
        }
    }

    public void addJavaEEVerifierReportItem(JavaEEReportItem tableItem) {
        JavaEEReportItem item = new JavaEEReportItem();
        item.setEarFileName(tableItem.getEarFileName());
        item.setReferenceBy(tableItem.getReferenceBy());
        item.setReferenceClass(tableItem.getReferenceClass());
        item.setJndiName(tableItem.getJndiName());
        item.setJndiClass(tableItem.getJndiClass());
        item.setMessage(tableItem.getMessage());
        item.setStatus(tableItem.getStatus());
        this.reportTable.add(item);
    }

    public static CompositeType getReportItemCompositeType() throws OpenDataException {
        return new CompositeType("JavaEEVerifierReportItem", "JavaEE Verifier Report Item", JAVAEE_VERIFIER_ITEM_NAMES, JAVAEE_VERIFIER_ITEM_DESCRIPTIONS, JAVAEE_VERIFIER_ITEM_TYPES);
    }

    public CompositeData getCompositeData() throws OpenDataException {
        TabularType reportTableType = new TabularType("JavaEEVerifierTableType", "Java EE Verification Report Table Type", JavaEEVerifierReport.getReportItemCompositeType(), new String[]{"Reference Class", "Reference By", "JNDI Name"});
        String[] javaEEVerifierReportItemNames = new String[]{"ServiceUnitName", "JavaEEVerifierReport"};
        String[] javaEEVerifierReportItemDesc = new String[]{"Service Unit Name", "Java EE Verifier Report"};
        OpenType[] javaEEVerifierReportItemTypes = new OpenType[]{SimpleType.STRING, reportTableType};
        CompositeType javaEEVerifierReport = new CompositeType("JavaEEVerifierReport", "Java EE Verifier Report", javaEEVerifierReportItemNames, javaEEVerifierReportItemDesc, javaEEVerifierReportItemTypes);
        TabularDataSupport table = new TabularDataSupport(reportTableType);
        for (JavaEEReportItem item : this.reportTable) {
            table.put(item.getCompositeData());
        }
        return new CompositeDataSupport(javaEEVerifierReport, javaEEVerifierReportItemNames, new Object[]{this.getServiceUnitName(), table});
    }

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n    Service Unit Name=" + this.getServiceUnitName());
        buffer.append("\n    VerifierReport\n");
        for (JavaEEReportItem item : this.reportTable) {
            buffer.append("\n " + item.getDisplayString());
        }
        return buffer.toString();
    }

    public class JavaEEReportItem {
        private String earFileName;
        private String referenceBy;
        private String referenceClass;
        private String jndiName;
        private String jndiClass;
        private String message;
        private int status;

        public String getEarFileName() {
            return this.earFileName;
        }

        public void setEarFileName(String earFileName) {
            this.earFileName = earFileName;
        }

        public String getReferenceBy() {
            return this.referenceBy;
        }

        public void setReferenceBy(String referenceBy) {
            this.referenceBy = referenceBy;
        }

        public String getReferenceClass() {
            return this.referenceClass;
        }

        public void setReferenceClass(String referenceClass) {
            this.referenceClass = referenceClass;
        }

        public String getJndiClass() {
            return this.jndiClass;
        }

        public void setJndiClass(String jndiClass) {
            this.jndiClass = jndiClass;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        private String getDisplayString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n    Ear File Name=" + this.getEarFileName());
            buffer.append("\n    Reference By=" + this.getReferenceBy());
            buffer.append("\n    Reference Class=" + this.getReferenceClass());
            buffer.append("\n    Jndi Name=" + this.getJndiName());
            buffer.append("\n    Jndi Class=" + this.getJndiClass());
            buffer.append("\n    Message=" + this.getMessage());
            buffer.append("\n    Status=" + this.getStatus());
            buffer.append("\n");
            return buffer.toString();
        }

        public CompositeData getCompositeData() throws OpenDataException {
            return new CompositeDataSupport(JavaEEVerifierReport.getReportItemCompositeType(), JAVAEE_VERIFIER_ITEM_NAMES, new Object[]{this.getEarFileName(), this.getReferenceBy(), this.getReferenceClass(), this.getJndiName(), this.getJndiClass(), this.getMessage(), this.getStatus()});
        }
    }
}

