/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultPanelOutput;
import org.netbeans.modules.junit.output.ResultPanelTree;
import org.netbeans.modules.junit.output.StatisticsPanel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

final class ResultDisplayHandler {
    private static ResourceBundle bundle = NbBundle.getBundle(ResultDisplayHandler.class);
    private ResultPanelTree treePanel;
    private ResultPanelOutput outputListener;
    private Component displayComp;
    static final Object[] EMPTY_QUEUE = new Object[0];
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private int outputQueueAvailSpace;
    static final String ANONYMOUS_SUITE = new String();
    private String runningSuite;
    private List<Report> reports;
    private String message;
    private boolean sessionFinished;
    private Map<String, Method> methodsMap;

    ResultDisplayHandler() {
    }

    Component getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private Component createDisplayComp() {
        StatisticsPanel statisticsPanel = new StatisticsPanel(this);
        ResultPanelOutput resultPanelOutput = new ResultPanelOutput(this);
        JSplitPane jSplitPane = new JSplitPane(1, (Component)statisticsPanel, (Component)resultPanelOutput){

            public void addNotify() {
                super.addNotify();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = JUnitSettings.getDefault().getResultsSplitPaneDivider();
                        if (n != -1) {
                            this.setDividerLocation(n);
                        }
                    }
                });
            }

            public void removeNotify() {
                JUnitSettings.getDefault().setResultsSplitPaneDivider(this.getDividerLocation());
                super.removeNotify();
            }
        };
        jSplitPane.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultPanelTree"));
        jSplitPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultPanelTree"));
        return jSplitPane;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutputListener(ResultPanelOutput resultPanelOutput) {
        Object object = this.queueLock;
        synchronized (object) {
            this.outputListener = resultPanelOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOutput(String string, boolean bl) {
        Object object = this.queueLock;
        synchronized (object) {
            int n;
            if (this.outputQueue == null) {
                this.outputQueue = new Object[40];
                this.outputQueueAvailSpace = this.outputQueue.length - 1;
                this.outputQueueSize = 0;
            }
            int n2 = n = bl ? 2 : 1;
            if ((this.outputQueueAvailSpace -= n) < 0) {
                int n3 = this.outputQueue.length < 640 ? this.outputQueue.length * 2 : this.outputQueue.length * 3 / 2;
                Object[] objectArray = this.outputQueue;
                this.outputQueue = new Object[n3];
                System.arraycopy(objectArray, 0, this.outputQueue, 0, this.outputQueueSize);
                this.outputQueueAvailSpace += this.outputQueue.length - objectArray.length;
            }
            if (bl) {
                this.outputQueue[this.outputQueueSize++] = Boolean.TRUE;
            }
            this.outputQueue[this.outputQueueSize++] = string;
            if (this.outputListener != null) {
                this.outputListener.outputAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] objectArray = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displaySuiteRunning(String string) {
        assert (this.runningSuite == null);
        string = string != null ? string : ANONYMOUS_SUITE;
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.runningSuite = string;
                return;
            }
        }
        this.displayInDispatchThread("displaySuiteRunning", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                if (this.reports == null) {
                    this.reports = new ArrayList<Report>(10);
                }
                this.reports.add(report);
                this.runningSuite = null;
                return;
            }
        }
        this.displayInDispatchThread("displayReport", report);
        assert (this.runningSuite == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessage(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread("displayMsg", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessageSessionFinished(String string) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.sessionFinished = true;
                this.message = string;
                return;
            }
        }
        this.displayInDispatchThread("displayMsgSessionFinished", string);
    }

    private void displayInDispatchThread(String string, final Object object) {
        assert (string != null);
        assert (this.treePanel != null);
        final Method method = this.prepareMethod(string);
        if (method == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    method.invoke((Object)ResultDisplayHandler.this.treePanel, object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(65536, (Throwable)exception);
                }
            }
        });
    }

    private Method prepareMethod(String string) {
        Method method;
        if (this.methodsMap == null) {
            this.methodsMap = new HashMap<String, Method>(4);
            method = null;
        } else {
            method = this.methodsMap.get(string);
        }
        if (method == null && !this.methodsMap.containsKey(string)) {
            Class clazz;
            if (string.equals("displayReport")) {
                clazz = Report.class;
            } else {
                assert (string.equals("displayMsg") || string.equals("displayMsgSessionFinished") || string.equals("displaySuiteRunning"));
                clazz = String.class;
            }
            try {
                method = ResultPanelTree.class.getDeclaredMethod(string, clazz);
            }
            catch (Exception exception) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
            this.methodsMap.put(string, method);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTreePanel(ResultPanelTree resultPanelTree) {
        assert (EventQueue.isDispatchThread());
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel != null) {
                return;
            }
            this.treePanel = resultPanelTree;
        }
        if (this.message != null) {
            resultPanelTree.displayMsg(this.message);
            this.message = null;
        }
        if (this.reports != null) {
            resultPanelTree.displayReports(this.reports);
            this.reports = null;
        }
        if (this.runningSuite != null) {
            resultPanelTree.displaySuiteRunning(this.runningSuite != ANONYMOUS_SUITE ? this.runningSuite : null);
            this.runningSuite = null;
        }
        if (this.sessionFinished) {
            resultPanelTree.displayMsgSessionFinished(this.message);
        }
    }
}

