/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;

final class RegexpUtils {
    static final String TESTSUITE_PREFIX = "Testsuite: ";
    static final String TESTSUITE_STATS_PREFIX = "Tests run: ";
    static final String FLOAT_NUMBER_REGEX = "[0-9]*(?:\\.[0-9]+)?";
    static final String TIME_SECS_REGEX = "([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String TESTSUITE_STATS_REGEX = "Tests run: +([0-9]+), +Failures: +([0-9]+), +Errors: +([0-9]+), +Time elapsed: +([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String OUTPUT_DELIMITER_PREFIX = "--------";
    static final String STDOUT_LABEL = "Output";
    static final String STDERR_LABEL = "Error";
    static final String OUTPUT_DELIMITER_REGEX = "-{8,} (?:Standard (Output|Error)|-{3,}) -{8,}";
    static final String TESTCASE_PREFIX = "Testcase: ";
    static final String TESTCASE_ISSUE_REGEX = "\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    static final String TESTCASE_HEADER_PLAIN_REGEX = "\\p{Blank}*((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)\\p{Blank}+took\\p{Blank}+([0-9]*(?:\\.[0-9]+)?) +s(?:ec(?:ond)?(?:s|\\(s\\))?)?";
    static final String TESTCASE_HEADER_BRIEF_REGEX = "\\p{Blank}*((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*) *\\( *((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*) *\\) *:\\p{Blank}*(?:(FAILED) *|(?i:.*\\berror\\b.*))";
    static final String TESTCASE_EXCEPTION_REGEX = "((?:(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*\\.?(?:Exception|Error|ComparisonFailure))|java\\.lang\\.Throwable)(?: *: *(.*))?";
    static final String CALLSTACK_LINE_PREFIX = "at ";
    static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    static final String CALLSTACK_LINE_REGEX = "(?:\\t\\t?|  +| *\\t? *\\[catch\\] )at (?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)+(?: ?\\([^()]+\\))?";
    static final String NESTED_EXCEPTION_PREFIX = "Caused by: ";
    static final String NESTED_EXCEPTION_REGEX = "((?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*)(?:: (.*))?";
    static final String LOCATION_IN_FILE_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?";
    static final String XML_DECL_PREFIX = "<?xml";
    static final String XML_SPACE_REGEX = "[ \\t\\r\\n]";
    static final String XML_EQ_REGEX = "[ \\t\\r\\n]*=[ \\t\\r\\n]*";
    static final String XML_ENC_REGEX = "[A-Za-z][-A-Za-z0-9._]*";
    static final String XML_DECL_REGEX = "\\Q<?xml\\E[ \\t\\r\\n]+version[ \\t\\r\\n]*=[ \\t\\r\\n]*(?:\"1\\.0\"|'1\\.0')(?:[ \\t\\r\\n]+encoding[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])[A-Za-z][-A-Za-z0-9._]*\\1)?(?:[ \\t\\r\\n]+standalone[ \\t\\r\\n]*=[ \\t\\r\\n]*(['\"])(?:yes|no)\\2)?[ \\t\\r\\n]*\\?>";
    static final String TEST_LISTENER_PREFIX = "junit.framework.TestListener: ";
    static final String TESTS_COUNT_PREFIX = "tests to run: ";
    static final String START_OF_TEST_PREFIX = "startTest";
    static final String END_OF_TEST_PREFIX = "endTest";
    static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static Reference<RegexpUtils> instRef;
    private volatile Pattern fullJavaIdPattern;
    private volatile Pattern suiteStatsPattern;
    private volatile Pattern outputDelimPattern;
    private volatile Pattern testcaseIssuePattern;
    private volatile Pattern testcaseExceptPattern;
    private volatile Pattern callstackLinePattern;
    private volatile Pattern nestedExceptPattern;
    private volatile Pattern locationInFilePattern;
    private volatile Pattern testcaseHeaderBriefPattern;
    private volatile Pattern testcaseHeaderPlainPattern;
    private volatile Pattern xmlDeclPattern;
    private volatile Pattern floatNumPattern;

    static synchronized RegexpUtils getInstance() {
        RegexpUtils regexpUtils;
        RegexpUtils regexpUtils2 = regexpUtils = instRef != null ? instRef.get() : null;
        if (regexpUtils == null) {
            regexpUtils = new RegexpUtils();
            instRef = new WeakReference<RegexpUtils>(regexpUtils);
        }
        return regexpUtils;
    }

    private RegexpUtils() {
    }

    Pattern getFullJavaIdPattern() {
        if (this.fullJavaIdPattern == null) {
            this.fullJavaIdPattern = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*");
        }
        return this.fullJavaIdPattern;
    }

    Pattern getSuiteStatsPattern() {
        if (this.suiteStatsPattern == null) {
            this.suiteStatsPattern = Pattern.compile(TESTSUITE_STATS_REGEX);
        }
        return this.suiteStatsPattern;
    }

    Pattern getOutputDelimPattern() {
        if (this.outputDelimPattern == null) {
            this.outputDelimPattern = Pattern.compile(OUTPUT_DELIMITER_REGEX);
        }
        return this.outputDelimPattern;
    }

    Pattern getTestcaseHeaderBriefPattern() {
        if (this.testcaseHeaderBriefPattern == null) {
            this.testcaseHeaderBriefPattern = Pattern.compile(TESTCASE_HEADER_BRIEF_REGEX);
        }
        return this.testcaseHeaderBriefPattern;
    }

    Pattern getTestcaseHeaderPlainPattern() {
        if (this.testcaseHeaderPlainPattern == null) {
            this.testcaseHeaderPlainPattern = Pattern.compile(TESTCASE_HEADER_PLAIN_REGEX);
        }
        return this.testcaseHeaderPlainPattern;
    }

    Pattern getTestcaseIssuePattern() {
        if (this.testcaseIssuePattern == null) {
            this.testcaseIssuePattern = Pattern.compile(TESTCASE_ISSUE_REGEX);
        }
        return this.testcaseIssuePattern;
    }

    Pattern getTestcaseExceptionPattern() {
        if (this.testcaseExceptPattern == null) {
            this.testcaseExceptPattern = Pattern.compile(TESTCASE_EXCEPTION_REGEX);
        }
        return this.testcaseExceptPattern;
    }

    Pattern getNestedExceptionPattern() {
        if (this.nestedExceptPattern == null) {
            this.nestedExceptPattern = Pattern.compile(NESTED_EXCEPTION_REGEX);
        }
        return this.nestedExceptPattern;
    }

    Pattern getCallstackLinePattern() {
        if (this.callstackLinePattern == null) {
            this.callstackLinePattern = Pattern.compile(CALLSTACK_LINE_REGEX);
        }
        return this.callstackLinePattern;
    }

    Pattern getLocationInFilePattern() {
        if (this.locationInFilePattern == null) {
            this.locationInFilePattern = Pattern.compile(LOCATION_IN_FILE_REGEX);
        }
        return this.locationInFilePattern;
    }

    Pattern getXmlDeclPattern() {
        if (this.xmlDeclPattern == null) {
            this.xmlDeclPattern = Pattern.compile(XML_DECL_REGEX);
        }
        return this.xmlDeclPattern;
    }

    Pattern getFloatNumPattern() {
        if (this.floatNumPattern == null) {
            this.floatNumPattern = Pattern.compile(FLOAT_NUMBER_REGEX);
        }
        return this.floatNumPattern;
    }

    int parseTimeMillis(String string) throws NumberFormatException {
        int n;
        int n2;
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            n2 = Integer.parseInt(string);
            n = 0;
        } else {
            n2 = n3 == 0 ? 0 : Integer.parseInt(string.substring(0, n3));
            String string2 = string.substring(n3 + 1);
            if (string2.length() > 4) {
                string2 = string2.substring(0, 4);
            }
            int n4 = Integer.parseInt(string2);
            switch (string2.length()) {
                case 1: {
                    n = 100 * n4;
                    break;
                }
                case 2: {
                    n = 10 * n4;
                    break;
                }
                case 3: {
                    n = n4;
                    break;
                }
                case 4: {
                    n = (n4 + 5) / 10;
                    break;
                }
                default: {
                    assert (false);
                    n = 0;
                }
            }
        }
        return 1000 * n2 + n;
    }

    int parseTimeMillisNoNFE(String string) {
        if (string == null || !this.getFloatNumPattern().matcher(string).matches()) {
            return -1;
        }
        try {
            return this.parseTimeMillis(string);
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return -1;
        }
    }

    static String specialTrim(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (n = 0; n < n2 && ((c = cArray[n]) == ' ' || c == '\t'); ++n) {
        }
        if (n == n2) {
            return string.substring(n2);
        }
        int n3 = n2;
        while ((c = cArray[--n3]) == ' ' || c == '\t') {
        }
        if (n == 0 && n3 == n2 - 1) {
            return string;
        }
        return string.substring(n, n3 + 1);
    }
}

