/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TaskType;
import org.netbeans.modules.junit.output.TroubleParser;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 524288;
    private static final int PROGRESS_WORKUNITS = 32700;
    private static final int INITIAL_PROGRESS = 327;
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    private int expectedOneSuiteTests = 0;
    private int executedOneSuiteTests = 0;
    private int expectedSuitesCount = 0;
    private int executedSuitesCount = 0;
    private boolean testsuiteStatsKnown = false;
    private final AntSession session;
    private final TaskType sessionType;
    private ProgressHandle progressHandle;
    private boolean isDeterminateProgress;
    private int lastProgress = 0;
    private MessageFormat progressStepFormatSuiteName;
    private MessageFormat progressStepFormatAnonymous;
    private boolean expectXmlReport;
    private final File antScript;
    private final long timeOfSessionStart;
    private final Logger LOG;
    private final Logger progressLogger;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private Report topReport;
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private TroubleParser troubleParser;
    private String suiteName;
    private StringBuffer xmlOutputBuffer;
    private boolean readingOutputReport;
    private boolean lastHeaderBrief;
    private boolean waitingForIssueStatus;
    private final Manager manager = Manager.getInstance();
    private String classpath;
    private ClassPath platformSources;

    JUnitOutputReader(AntSession antSession, TaskType taskType, long l) {
        this.session = antSession;
        this.sessionType = taskType;
        this.antScript = antSession.getOriginatingScript();
        this.timeOfSessionStart = l;
        this.progressLogger = Logger.getLogger("org.netbeans.modules.junit.outputreader.progress");
        this.LOG = Logger.getLogger(this.getClass().getName());
    }

    void verboseMessageLogged(AntEvent antEvent) {
        String string;
        ClassPath classPath;
        Object object;
        String string2 = antEvent.getMessage();
        if (string2 == null) {
            this.LOG.finer("VERBOSE MSG: <null>");
            return;
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("VERBOSE MSG: \"" + string2 + '\"');
        }
        if (this.progressLogger.isLoggable(Level.FINEST)) {
            this.progressLogger.finest("VERBOSE: " + string2);
        }
        if (string2.startsWith("junit.framework.TestListener: ")) {
            object = string2.substring("junit.framework.TestListener: ".length());
            if (((String)object).startsWith("tests to run: ")) {
                block16: {
                    String string3 = ((String)object).substring("tests to run: ".length());
                    try {
                        int n = JUnitOutputReader.parseNonNegativeInteger(string3);
                        if (n > 0) {
                            this.expectedOneSuiteTests = n;
                            if (this.progressLogger.isLoggable(Level.FINER)) {
                                this.progressLogger.finer("expected # of tests in a suite: " + this.expectedOneSuiteTests);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled || this.expectedOneSuiteTests == 0) break block16;
                        throw new AssertionError();
                    }
                }
                return;
            }
            if (((String)object).startsWith("startTest")) {
                String string4 = ((String)object).substring("startTest".length());
                if (string4.length() == 0 || !Character.isLetterOrDigit(string4.charAt(0))) {
                    this.progressLogger.finest("test started");
                }
                return;
            }
            if (((String)object).startsWith("endTest")) {
                String string5 = ((String)object).substring("endTest".length());
                if (string5.length() == 0 || !Character.isLetterOrDigit(string5.charAt(0))) {
                    this.progressLogger.finest("test finished");
                    ++this.executedOneSuiteTests;
                    if (this.expectedOneSuiteTests < this.executedOneSuiteTests) {
                        this.expectedOneSuiteTests = this.executedOneSuiteTests;
                    }
                    this.updateProgress();
                }
                return;
            }
        }
        if (((Matcher)(object = RegexpUtils.CLASSPATH_ARGS.matcher(string2))).find()) {
            this.classpath = ((Matcher)object).group(1);
        }
        if (((Matcher)(object = RegexpUtils.JAVA_EXECUTABLE.matcher(string2))).find() && (classPath = this.findPlatformSources(string = ((Matcher)object).group(1))) != null) {
            this.platformSources = classPath;
        }
    }

    void messageLogged(AntEvent antEvent) {
        Object object;
        String string = antEvent.getMessage();
        if (string == null) {
            this.LOG.finer("NORMAL: <null>");
            return;
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("NORMAL: \"" + string + '\"');
        }
        if (this.progressLogger.isLoggable(Level.FINEST)) {
            this.progressLogger.finest("NORMAL:  " + string);
        }
        if (this.waitingForIssueStatus) {
            assert (this.testcase != null);
            object = this.regexp.getTestcaseIssuePattern().matcher(string);
            if (((Matcher)object).matches()) {
                boolean bl = ((Matcher)object).group(1) == null;
                this.trouble = this.testcase.trouble = new Report.Trouble(bl);
                this.waitingForIssueStatus = false;
                return;
            }
            this.report.reportTest(this.testcase);
            this.waitingForIssueStatus = false;
        }
        if (this.xmlOutputBuffer != null) {
            this.xmlOutputBuffer.append(string).append('\n');
            if (string.equals("</testsuite>")) {
                this.closePreviousReport();
            }
            return;
        }
        if (this.readingOutputReport) {
            if (string.startsWith("--------") && ((Matcher)(object = this.regexp.getOutputDelimPattern().matcher(string))).matches() && ((Matcher)object).group(1) == null) {
                this.readingOutputReport = false;
            }
            return;
        }
        if (this.trouble != null) {
            if (this.troubleParser == null) {
                this.troubleParser = new TroubleParser(this.trouble, this.regexp);
            }
            if (this.troubleParser.processMessage(string)) {
                this.troubleParser = null;
                if (this.trouble.stackTrace != null && this.trouble.stackTrace.length != 0) {
                    this.setClasspathSourceRoots();
                }
                if (this.trouble.isFakeError()) {
                    this.trouble.error = false;
                    --this.report.errors;
                    ++this.report.failures;
                }
                this.report.reportTest(this.testcase);
                this.trouble = null;
                this.testcase = null;
            }
            return;
        }
        if (string.startsWith("Testcase: ")) {
            boolean bl;
            if (this.report == null) {
                return;
            }
            object = string.substring("Testcase: ".length());
            boolean bl2 = this.lastHeaderBrief ? this.tryParseBriefHeader((String)object) || !(this.lastHeaderBrief = !this.tryParsePlainHeader((String)object)) : (bl = this.tryParsePlainHeader((String)object) || (this.lastHeaderBrief = this.tryParseBriefHeader((String)object)));
            if (bl) {
                this.waitingForIssueStatus = !this.lastHeaderBrief;
            }
        } else if (string.startsWith("--------") && this.regexp.getOutputDelimPattern().matcher(string).matches()) {
            if (this.report == null) {
                return;
            }
            this.readingOutputReport = true;
        } else if (this.expectXmlReport && string.startsWith("<?xml")) {
            object = this.regexp.getXmlDeclPattern().matcher(string.trim());
            if (((Matcher)object).matches()) {
                this.suiteStarted(null);
                this.xmlOutputBuffer = new StringBuffer(4096);
                this.xmlOutputBuffer.append(string);
            }
        } else if (string.startsWith("Testsuite: ")) {
            this.suiteName = string.substring("Testsuite: ".length());
            if (this.regexp.getFullJavaIdPattern().matcher(this.suiteName).matches()) {
                this.suiteStarted(this.suiteName);
                this.report.resultsDir = JUnitOutputReader.determineResultsDir(antEvent);
            }
        } else if (string.startsWith("Tests run: ")) {
            block38: {
                if (this.report == null) {
                    return;
                }
                if (this.testsuiteStatsKnown) {
                    return;
                }
                object = this.regexp.getSuiteStatsPattern().matcher(string);
                if (((Matcher)object).matches()) {
                    assert (this.report != null);
                    try {
                        this.report.totalTests = Integer.parseInt(((Matcher)object).group(1));
                        this.report.failures = Integer.parseInt(((Matcher)object).group(2));
                        this.report.errors = Integer.parseInt(((Matcher)object).group(3));
                        this.report.elapsedTimeMillis = this.regexp.parseTimeMillis(((Matcher)object).group(4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block38;
                        throw new AssertionError();
                    }
                }
            }
            this.testsuiteStatsKnown = true;
        } else if (this.suiteName != null && string.startsWith("Test ") && string.endsWith(" FAILED") && string.equals("Test " + this.suiteName + " FAILED")) {
            this.suiteName = null;
        } else {
            this.displayOutput(string, antEvent.getLogLevel() == 1);
        }
    }

    private static File determineResultsDir(AntEvent antEvent) {
        File file = null;
        String string = null;
        String string2 = antEvent.getTaskName();
        if (string2 != null) {
            if (string2.equals("junit")) {
                string = JUnitOutputReader.determineJunitTaskResultsDir(antEvent);
            } else if (string2.equals("java")) {
                string = JUnitOutputReader.determineJavaTaskResultsDir(antEvent);
            }
        }
        if (string != null) {
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(antEvent.getProperty("basedir"), string);
            }
            if (!file.exists() || !file.isDirectory()) {
                file = null;
            }
        } else {
            file = null;
        }
        return file;
    }

    private static String determineJunitTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2;
            String string3;
            String string4 = taskStructure2.getName();
            if (string4.equals("batchtest") || string4.equals("test")) {
                string3 = taskStructure2.getAttribute("todir");
                string = string3 != null ? antEvent.evaluate(string3) : ".";
                continue;
            }
            if (!string4.equals("formatter") || bl || (string3 = taskStructure2.getAttribute("type")) == null || !"xml".equals(antEvent.evaluate(string3)) || (string2 = taskStructure2.getAttribute("usefile")) != null && !"true".equals(antEvent.evaluate(string2))) continue;
            bl = true;
        }
        return bl ? string : null;
    }

    private static String determineJavaTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string;
            String string2;
            int n;
            String string3 = taskStructure2.getName();
            if (!string3.equals("arg")) continue;
            String string4 = taskStructure2.getAttribute("value");
            if (string4 == null) {
                string4 = taskStructure2.getAttribute("line");
            }
            if (string4 == null || !(string4 = antEvent.evaluate(string4)).startsWith("formatter=") || (n = (string2 = string4.substring("formatter=".length())).indexOf(44)) == -1 || !string2.substring(0, n).equals(XML_FORMATTER_CLASS_NAME)) continue;
            String string5 = string2.substring(n + 1);
            int n2 = string5.lastIndexOf(File.separatorChar);
            String string6 = string = n2 != -1 ? string5.substring(0, n2) : ".";
            if (string.length() == 0) continue;
            return string;
        }
        return null;
    }

    private Report createReport(String string) {
        Report report = new Report(string);
        report.antScript = this.antScript;
        report.classpath = this.classpath;
        report.platformSources = this.platformSources;
        this.classpath = null;
        this.platformSources = null;
        return report;
    }

    private ClassPath findPlatformSources(String string) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            File file;
            FileObject fileObject = javaPlatformArray[i].findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatformArray[i].getSourceFolders();
        }
        return null;
    }

    private void setClasspathSourceRoots() {
        String string;
        if (this.report == null) {
            return;
        }
        if (this.report.classpathSourceRoots != null) {
            return;
        }
        if (this.report.classpath == null) {
            return;
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.report.classpath, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            FileObject[] fileObjectArray;
            FileObject[] fileObjectArray2;
            string = stringTokenizer.nextToken();
            File file = FileUtil.normalizeFile((File)new File(string));
            try {
                fileObjectArray2 = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
            if (FileUtil.isArchiveFile((URL)fileObjectArray2) && (fileObjectArray = FileUtil.getArchiveRoot((URL)fileObjectArray2)) != null) {
                fileObjectArray2 = fileObjectArray;
            }
            fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)fileObjectArray2).getRoots();
            linkedHashSet.addAll(Arrays.asList(fileObjectArray));
        }
        if (this.report.platformSources != null) {
            linkedHashSet.addAll(Arrays.asList(this.report.platformSources.getRoots()));
        } else {
            string = JavaPlatform.getDefault();
            if (string != null) {
                linkedHashSet.addAll(Arrays.asList(string.getSourceFolders().getRoots()));
            }
        }
        this.report.classpathSourceRoots = linkedHashSet;
        this.report.classpath = null;
        this.report.platformSources = null;
    }

    void testTaskStarted(int n, boolean bl) {
        boolean bl2;
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("EXPECTED # OF SUITES: " + n);
        }
        this.expectXmlReport = bl;
        boolean bl3 = bl2 = n > 0;
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressMessage"));
            if (bl2) {
                this.expectedSuitesCount = n;
                this.progressHandle.start(32700);
                this.progressHandle.progress(327);
                this.lastProgress = 327;
            } else {
                this.progressHandle.start();
            }
        } else if (bl2) {
            if (!this.isDeterminateProgress) {
                this.progressHandle.switchToDeterminate(32700);
            }
            if (this.progressLogger.isLoggable(Level.FINER)) {
                this.progressLogger.finer("                    - total # of suites: " + (this.expectedSuitesCount + n));
            }
            this.expectedSuitesCount += n;
            this.expectedOneSuiteTests = 0;
            this.executedOneSuiteTests = 0;
            this.updateProgress();
        } else if (this.isDeterminateProgress) {
            this.progressHandle.switchToIndeterminate();
            this.lastProgress = 0;
        }
        this.isDeterminateProgress = bl2;
        Manager.getInstance().testStarted(this.session, this.sessionType);
    }

    void testTaskFinished() {
        if (this.waitingForIssueStatus) {
            assert (this.testcase != null);
            this.report.reportTest(this.testcase);
        }
        this.closePreviousReport();
        this.progressLogger.finer("ACTUAL # OF SUITES: " + this.executedSuitesCount);
        this.expectedSuitesCount = this.executedSuitesCount;
        if (this.isDeterminateProgress) {
            this.progressHandle.progress(32700);
        }
    }

    private void updateProgress() {
        this.updateProgress(null);
    }

    private void updateProgress(String string) {
        assert (this.progressHandle != null);
        int n = this.getProcessedWorkunits();
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("------ Progress: " + String.format("%3d%%", 100 * n / 32700));
        }
        if (n < 327) {
            n = 327;
        }
        if (n != this.lastProgress) {
            if (n < this.lastProgress) {
                this.progressHandle.switchToIndeterminate();
                this.progressHandle.switchToDeterminate(32700);
            }
            this.lastProgress = n;
            if (string != null) {
                this.progressHandle.progress(string, n);
            } else {
                this.progressHandle.progress(n);
            }
        } else if (string != null) {
            this.progressHandle.progress(string);
        }
    }

    private String getProgressStepMessage(String string) {
        String string2;
        if (this.isDeterminateProgress) {
            Object[] objectArray;
            MessageFormat messageFormat;
            if (string != null) {
                if (this.progressStepFormatSuiteName == null) {
                    this.progressStepFormatSuiteName = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressStepMessage"));
                }
                messageFormat = this.progressStepFormatSuiteName;
                objectArray = new Object[]{string, this.executedSuitesCount + 1, this.expectedSuitesCount};
            } else {
                if (this.progressStepFormatAnonymous == null) {
                    this.progressStepFormatAnonymous = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressStepMessageAnonymous"));
                }
                messageFormat = this.progressStepFormatAnonymous;
                objectArray = new Object[]{this.executedSuitesCount + 1, this.expectedSuitesCount};
            }
            string2 = messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
        } else {
            string2 = string != null ? string : "";
        }
        return string2;
    }

    private int getProcessedWorkunits() {
        try {
            if (this.progressLogger.isLoggable(Level.FINEST)) {
                this.progressLogger.finest("--- Suites: " + this.executedSuitesCount + " / " + this.expectedSuitesCount);
                this.progressLogger.finest("--- Tests:  " + this.executedOneSuiteTests + " / " + this.expectedOneSuiteTests);
            }
            int n = this.executedSuitesCount * 32700 / this.expectedSuitesCount;
            if (this.expectedOneSuiteTests > 0) {
                n += this.executedOneSuiteTests * 32700 / (this.expectedSuitesCount * this.expectedOneSuiteTests);
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished(AntEvent antEvent) {
        try {
            this.buildFinished(antEvent.getException());
            Manager.getInstance().sessionFinished(this.session, this.sessionType);
        }
        finally {
            this.progressHandle.finish();
        }
    }

    private Report suiteStarted(String string) {
        this.closePreviousReport();
        this.report = this.createReport(string);
        String string2 = this.getProgressStepMessage(string);
        this.expectedOneSuiteTests = 0;
        this.executedOneSuiteTests = 0;
        if (this.expectedSuitesCount <= this.executedSuitesCount) {
            this.expectedSuitesCount = this.executedSuitesCount + 1;
        }
        if (this.executedSuitesCount != 0) {
            this.updateProgress(string2);
        } else {
            this.progressHandle.progress(string2);
        }
        Manager.getInstance().displaySuiteRunning(this.session, this.sessionType, string);
        return this.report;
    }

    private void suiteFinished(Report report) {
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("actual # of tests in a suite: " + this.executedOneSuiteTests);
        }
        ++this.executedSuitesCount;
        Manager.getInstance().displayReport(this.session, this.sessionType, report);
    }

    private void buildFinished(Throwable throwable) {
    }

    private void displayOutput(String string, boolean bl) {
        Manager.getInstance().displayOutput(this.session, this.sessionType, string, bl);
    }

    private boolean tryParsePlainHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            int n = this.regexp.parseTimeMillisNoNFE(matcher.group(2));
            this.testcase = new Report.Testcase();
            this.testcase.className = null;
            this.testcase.name = string2;
            this.testcase.timeMillis = n;
            this.trouble = null;
            this.troubleParser = null;
            return true;
        }
        return false;
    }

    private boolean tryParseBriefHeader(String string) {
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            boolean bl = matcher.group(3) == null;
            this.testcase = new Report.Testcase();
            this.testcase.className = string3;
            this.testcase.name = string2;
            this.testcase.timeMillis = -1;
            this.trouble = this.testcase.trouble = new Report.Trouble(bl);
            return true;
        }
        return false;
    }

    private void closePreviousReport() {
        block13: {
            long l;
            File file;
            if (this.xmlOutputBuffer != null) {
                try {
                    String string = this.xmlOutputBuffer.toString();
                    this.xmlOutputBuffer = null;
                    Report report = XmlOutputParser.parseXmlOutput(new StringReader(string));
                    this.report.update(report);
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    assert (false);
                }
            } else if (this.report != null && this.report.resultsDir != null && (file = new File(this.report.resultsDir, "TEST-" + this.report.suiteClassName + ".xml")).exists() && this.isValidReportFile(file) && (l = file.length()) > 0L && l <= 524288L) {
                try {
                    Report report = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    this.report.update(report);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    assert (false);
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    int n = 1;
                    ErrorManager errorManager = ErrorManager.getDefault();
                    if (!errorManager.isLoggable(n)) break block13;
                    errorManager.notify(n, errorManager.annotate((Throwable)iOException, "I/O exception while reading JUnit XML report file from JUnit: "));
                }
            }
        }
        if (this.report != null) {
            this.suiteFinished(this.report);
        }
        this.xmlOutputBuffer = null;
        this.readingOutputReport = false;
        this.testcase = null;
        this.trouble = null;
        this.troubleParser = null;
        this.report = null;
        this.testsuiteStatsKnown = false;
    }

    private boolean isValidReportFile(File file) {
        Level level;
        if (!file.isFile() || !file.canRead()) {
            return false;
        }
        long l = file.lastModified();
        long l2 = l - this.timeOfSessionStart;
        Logger logger = Logger.getLogger("org.netbeans.modules.junit.outputreader.timestamps");
        if (logger.isLoggable(level = Level.FINER)) {
            logger.log(level, "Report file: " + file.getPath());
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(this.timeOfSessionStart);
            logger.log(level, "Session start:    " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
            gregorianCalendar.setTimeInMillis(l);
            logger.log(level, "Report timestamp: " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
        }
        if (l2 >= 0L) {
            return true;
        }
        return -l2 <= this.timeOfSessionStart % 1000L;
    }

    private static int parseNonNegativeInteger(String string) throws NumberFormatException {
        int n = string.length();
        if (n == 0 || n > 8) {
            throw new NumberFormatException();
        }
        char c = string.charAt(0);
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        int n2 = c - 48;
        if (n > 1) {
            for (char c2 : string.substring(1).toCharArray()) {
                if (c2 < '0' || c2 > '9') {
                    throw new NumberFormatException();
                }
                n2 = 10 * n2 + (c2 - 48);
            }
        }
        return n2;
    }
}

