/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureProjectVisualPanel
extends JPanel
implements DocumentListener,
PropertyChangeListener,
ExplorerManager.Provider {
    private ConfigureProjectPanel wizardPanel;
    private ExplorerManager explorerManager;
    private boolean configuring;
    private JTextField appNameTextField;
    private JButton browseButton;
    private JTextField createdFolderTextField;
    private HtmlBrowser descBrowser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JCheckBox mainProjectCheckBox;
    private JTextField projectLocationTextField;
    private JTextField projectNameTextField;
    private ListView shellList;
    private JLabel shellListLabel;

    public ConfigureProjectVisualPanel(ConfigureProjectPanel configureProjectPanel) {
        this.wizardPanel = configureProjectPanel;
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext(this.getTemplatesRootNode());
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.shellList.setPopupAllowed(false);
        this.shellList.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.appNameTextField.getDocument().addDocumentListener(this);
    }

    void setConfig(File file, String string, String string2) {
        this.configuring = true;
        this.projectLocationTextField.setText(file.getAbsolutePath());
        this.projectNameTextField.setText(string);
        this.projectNameTextField.setSelectionStart(0);
        this.projectNameTextField.setSelectionEnd(string.length());
        if (string2 != null) {
            this.appNameTextField.setText(string2);
        }
        if (this.explorerManager.getSelectedNodes().length == 0) {
            Node[] nodeArray = this.explorerManager.getRootContext().getChildren().getNodes(true);
            try {
                this.explorerManager.setSelectedNodes(new Node[]{nodeArray[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.configuring = false;
        this.wizardPanel.visualPanelChanged(false);
    }

    File getProjectDirectory() {
        return new File(this.createdFolderTextField.getText());
    }

    String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    String getApplicationClassName() {
        return this.appNameTextField.getText();
    }

    FileObject getSelectedTemplate() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray.length == 1) {
            return ConfigureProjectVisualPanel.fileFromNode(nodeArray[0]);
        }
        return null;
    }

    boolean isSetMainProject() {
        return this.mainProjectCheckBox.isSelected();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
            FileObject fileObject;
            if (!this.configuring) {
                this.wizardPanel.visualPanelChanged(true);
            }
            URL uRL = (fileObject = this.getSelectedTemplate()) != null ? (URL)fileObject.getAttribute("instantiatingWizardURL") : null;
            this.descBrowser.setURL(uRL);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void updateTexts(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.projectNameTextField.getDocument() || documentEvent.getDocument() == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
            if (documentEvent.getDocument() == this.projectNameTextField.getDocument()) {
                String string3 = ConfigureProjectVisualPanel.getClassNameFromProject(string);
                String string4 = string3.toLowerCase();
                String string5 = !string4.contains("application") && !string3.endsWith("App") ? string3 + "App" : string3;
                if (Character.isLowerCase(string5.charAt(0))) {
                    string5 = string5.substring(0, 1).toUpperCase() + string5.substring(1);
                }
                this.appNameTextField.setText(string4 + "." + string5);
                return;
            }
        }
        if (!this.configuring) {
            this.wizardPanel.visualPanelChanged(false);
        }
    }

    private static String getClassNameFromProject(String string) {
        if (!Utilities.isJavaIdentifier((String)string)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (stringBuilder.length() == 0) {
                    if (!Character.isJavaIdentifierStart(c)) continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) continue;
                stringBuilder.append(c);
            }
            return stringBuilder.length() > 0 ? stringBuilder.toString() : "MyApplication";
        }
        return string;
    }

    private Node getTemplatesRootNode() {
        try {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-swingapp/appshells");
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getNodeDelegate();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return new AbstractNode((Children)new Children.Array());
        }
    }

    private static FileObject fileFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel3 = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.mainProjectCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.appNameTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.shellListLabel = new JLabel();
        this.shellList = new TemplatesListView();
        this.descBrowser = new HtmlBrowser();
        this.setName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name"));
        this.jLabel1.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureProjectVisualPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel3.text"));
        this.createdFolderTextField.setEditable(false);
        this.mainProjectCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProjectCheckBox, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.text"));
        this.mainProjectCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainProjectCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel4.setLabelFor(this.appNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel4.text"));
        this.shellListLabel.setLabelFor((Component)this.shellList);
        Mnemonics.setLocalizedText((JLabel)this.shellListLabel, (String)NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.text"));
        this.shellListLabel.setToolTipText(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.shellListLabel.toolTipText"));
        this.shellList.setTraversalAllowed(false);
        this.descBrowser.setStatusLineVisible(false);
        this.descBrowser.setToolbarVisible(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.mainProjectCheckBox).addContainerGap(348, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.appNameTextField, -1, 284, Short.MAX_VALUE).add((Component)this.createdFolderTextField, -1, 284, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 284, Short.MAX_VALUE).add((Component)this.projectNameTextField, -1, 284, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton)).add((Component)this.jSeparator1, -1, 457, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.shellListLabel).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.shellList, -2, 187, -2).addPreferredGap(0).add((Component)this.descBrowser, -1, 264, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.createdFolderTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.mainProjectCheckBox).add(10, 10, 10).add((Component)this.jSeparator1, -2, -1, -2).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.appNameTextField, -2, -1, -2)).add(20, 20, 20).add((Component)this.shellListLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.descBrowser, -1, 88, Short.MAX_VALUE).add((Component)this.shellList, -1, 88, Short.MAX_VALUE))));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel1.accessibleDescription"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel2.accessibleDescription"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jButton1.accessibleDescription"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel3.accessibleDescription"));
        this.mainProjectCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.mainProjectCheckBox.accessibleDescription"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.jLabel4.accessibleDescription"));
        this.descBrowser.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.descBrowser.accessibleName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"TITLE_NewDesktopApp"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.locationChooserTitle"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
        this.wizardPanel.visualPanelChanged(false);
    }

    private static class TemplatesListView
    extends ListView
    implements ActionListener {
        public TemplatesListView() {
            this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this.setDefaultProcessor(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

