/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.actiontable;

import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.swingapp.ProxyAction;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{ActionTableModel.getLocalizedString("header.name"), ActionTableModel.getLocalizedString("header.text"), ActionTableModel.getLocalizedString("header.accelerator"), ActionTableModel.getLocalizedString("header.class"), ActionTableModel.getLocalizedString("header.method"), ActionTableModel.getLocalizedString("header.icon"), ActionTableModel.getLocalizedString("header.task")};
    final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class, String.class, Icon.class, Boolean.class};
    private List<ProxyAction> actions;
    public static int ICON_COLUMN = 5;
    public static int TASK_COLUMN = 6;
    public static int METHOD_COLUMN = 4;

    private static String getLocalizedString(String string) {
        return NbBundle.getMessage(ActionTableModel.class, (String)("ActionTableModel." + string));
    }

    public ActionTableModel(List<ProxyAction> list) {
        this.actions = list;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.columnClasses[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnClasses.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.actions.size();
    }

    public ProxyAction getAction(int n) {
        return this.actions.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ProxyAction proxyAction = this.actions.get(n);
        if (n2 == 0) {
            return proxyAction.getId();
        }
        if (n2 == 1) {
            return proxyAction.getValue("Name");
        }
        if (n2 == 2) {
            StringBuffer stringBuffer = new StringBuffer();
            KeyStroke keyStroke = (KeyStroke)proxyAction.getValue("AcceleratorKey");
            if (keyStroke == null) {
                return null;
            }
            if ((keyStroke.getModifiers() & 0x100) > 0) {
                stringBuffer.append("Meta-");
            }
            if ((keyStroke.getModifiers() & 0x200) > 0) {
                stringBuffer.append("Alt-");
            }
            if ((keyStroke.getModifiers() & 0x80) > 0) {
                stringBuffer.append("Ctrl-");
            }
            if ((keyStroke.getModifiers() & 0x40) > 0) {
                stringBuffer.append("Shift-");
            }
            stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
            return stringBuffer.toString();
        }
        if (n2 == 3) {
            return proxyAction.getClassname();
        }
        if (n2 == METHOD_COLUMN) {
            return proxyAction.getMethodName() + "()";
        }
        if (n2 == ICON_COLUMN) {
            int n3 = 0;
            if (proxyAction.getValue("SmallIcon") != null) {
                ++n3;
            }
            return (Icon)proxyAction.getValue("SmallIcon");
        }
        if (n2 == TASK_COLUMN) {
            return proxyAction.isTaskEnabled();
        }
        if (n2 == 7) {
            return "--";
        }
        return "asdf";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public void updateAction(ProxyAction proxyAction) {
        for (int i = 0; i < this.actions.size(); ++i) {
            ProxyAction proxyAction2 = this.actions.get(i);
            if (proxyAction2 != proxyAction) continue;
            this.fireTableRowsUpdated(i, i);
            break;
        }
    }
}

