/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

class ResourceUtils {
    private static Map<FileObject, DesignResourceMap> resources;
    static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";
    static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    static final String CODE_MARK_END = "*/\n\\0";

    private ResourceUtils() {
    }

    static DesignResourceMap createDesignResourceMap(FileObject fileObject, ClassLoader classLoader) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        if (classLoader == null) {
            classLoader = classPath.getClassLoader(true);
        }
        DesignResourceMap designResourceMap = null;
        String string = AppFrameworkSupport.getApplicationClassName(fileObject);
        String string2 = ResourceUtils.getBundleName(string);
        if (string2 != null) {
            designResourceMap = new DesignResourceMap(ResourceUtils.getAppDefaultResourceMap(fileObject, string), classLoader, fileObject, new String[]{string2}, 0);
        }
        String string3 = classPath.getResourceName(fileObject, '.', false);
        string2 = ResourceUtils.getBundleName(string3);
        designResourceMap = new DesignResourceMap((ResourceMap)designResourceMap, classLoader, fileObject, new String[]{string2}, 2);
        if (resources == null) {
            resources = new HashMap<FileObject, DesignResourceMap>();
        }
        resources.put(fileObject, designResourceMap);
        return designResourceMap;
    }

    static DesignResourceMap getDesignResourceMap(FileObject fileObject, boolean bl) {
        DesignResourceMap designResourceMap;
        DesignResourceMap designResourceMap2 = designResourceMap = resources != null ? resources.get(fileObject) : null;
        if (designResourceMap == null && bl) {
            designResourceMap = ResourceUtils.createDesignResourceMap(fileObject, null);
        }
        return designResourceMap;
    }

    private static ResourceMap getAppDefaultResourceMap(FileObject fileObject, String string) {
        FileObject fileObject2 = AppFrameworkSupport.getFileForClass(fileObject, string);
        string = Application.class.getName();
        String[] stringArray = new String[]{ResourceUtils.getBundleName(string)};
        return new ResourceMap(null, ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute").getClassLoader(true), stringArray);
    }

    static DesignResourceMap getAppDesignResourceMap(Project project) {
        String string = AppFrameworkSupport.getApplicationClassName(project);
        if (string != null) {
            String string2 = ResourceUtils.getBundleName(string);
            ClassPath classPath = AppFrameworkSupport.getSourcePath(project);
            FileObject fileObject = classPath.findResource(string.replace('.', '/') + ".java");
            return new DesignResourceMap(null, classPath.getClassLoader(true), fileObject, new String[]{string2}, 0);
        }
        return null;
    }

    static DesignResourceMap unregisterDesignResourceMap(FileObject fileObject) {
        return resources != null ? resources.remove(fileObject) : null;
    }

    static String getResourceMapCode(FileObject fileObject) {
        return CODE_MARK_VARIABLE_SUBST + AppFrameworkSupport.getApplicationCode(fileObject) + ".getContext().getResourceMap(" + fileObject.getName() + ".class)" + CODE_MARK_VARIABLE_SUBST + ResourceMap.class.getName() + CODE_MARK_VARIABLE_SUBST + "resourceMap";
    }

    private static String getBundleName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n > 0 ? string.substring(0, n) + ".resources" + string.substring(n) : "resources." + string;
    }

    private static FileObject getResourceFile(FileObject fileObject, String string, boolean bl) {
        FileObject fileObject2;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null && (fileObject2 = classPath.findResource(string)) != null) {
            return fileObject2;
        }
        if (bl) {
            fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            for (ClassPath.Entry entry : fileObject2.entries()) {
                SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
                FileObject[] fileObjectArray = result.getRoots();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject3;
                    ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObjectArray[i], (String)"classpath/source");
                    if (classPath2 == null || (fileObject3 = classPath2.findResource(string)) == null) continue;
                    return fileObject3;
                }
            }
        }
        return null;
    }

    static PropertiesDataObject getPropertiesDataObject(FileObject fileObject, String string, boolean bl) {
        FileObject fileObject2;
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        } else if (string.contains(".")) {
            string = string.replace('.', '/');
        }
        if (!string.toLowerCase().endsWith(".properties")) {
            string = string + ".properties";
        }
        if ((fileObject2 = ResourceUtils.getResourceFile(fileObject, string, bl)) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject2);
                if (dataObject instanceof PropertiesDataObject) {
                    return (PropertiesDataObject)dataObject;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    static PropertiesDataObject getPropertiesDataObject(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '.', false);
        String string2 = ResourceUtils.getBundleName(string);
        return ResourceUtils.getPropertiesDataObject(fileObject, string2, false);
    }

    static BundleStructure getBundleStructure(FileObject fileObject, String string) {
        PropertiesDataObject propertiesDataObject = ResourceUtils.getPropertiesDataObject(fileObject, string, false);
        return propertiesDataObject != null ? propertiesDataObject.getBundleStructure() : null;
    }

    static FileObject createResourcesFolder(FileObject fileObject) throws IOException {
        return FileUtil.createFolder((FileObject)fileObject.getParent(), (String)"resources");
    }

    static PropertiesDataObject createPropertiesDataObject(FileObject fileObject, String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (string.toLowerCase().endsWith(".properties")) {
            string = string.substring(0, string.length() - ".properties".length());
        }
        if (string.contains(".")) {
            string = string.replace('.', '/');
        }
        FileObject fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getRoots()[0];
        return Util.createPropertiesDataObject((FileObject)fileObject2, (String)string);
    }

    static String getValueAsString(Object object) {
        if (object == null) {
            return "${null}";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return "" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }
        if (object instanceof Font) {
            Font font = (Font)object;
            String string = font.isBold() ? (font.isItalic() ? "BoldItalic" : "Bold") : (font.isItalic() ? "Italic" : "Plain");
            return font.getName() + "-" + string + "-" + font.getSize();
        }
        return null;
    }
}

