/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.form.RefactoringInfo;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RefactoringPluginFactoryImpl
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        if (abstractRefactoring instanceof RenameRefactoring || abstractRefactoring instanceof MoveRefactoring || abstractRefactoring instanceof SingleCopyRefactoring) {
            Lookup lookup = abstractRefactoring.getRefactoringSource();
            FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
            NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
            if (fileObject != null && RefactoringPluginFactoryImpl.isJavaFile(fileObject) || nonRecursiveFolder != null) {
                return new RefactoringPluginImpl(abstractRefactoring);
            }
        }
        return null;
    }

    private static boolean isJavaFile(FileObject fileObject) {
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fileObject) {
        return RefactoringPluginFactoryImpl.isJavaFile(fileObject) && fileObject.existsExt("form");
    }

    private static class ResourcePackageUpdate
    extends SimpleRefactoringElementImplementation {
        private RenameRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private String oldPkgName;
        private DataFolder resFolder;

        ResourcePackageUpdate(RenameRefactoring renameRefactoring, RefactoringElementImplementation refactoringElementImplementation, FileObject fileObject) {
            this.refactoring = renameRefactoring;
            this.refElement = refactoringElementImplementation;
            this.resFolder = DataFolder.findFolder((FileObject)fileObject);
            this.oldPkgName = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject.getParent(), '.', false);
        }

        public void performChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)classPath.findResource(this.refactoring.getNewName().replace('.', '/')));
            FileObject fileObject = this.resFolder.getPrimaryFile().getParent();
            try {
                this.resFolder.move(dataFolder);
                if (fileObject != null && fileObject.isValid() && fileObject.getChildren().length == 0) {
                    fileObject.delete();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public void undoChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath classPath = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            FileObject fileObject = classPath.findOwnerRoot(this.resFolder.getPrimaryFile());
            try {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)fileObject, (String)this.oldPkgName.replace('.', '/')));
                this.resFolder.move(dataFolder);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourcesPackageRef2");
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.resFolder.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class ResourceMapUpdate
    extends SimpleRefactoringElementImplementation {
        private AbstractRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private DataObject propertiesDO;
        private String oldName;
        private FileObject oldFolder;
        private FileObject srcFileBefore;
        private FileObject srcFileAfter;

        ResourceMapUpdate(AbstractRefactoring abstractRefactoring, RefactoringElementImplementation refactoringElementImplementation, DataObject dataObject) {
            this.refactoring = abstractRefactoring;
            this.refElement = refactoringElementImplementation;
            this.propertiesDO = dataObject;
            this.oldName = dataObject.getName();
            this.oldFolder = dataObject.getFolder().getPrimaryFile();
            this.srcFileBefore = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        }

        public void performChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                this.srcFileAfter = this.srcFileBefore;
                String string = ((RenameRefactoring)this.refactoring).getNewName();
                try {
                    this.propertiesDO.rename(string);
                    ResourceUtils.unregisterDesignResourceMap(this.srcFileBefore);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                URL uRL = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                FileObject fileObject = null;
                try {
                    File file = FileUtil.normalizeFile((File)new File(uRL.toURI()));
                    fileObject = FileUtil.toFileObject((File)file);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
                if (fileObject != null && fileObject.isFolder()) {
                    this.srcFileAfter = fileObject.getFileObject(this.oldName);
                    try {
                        fileObject = FileUtil.createFolder((FileObject)fileObject, (String)"resources");
                        this.propertiesDO.move(DataFolder.findFolder((FileObject)fileObject));
                        ResourceUtils.unregisterDesignResourceMap(this.srcFileBefore);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }

        public void undoChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                try {
                    this.propertiesDO.rename(this.oldName);
                    ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                try {
                    this.propertiesDO.move(DataFolder.findFolder((FileObject)this.oldFolder));
                    ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                this.srcFileBefore = this.oldFolder.getParent().getFileObject(this.oldName);
            }
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourceMapRef", (Object)this.propertiesDO.getPrimaryFile().getNameExt());
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.propertiesDO.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;
        private String displayText;

        PreviewElement(FileObject fileObject, String string) {
            this.file = fileObject;
            this.displayText = string;
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class RefactoringPluginImpl
    implements RefactoringPlugin {
        private AbstractRefactoring refactoring;

        RefactoringPluginImpl(AbstractRefactoring abstractRefactoring) {
            this.refactoring = abstractRefactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
            FileObject fileObject;
            FileObject fileObject2;
            Lookup lookup = this.refactoring.getRefactoringSource();
            FileObject fileObject3 = (FileObject)lookup.lookup(FileObject.class);
            NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
            if (fileObject3 != null && nonRecursiveFolder == null && !fileObject3.isFolder()) {
                PropertiesDataObject propertiesDataObject;
                if (AppFrameworkSupport.isFrameworkEnabledProject(fileObject3) && (propertiesDataObject = ResourceUtils.getPropertiesDataObject(fileObject3)) != null) {
                    File file;
                    Object object;
                    PreviewElement previewElement = null;
                    if (this.refactoring instanceof RenameRefactoring) {
                        object = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_RenameFileRef", (Object)propertiesDataObject.getPrimaryFile().getNameExt());
                        previewElement = new PreviewElement(fileObject3, (String)object);
                    } else if (this.refactoring instanceof MoveRefactoring) {
                        object = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                        try {
                            file = FileUtil.normalizeFile((File)new File(((URL)object).toURI()));
                            if (file.isDirectory()) {
                                String string = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_MoveFileRef", (Object)propertiesDataObject.getPrimaryFile().getNameExt());
                                previewElement = new PreviewElement(fileObject3, string);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Exceptions.printStackTrace((Throwable)uRISyntaxException);
                        }
                    } else if (this.refactoring instanceof SingleCopyRefactoring) {
                        // empty if block
                    }
                    if (previewElement != null) {
                        refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                        object = new ResourceMapUpdate(this.refactoring, (RefactoringElementImplementation)previewElement, (DataObject)propertiesDataObject);
                        file = (RefactoringInfo)this.refactoring.getContext().lookup(RefactoringInfo.class);
                        if (file != null && file.isForm()) {
                            assert (RefactoringPluginFactoryImpl.isJavaFileOfForm(fileObject3) && fileObject3.equals(file.getPrimaryFile()));
                            file.getUpdateForFile(fileObject3).addPrecedingFileChange((RefactoringElementImplementation)object);
                        } else {
                            refactoringElementsBag.addFileChange(this.refactoring, (RefactoringElementImplementation)object);
                        }
                    }
                }
            } else if (nonRecursiveFolder != null && this.refactoring instanceof RenameRefactoring && AppFrameworkSupport.isFrameworkEnabledProject(fileObject2 = nonRecursiveFolder.getFolder()) && (fileObject = fileObject2.getFileObject("resources")) != null) {
                PreviewElement previewElement = new PreviewElement(fileObject, NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourcesPackageRef1"));
                refactoringElementsBag.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                ResourcePackageUpdate resourcePackageUpdate = new ResourcePackageUpdate((RenameRefactoring)this.refactoring, (RefactoringElementImplementation)previewElement, fileObject);
                FormRefactoringUpdate formRefactoringUpdate = null;
                RefactoringInfo refactoringInfo = (RefactoringInfo)this.refactoring.getContext().lookup(RefactoringInfo.class);
                if (refactoringInfo != null) {
                    for (FileObject fileObject4 : fileObject2.getChildren()) {
                        if (!RefactoringPluginFactoryImpl.isJavaFileOfForm(fileObject4)) continue;
                        formRefactoringUpdate = refactoringInfo.getUpdateForFile(fileObject4);
                        break;
                    }
                }
                if (formRefactoringUpdate != null) {
                    formRefactoringUpdate.addPrecedingFileChange((RefactoringElementImplementation)resourcePackageUpdate);
                } else {
                    refactoringElementsBag.addFileChange(this.refactoring, (RefactoringElementImplementation)resourcePackageUpdate);
                }
            }
            return null;
        }
    }
}

