/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import org.jdesktop.application.ResourceMap;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProjectCustomizerPanel;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProjectCustomizerProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_NAME = "AppFramework";
    private static final String KEY_VENDOR_ID = "Application.vendorId";
    private static final String KEY_APP_ID = "Application.id";
    private static final String KEY_LOOK_AND_FEEL = "Application.lookAndFeel";
    private static final String[][] APP_PROPERTIES = new String[][]{{"application.title", "Application.title"}, {"application.vendor", "Application.vendor"}, {"application.desc", "Application.description"}, {"application.homepage", "Application.homepage"}};

    private ProjectCustomizerProvider() {
    }

    public static ProjectCustomizerProvider create() {
        return new ProjectCustomizerProvider();
    }

    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        ProjectCustomizer.Category category;
        Project project = (Project)lookup.lookup(Project.class);
        if (AppFrameworkSupport.isApplicationProject(project)) {
            category = ProjectCustomizer.Category.create((String)CAT_NAME, (String)NbBundle.getMessage(ProjectCustomizerProvider.class, (String)"CTL_ProjectCustomizerCategoryTitle"), null, (ProjectCustomizer.Category[])null);
            category.setOkButtonListener((ActionListener)new SaveListener(project));
        } else {
            category = null;
        }
        return category;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        Object object;
        ProjectCustomizerPanel projectCustomizerPanel = new ProjectCustomizerPanel();
        ((SaveListener)category.getOkButtonListener()).panel = projectCustomizerPanel;
        Project project = (Project)lookup.lookup(Project.class);
        if (ProjectCustomizerPanel.fileChooserDir == null) {
            object = FileUtil.toFile((FileObject)project.getProjectDirectory());
            ProjectCustomizerPanel.fileChooserDir = ((File)object).getPath();
        }
        object = ResourceUtils.getAppDesignResourceMap(project);
        projectCustomizerPanel.setVendorId(((ResourceMap)object).getString(KEY_VENDOR_ID, new Object[0]));
        projectCustomizerPanel.setApplicationId(((ResourceMap)object).getString(KEY_APP_ID, new Object[0]));
        projectCustomizerPanel.setLookAndFeel(((ResourceMap)object).getString(KEY_LOOK_AND_FEEL, new Object[0]));
        return projectCustomizerPanel;
    }

    private static class SaveListener
    implements ActionListener,
    Runnable {
        private Project project;
        private ProjectCustomizerPanel panel;

        SaveListener(Project project) {
            this.project = project;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        public void run() {
            PropertyEvaluator propertyEvaluator;
            DesignResourceMap designResourceMap = ResourceUtils.getAppDesignResourceMap(this.project);
            J2SEPropertyEvaluator j2SEPropertyEvaluator = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            if (j2SEPropertyEvaluator != null) {
                propertyEvaluator = j2SEPropertyEvaluator.evaluator();
                for (String[] stringArray : APP_PROPERTIES) {
                    String string = propertyEvaluator.getProperty(stringArray[0]);
                    SaveListener.storeValue(stringArray[1], string, designResourceMap);
                }
            }
            if (this.panel != null) {
                SaveListener.storeValue(ProjectCustomizerProvider.KEY_VENDOR_ID, this.panel.getVendorId(), designResourceMap);
                SaveListener.storeValue(ProjectCustomizerProvider.KEY_APP_ID, this.panel.getApplicationId(), designResourceMap);
                SaveListener.storeValue(ProjectCustomizerProvider.KEY_LOOK_AND_FEEL, this.panel.getLookAndFeel(), designResourceMap);
                designResourceMap.save();
                propertyEvaluator = this.panel.getLookAndFeelJAR();
                if (propertyEvaluator != null) {
                    try {
                        ProjectClassPathModifier.addRoots((URL[])new URL[]{propertyEvaluator.getURL()}, (FileObject)designResourceMap.getSourceFile(), (String)"classpath/execute");
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            designResourceMap.save();
        }

        private static void storeValue(String string, String string2, DesignResourceMap designResourceMap) {
            ResourceValueImpl resourceValueImpl = designResourceMap.getResourceValue(string, String.class);
            if (resourceValueImpl != null) {
                if (string2 != null) {
                    resourceValueImpl.setValue(string2);
                    resourceValueImpl.setStringValue(string2);
                    designResourceMap.addResourceValue(resourceValueImpl);
                } else {
                    designResourceMap.removeResourceValue(resourceValueImpl);
                }
            } else if (string2 != null) {
                resourceValueImpl = new ResourceValueImpl(string, String.class, string2, null, string2, false, 0, null);
                designResourceMap.addResourceValue(resourceValueImpl);
            }
        }
    }
}

