/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String[] LAF_RESOURCE_NAMES = new String[]{"default", "system"};
    private static final String[] LAF_DISPLAY_NAMES = new String[]{NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"LAF_Default"), NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"LAF_System")};
    private FileObject lafJarRoot;
    static String fileChooserDir;
    private JTextField appIdTextField;
    private JButton browseButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox lafCombo;
    private JTextField vendorIdTextField;

    public ProjectCustomizerPanel() {
        this.initComponents();
        this.lafCombo.setModel(new DefaultComboBoxModel<String>(LAF_DISPLAY_NAMES));
    }

    void setVendorId(String string) {
        this.vendorIdTextField.setText(string);
    }

    String getVendorId() {
        return this.vendorIdTextField.getText();
    }

    void setApplicationId(String string) {
        this.appIdTextField.setText(string);
    }

    String getApplicationId() {
        return this.appIdTextField.getText();
    }

    void setLookAndFeel(String string) {
        for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
            if (!LAF_RESOURCE_NAMES[i].equalsIgnoreCase(string)) continue;
            this.lafCombo.setSelectedItem(LAF_DISPLAY_NAMES[i]);
            return;
        }
        this.lafCombo.setSelectedItem(string);
    }

    String getLookAndFeel() {
        String string = ((String)this.lafCombo.getEditor().getItem()).trim();
        for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
            if (!LAF_DISPLAY_NAMES[i].equalsIgnoreCase(string)) continue;
            return LAF_RESOURCE_NAMES[i];
        }
        return string;
    }

    FileObject getLookAndFeelJAR() {
        if (this.lafJarRoot != null) {
            String string = ((String)this.lafCombo.getEditor().getItem()).trim();
            for (int i = 0; i < LAF_RESOURCE_NAMES.length; ++i) {
                if (!LAF_DISPLAY_NAMES[i].equalsIgnoreCase(string) && !LAF_RESOURCE_NAMES[i].equalsIgnoreCase(string)) continue;
                return null;
            }
        }
        return this.lafJarRoot;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.vendorIdTextField = new JTextField();
        this.appIdTextField = new JTextField();
        this.lafCombo = new JComboBox();
        this.browseButton = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"jLabel4.text"));
        this.vendorIdTextField.setToolTipText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"vendorIdTextField.toolTipText"));
        this.appIdTextField.setToolTipText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"vendorIdTextField.toolTipText"));
        this.lafCombo.setEditable(true);
        this.browseButton.setText(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectCustomizerPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.vendorIdTextField, -1, 304, Short.MAX_VALUE).add((Component)this.appIdTextField, -1, 304, Short.MAX_VALUE).add(2, (Component)this.lafCombo, 0, 304, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.vendorIdTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.appIdTextField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.lafCombo, -2, -1, -2).add((Component)this.browseButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(fileChooserDir);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"CTL_SelectJAR_Caption"));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setControlButtonsAreShown(true);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar");
            }

            public String getDescription() {
                return NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"CTL_JarArchivesMask");
            }
        });
        if (jFileChooser.showOpenDialog(this.getTopLevelAncestor()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
                FileObject fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject);
                LinkedList<String> linkedList = new LinkedList<String>();
                try {
                    ProjectCustomizerPanel.scanFolderForLaF(fileObject2, linkedList, ClassPathSupport.createClassPath((URL[])new URL[]{fileObject2.getURL()}));
                }
                catch (IOException iOException) {
                    Logger.getLogger(ProjectCustomizerPanel.class.getClass().getName()).log(Level.SEVERE, "JAR file scanning failed", iOException);
                }
                if (!linkedList.isEmpty()) {
                    for (int i = LAF_DISPLAY_NAMES.length - 1; i >= 0; --i) {
                        linkedList.add(0, LAF_DISPLAY_NAMES[i]);
                    }
                    this.lafCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
                    this.lafCombo.setSelectedIndex(LAF_DISPLAY_NAMES.length);
                    this.lafJarRoot = fileObject2;
                } else {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectCustomizerPanel.class, (String)"MSG_NoLafFound"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
            fileChooserDir = file.getParent();
        }
    }

    private static void scanFolderForLaF(FileObject fileObject, List<String> list, ClassPath classPath) throws IOException {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string;
            if (fileObject2.isFolder()) {
                ProjectCustomizerPanel.scanFolderForLaF(fileObject2, list, classPath);
                continue;
            }
            if (!"class".equals(fileObject2.getExt()) || DataObject.find((FileObject)fileObject2) == null || (string = ProjectCustomizerPanel.scanClassFile(fileObject2, list, classPath)) == null) continue;
            list.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String scanClassFile(FileObject fileObject, List<String> list, ClassPath classPath) throws IOException {
        int n;
        ClassFile classFile;
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            classFile = new ClassFile(inputStream, false);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (!(classFile == null || !Modifier.isPublic(n = classFile.getAccess()) || Modifier.isAbstract(n) || Modifier.isInterface(n) || classFile.isAnnotation() || classFile.isEnum() || classFile.isSynthetic() || classFile.getSuperClass() == null)) {
            String string = classFile.getSuperClass().getExternalName();
            FileObject fileObject2 = classPath.findResource(string.replace('.', '/') + ".class");
            if (ProjectCustomizerPanel.isStandardLAFSuperClass(string) || fileObject2 != null && ProjectCustomizerPanel.scanClassFile(fileObject2, list, classPath) != null) {
                return classFile.getName().getExternalName();
            }
        }
        return null;
    }

    private static boolean isStandardLAFSuperClass(String string) {
        return string.startsWith("javax.swing") && ("javax.swing.LookAndFeel".equals(string) || "javax.swing.plaf.metal.MetalLookAndFeel".equals(string) || "javax.swing.plaf.basic.BasicLookAndFeel".equals(string) || "javax.swing.plaf.synth.SynthLookAndFeel".equals(string));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.swingapp.ProjectCustomizerPanel");
    }
}

