/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jdesktop.application.Application;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AppFrameworkSupport {
    private static final String APPLICATION_RESOURCE_NAME = "org/jdesktop/application/Application.class";
    private static final String SWINGAPP_ELEMENT = "swingapp";
    private static final String SWINGAPP_NS = "http://www.netbeans.org/ns/form-swingapp/1";
    private static final String APP_CLASS_ELEMENT = "application-class";
    private static final String APP_CLASS_NAME_ATTR = "name";
    private static Map<FileObject, String> appClassMap = new HashMap<FileObject, String>();

    AppFrameworkSupport() {
    }

    static boolean isFrameworkEnabledProject(FileObject fileObject) {
        return AppFrameworkSupport.isFrameworkLibAvailable(fileObject) && AppFrameworkSupport.getApplicationClassName(fileObject) != null;
    }

    static boolean isFrameworkLibAvailable(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        return classPath != null && classPath.findResource(APPLICATION_RESOURCE_NAME) != null && AppFrameworkSupport.projectCanUseFramework(fileObject);
    }

    static boolean isApplicationProject(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        return auxiliaryConfiguration.getConfigurationFragment(SWINGAPP_ELEMENT, SWINGAPP_NS, true) != null;
    }

    static boolean projectCanUseFramework(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return project == null || !project.getClass().getName().startsWith("org.netbeans.modules.apisupport.") || !project.getClass().getName().endsWith("Project");
    }

    static String getApplicationCode(FileObject fileObject) {
        String string = AppFrameworkSupport.getApplicationClassName(fileObject);
        return string != null ? Application.class.getName() + ".getInstance(" + string + ".class)" : Application.class.getName() + ".getInstance()";
    }

    static String getActionMapCode(FileObject fileObject) {
        return AppFrameworkSupport.getApplicationCode(fileObject) + ".getContext().getActionMap(" + fileObject.getName() + ".class, this)";
    }

    static String getApplicationClassName(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
            return AppFrameworkSupport.getApplicationClassName(fileObject, project, auxiliaryConfiguration);
        }
        return null;
    }

    static String getApplicationClassName(Project project) {
        FileObject fileObject = AppFrameworkSupport.getSourceRoot(project);
        if (fileObject != null) {
            AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
            return AppFrameworkSupport.getApplicationClassName(fileObject, project, auxiliaryConfiguration);
        }
        return null;
    }

    private static String getApplicationClassName(FileObject fileObject, Project project, AuxiliaryConfiguration auxiliaryConfiguration) {
        Object object;
        Object object2;
        String string = null;
        Element element = auxiliaryConfiguration.getConfigurationFragment(SWINGAPP_ELEMENT, SWINGAPP_NS, true);
        boolean bl = element != null;
        boolean bl2 = false;
        if (bl) {
            object2 = null;
            object = element.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals(APP_CLASS_ELEMENT)) continue;
                object2 = (Element)node;
                break;
            }
            if (object2 != null) {
                string = object2.getAttribute(APP_CLASS_NAME_ATTR);
            }
        }
        if (string == null) {
            if (appClassMap.containsKey(fileObject)) {
                string = appClassMap.get(fileObject);
            } else {
                string = AppFrameworkSupport.findApplicationClass(fileObject);
                bl2 = true;
            }
        }
        if (string != null && !bl2 && (object2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")).findResource(string.replace('.', '/') + ".java") == null) {
            string = AppFrameworkSupport.findApplicationClass(fileObject);
            bl2 = true;
        }
        if (bl2) {
            if (bl) {
                object2 = XMLUtil.createDocument((String)SWINGAPP_ELEMENT, (String)SWINGAPP_NS, null, null);
                element = object2.createElementNS(SWINGAPP_NS, SWINGAPP_ELEMENT);
                if (string != null) {
                    object = object2.createElement(APP_CLASS_ELEMENT);
                    object.setAttribute(APP_CLASS_NAME_ATTR, string);
                    element.appendChild((Node)object);
                }
                auxiliaryConfiguration.putConfigurationFragment(element, true);
                try {
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (!(fileObject.isFolder() || bl && string != null)) {
                appClassMap.put(fileObject, string);
            }
        }
        return string;
    }

    static boolean isViewClass(FileObject fileObject) {
        final String string = fileObject.getName();
        final boolean[] blArray = new boolean[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
                        ClassTree classTree;
                        if (tree.getKind() != Tree.Kind.CLASS || !string.equals((classTree = (ClassTree)tree).getSimpleName().toString())) continue;
                        if (!AppFrameworkSupport.isViewClass(classTree, compilationController)) break;
                        blArray[0] = true;
                        return;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return blArray[0];
    }

    static boolean isViewClass(ClassTree classTree, CompilationController compilationController) {
        Trees trees = compilationController.getTrees();
        TreePath treePath = trees.getPath(compilationController.getCompilationUnit(), classTree);
        TypeElement typeElement = (TypeElement)trees.getElement(treePath);
        TypeElement typeElement2 = compilationController.getElements().getTypeElement("org.jdesktop.application.View");
        Types types = compilationController.getTypes();
        TypeMirror typeMirror = types.erasure(typeElement.asType());
        TypeMirror typeMirror2 = types.erasure(typeElement2.asType());
        return types.isSubtype(typeMirror, typeMirror2);
    }

    static String getClassNameForFile(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        return classPath != null ? classPath.getResourceName(fileObject, '.', false) : null;
    }

    static FileObject getFileForClass(FileObject fileObject, String string) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        return classPath.findResource(string.replace('.', '/') + ".java");
    }

    static ClassPath getSourcePath(Project project) {
        FileObject fileObject = AppFrameworkSupport.getSourceRoot(project);
        return fileObject != null ? ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source") : null;
    }

    private static FileObject getSourceRoot(Project project) {
        int n = 0;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        int n2 = sourceGroupArray.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray[n];
            return sourceGroup.getRootFolder();
        }
        return null;
    }

    static void fileClosed(FileObject fileObject) {
        appClassMap.remove(fileObject);
    }

    private static String findApplicationClass(FileObject fileObject) {
        if (AppFrameworkSupport.isFrameworkLibAvailable(fileObject)) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            return AppFrameworkSupport.scanFolderForApplication(classPath.findOwnerRoot(fileObject));
        }
        return null;
    }

    private static String scanFolderForApplication(FileObject fileObject) {
        LinkedList<FileObject> linkedList = null;
        for (FileObject fileObject2 : fileObject.getChildren()) {
            String string;
            if (fileObject2.isFolder()) {
                if (linkedList == null) {
                    linkedList = new LinkedList<FileObject>();
                }
                linkedList.add(fileObject2);
                continue;
            }
            if (!fileObject2.getExt().equalsIgnoreCase("java") || (string = AppFrameworkSupport.getAppClassNameFromFile(fileObject2)) == null) continue;
            return string;
        }
        if (linkedList != null) {
            for (FileObject fileObject3 : linkedList) {
                String string = AppFrameworkSupport.scanFolderForApplication(fileObject3);
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    private static String getAppClassNameFromFile(FileObject fileObject) {
        final String string = fileObject.getName();
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
                        TypeMirror typeMirror;
                        TypeMirror typeMirror2;
                        Tree tree2;
                        ClassTree classTree;
                        if (tree.getKind() != Tree.Kind.CLASS || !string.equals((classTree = (ClassTree)tree).getSimpleName().toString()) || (tree2 = classTree.getExtendsClause()) == null) continue;
                        Trees trees = compilationController.getTrees();
                        TreePath treePath = trees.getPath(compilationController.getCompilationUnit(), classTree);
                        TypeElement typeElement = (TypeElement)trees.getElement(treePath);
                        TypeElement typeElement2 = compilationController.getElements().getTypeElement("org.jdesktop.application.Application");
                        Types types = compilationController.getTypes();
                        if (!types.isSubtype(typeMirror2 = types.erasure(typeElement.asType()), typeMirror = types.erasure(typeElement2.asType())) || types.isSameType(typeMirror2, typeMirror)) break;
                        stringArray[0] = typeElement.getQualifiedName().toString();
                        return;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return stringArray[0];
    }
}

