/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoBasicNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoIconicNode;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoTextNode;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollBar;

public class JGoPalette
extends JGoView {
    public static final int OrientationVertical = 1;
    public static final int OrientationHorizontal = 0;
    private int myOrientation = -1;
    private boolean mySingleRowCol = true;
    private ArrayList mySampleItems = new ArrayList();

    public JGoPalette() {
        this.setOrientation(1);
        this.setHidingDisabledScrollbars(true);
        this.getDocument().setModifiable(false);
        this.setGridOrigin(new Point(5, 5));
    }

    public int getOrientation() {
        return this.myOrientation;
    }

    public void setOrientation(int o) {
        int old = this.myOrientation;
        if (old != o && (o == 1 || o == 0)) {
            this.myOrientation = o;
            this.firePropertyChange("orientation", old, o);
            if (this.myOrientation == 1) {
                if (this.getVerticalScrollBar() == null) {
                    JScrollBar vsbar = new JScrollBar(1);
                    vsbar.setSize(vsbar.getPreferredSize());
                    vsbar.setUnitIncrement(this.getGridHeight());
                    this.setVerticalScrollBar(vsbar);
                }
                this.setHorizontalScrollBar(null);
            } else {
                if (this.getHorizontalScrollBar() == null) {
                    JScrollBar hsbar = new JScrollBar(0);
                    hsbar.setSize(hsbar.getPreferredSize());
                    hsbar.setUnitIncrement(this.getGridWidth());
                    this.setHorizontalScrollBar(hsbar);
                }
                this.setVerticalScrollBar(null);
            }
            this.invalidate();
            this.layoutItems();
        }
    }

    public void setSingleRowCol(boolean b) {
        boolean old = this.mySingleRowCol;
        if (old != b) {
            this.mySingleRowCol = b;
            this.firePropertyChange("singleRowCol", old, b);
            this.layoutItems();
        }
    }

    public boolean getSingleRowCol() {
        return this.mySingleRowCol;
    }

    public void setShowSampleItems(boolean b) {
        if (b) {
            if (b & this.mySampleItems.size() == 0) {
                this.showSampleItems();
            }
        } else {
            Iterator i = this.mySampleItems.iterator();
            while (i.hasNext()) {
                JGoObject obj = (JGoObject)i.next();
                this.getDocument().removeObject(obj);
            }
            this.mySampleItems.clear();
        }
    }

    public boolean isShowSampleItems() {
        return this.mySampleItems.size() > 0;
    }

    public void layoutItems() {
        boolean vert = this.getOrientation() == 1;
        this.getDocument().setSuspendUpdates(true);
        int wView = this.getExtentSize().width;
        int hView = this.getExtentSize().height;
        int wCell = this.getGridWidth();
        int hCell = this.getGridHeight();
        int xOrig = this.getGridOrigin().x;
        int yOrig = this.getGridOrigin().y;
        int xPnt = xOrig;
        int yPnt = yOrig;
        JGoListPosition pos = this.getDocument().getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getDocument().getObjectAtPos(pos);
            pos = this.getDocument().getNextObjectPosAtTop(pos);
            obj.setTopLeft(xPnt, yPnt);
            if (vert) {
                if (!this.mySingleRowCol && (xPnt += Math.max(wCell, (int)Math.ceil((double)obj.getWidth() / (double)wCell) * wCell)) + obj.getWidth() <= wView) continue;
                xPnt = xOrig;
                yPnt += Math.max(hCell, (int)Math.ceil((double)obj.getHeight() / (double)hCell) * hCell);
                continue;
            }
            if (!this.mySingleRowCol && (yPnt += Math.max(hCell, (int)Math.ceil((double)obj.getHeight() / (double)hCell) * hCell)) + obj.getHeight() <= hView) continue;
            yPnt = yOrig;
            xPnt += Math.max(wCell, (int)Math.ceil((double)obj.getWidth() / (double)wCell) * wCell);
        }
        Dimension docsize = this.getPrintDocumentSize();
        this.getDocument().setDocumentSize(docsize);
        Point doctopleft = this.getPrintDocumentTopLeft();
        this.getDocument().setDocumentTopLeft(doctopleft);
        this.getDocument().setSuspendUpdates(false);
    }

    public void documentChanged(JGoDocumentEvent evt) {
        super.documentChanged(evt);
        if (evt.isBeforeChanging()) {
            return;
        }
        if (evt.getHint() == 202 || evt.getHint() == 204) {
            this.layoutItems();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(50, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(50, 100);
    }

    public void addNotify() {
        super.addNotify();
        this.setDropEnabled(false);
        this.layoutItems();
    }

    public void doLayout() {
        super.doLayout();
        this.layoutItems();
    }

    private void addSampleItem(JGoObject obj) {
        this.getDocument().addObjectAtTail(obj);
        this.mySampleItems.add(obj);
    }

    private void showSampleItems() {
        JGoBasicNode basicNode = new JGoBasicNode("JGoBasicNode");
        basicNode.setBrush(JGoBrush.orange);
        this.addSampleItem(basicNode);
        JGoIconicNode iconicNode = new JGoIconicNode("JGoIconicNode");
        JGoImage nodeicon2 = new JGoImage(new Rectangle(0, 0, 50, 50));
        nodeicon2.loadImage(JGoPalette.class.getResource("images/doc.gif"), true);
        iconicNode.setIcon(nodeicon2);
        this.addSampleItem(iconicNode);
        JGoTextNode textNode = new JGoTextNode("JGoTextNode");
        this.addSampleItem(textNode);
        this.layoutItems();
    }

    public void onGridChange(int what) {
        super.onGridChange(what);
        if (what == 0 || what == 6) {
            this.layoutItems();
        }
    }

    public JGoObject pickObject(Point pointToCheck, boolean selectableOnly) {
        return null;
    }

    public void autoscroll(Point location) {
    }
}

