/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.jboss;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.jboss.JBossIntegrationPanel;

public abstract class AbstractJBossIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.profiler.j2ee.jboss.Bundle");
    private static final String PROFILED_JBOSS_CONSOLE_STRING = messages.getString("JBossIntegrationProvider_ProfiledJbossConsoleString");
    private static final String MANUAL_REMOTE_STEP3_MSG = messages.getString("JBossIntegrationProvider_ManualRemoteStep3Msg");
    private static final String PATH_TO_JVM_DIR_TEXT = messages.getString("JBossIntegrationProvider_PathToJvmDirText");
    private static final String MANUAL_REMOTE_STEP4_MSG = messages.getString("JBossIntegrationProvider_ManualRemoteStep4Msg");
    private static final String MANUAL_REMOTE_STEP5_MSG = messages.getString("JBossIntegrationProvider_ManualRemoteStep5Msg");
    private static final String MANUAL_REMOTE_STEP6_MSG = messages.getString("JBossIntegrationProvider_ManualRemoteStep6Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP1_MSG = messages.getString("JBossIntegrationProvider_ManualDirectDynamicStep1Msg");
    private static final String MANUAL_DIRECT_STEP2_MSG = messages.getString("JBossIntegrationProvider_ManualDirectStep2Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP3_MSG = messages.getString("JBossIntegrationProvider_ManualDirectDynamicStep3Msg");
    private static final String MANUAL_DIRECT_STEP4_MSG = messages.getString("JBossIntegrationProvider_ManualDirectStep4Msg");
    private static final String MANUAL_DYNAMIC_STEP2_MSG = messages.getString("JBossIntegrationProvider_ManualDynamicStep2Msg");
    private static final String MANUAL_DYNAMIC_STEP4_MSG = messages.getString("JBossIntegrationProvider_ManualDynamicStep4Msg");
    private static final String INTEGR_REVIEW_STEP1_MSG = messages.getString("JBossIntegrationProvider_IntegrReviewStep1Msg");
    private static final String INTEGR_REVIEW_STEP2_MSG = messages.getString("JBossIntegrationProvider_IntegrReviewStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP1_DIRECT_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsStep1DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsStep1DynamicMsg");
    private static final String ADDITIONAL_STEPS_STEP2_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP3_DIRECT_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsStep3DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsStep3DynamicPidMsg");
    private static final String ADDITIONAL_STEPS_AUTO_START_MSG = messages.getString("JBossIntegrationProvider_AdditionalStepsAutoStartMsg");
    private static final String DYNAMIC_WARNING_MESSAGE = messages.getString("JBossIntegrationProvider_DynamicWarningMessage");
    private static final String JBOSS_RUN_SCRIPT = "run";
    private static final String JBOSS_HOME_VAR_STRING = "JBOSS_HOME";
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "@if not \"%ECHO%\" == \"\"";
    private static final String INSERTION_POINT_NONWIN_1_STRING = "DIRNAME=`dirname $0`";
    private static final String RUN_MOD_EXT_STRING = "_nbprofiler";
    private SettingsPersistor persistor;

    public AbstractJBossIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep("JBoss provider settings", (WizardScreen)new JBossIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "JBossIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties properties) {
                AbstractJBossIntegrationProvider.this.setTargetJava(properties.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", ""));
                AbstractJBossIntegrationProvider.this.setInstallationPath(properties.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                if (AbstractJBossIntegrationProvider.this.getInstallationPath() == null || AbstractJBossIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractJBossIntegrationProvider.this.setInstallationPath(AbstractJBossIntegrationProvider.this.getDefaultInstallationPath());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties properties = new Properties();
                properties.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractJBossIntegrationProvider.this.getTargetJava());
                properties.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractJBossIntegrationProvider.this.getInstallationPath());
                return properties;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean bl) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        String string = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            integrationHints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DIRECT_MSG, this.getModifiedScriptPath(string, false)));
        } else {
            integrationHints.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG, this.getModifiedScriptPath(string, false), ""));
        }
        integrationHints.addStep(ADDITIONAL_STEPS_STEP2_MSG);
        if (attachSettings.isDirect()) {
            integrationHints.addStep(ADDITIONAL_STEPS_STEP3_DIRECT_MSG);
        } else {
            integrationHints.addStep(ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG);
            integrationHints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        }
        integrationHints.addHint(ADDITIONAL_STEPS_AUTO_START_MSG);
        return integrationHints;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        String string = attachSettings.getHostOS();
        integrationHints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP1_MSG, new File(this.getScriptPath(string, true)), this.getModifiedScriptPath(string, true)));
        integrationHints.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + (attachSettings.isDirect() ? "" + IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort())) + "<br>" : "")));
        return integrationHints;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String string = attachSettings.getHostOS();
        if (attachSettings.isRemote()) {
            return this.getManualRemoteIntegrationStepsInstructions(string, attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.getManualLocalDirectIntegrationStepsInstructions(string, attachSettings);
        }
        return this.getManualLocalDynamicIntegrationStepsInstructions(string, attachSettings);
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public void setTargetJvm(TargetPlatform targetPlatform) {
        if (targetPlatform == null) {
            return;
        }
        this.setTargetJavaHome(targetPlatform.getHomePath());
        this.setTargetJava(targetPlatform.toString());
    }

    public boolean supportsRemote() {
        return true;
    }

    public ValidationResult validateInstallation(String string, String string2) {
        if (!new File(string2).exists()) {
            return new ValidationResult(false, "The installation path doesn't exist");
        }
        if (!new File(this.getJbossScriptPath(string2, string, "", false)).exists()) {
            return new ValidationResult(false, "Invalid installation directory");
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected ScriptHeaderModifier getHeaderModifier(String string) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)string));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)string), IntegrationUtils.getDirectorySeparator((String)string), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_STEP2_MSG, IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort()))));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_DIRECT_STEP4_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addHint(this.EXPORT_SETENV_MSG);
        }
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)string), IntegrationUtils.getDirectorySeparator((String)string), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP2_MSG, IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        integrationHints.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP3_MSG, IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_DYNAMIC_STEP4_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addHint(this.EXPORT_SETENV_MSG);
        }
        integrationHints.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return integrationHints;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String string, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints integrationHints = new IntegrationProvider.IntegrationHints();
        integrationHints.addStep(this.getManualRemoteStep1(string));
        integrationHints.addStep(this.getManualRemoteStep2(string));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_JBOSS_HOME", (String)string), IntegrationUtils.getDirectorySeparator((String)string), IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_MSG, IntegrationUtils.getBatchExtensionString((String)string), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())), IntegrationUtils.getRemoteAbsolutePathHint()));
        integrationHints.addStep(MessageFormat.format(MANUAL_REMOTE_STEP5_MSG, IntegrationUtils.getBatchExtensionString((String)string)));
        integrationHints.addStep(MANUAL_REMOTE_STEP6_MSG);
        integrationHints.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)string)) {
            integrationHints.addHint(this.EXPORT_SETENV_MSG);
        }
        return integrationHints;
    }

    protected String getModifiedScriptPath(String string, boolean bl) {
        return this.getJbossScriptPath(string, RUN_MOD_EXT_STRING, bl);
    }

    protected String getScriptPath(String string, boolean bl) {
        return this.getJbossScriptPath(string, "", bl);
    }

    protected String getWinConsoleString() {
        return PROFILED_JBOSS_CONSOLE_STRING;
    }

    protected void generateCommands(String string, Collection collection) {
        collection.add(this.getModifiedScriptPath(string, false));
    }

    protected void modifyScriptFileForDirectAttach(String string, int n, boolean bl, StringBuffer stringBuffer) {
        String string2 = IntegrationUtils.getLineBreak((String)string);
        int n2 = IntegrationUtils.isWindowsPlatform((String)string) ? 0 : stringBuffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int n3 = IntegrationUtils.isWindowsPlatform((String)string) ? stringBuffer.indexOf(INSERTION_POINT_WIN_1_STRING) : stringBuffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String string3 = "";
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            string3 = string3 + " -Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true";
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            string3 = string3 + " -Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true";
        }
        String string4 = (bl ? IntegrationUtils.getProfilerModifiedReplaceFileHeader((String)string) : IntegrationUtils.getProfilerModifiedFileHeader((String)string)) + string2;
        String string5 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + string2;
        String string6 = IntegrationUtils.getAddProfilerLibrariesToPathString((String)string, (String)this.getTargetJava(), (boolean)false, (boolean)false) + string2;
        String string7 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_OPTS", (String)(IntegrationUtils.getProfilerAgentCommandLineArgs((String)string, (String)this.getTargetJava(), (boolean)false, (int)n) + string3)) + string2;
        int n4 = 0;
        stringBuffer.insert(n2 + n4, string4);
        stringBuffer.insert(n3 + (n4 += string4.length()), string5);
        stringBuffer.insert(n3 + (n4 += string5.length()), string7);
        n4 += string7.length();
    }

    protected void modifyScriptFileForDynamicAttach(String string, int n, boolean bl, StringBuffer stringBuffer) {
        String string2 = IntegrationUtils.getLineBreak((String)string);
        int n2 = IntegrationUtils.isWindowsPlatform((String)string) ? 0 : stringBuffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int n3 = IntegrationUtils.isWindowsPlatform((String)string) ? stringBuffer.indexOf(INSERTION_POINT_WIN_1_STRING) : stringBuffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String string3 = IntegrationUtils.getProfilerModifiedFileHeader((String)string) + string2;
        String string4 = IntegrationUtils.getAssignEnvVariableValueString((String)string, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + string2 + string2;
        int n4 = 0;
        stringBuffer.insert(n2 + n4, string3);
        stringBuffer.insert(n3 + (n4 += string3.length()), string4);
        n4 += string4.length();
    }

    private String getDefaultInstallationPath() {
        String string = "";
        try {
            File file;
            String string2 = System.getenv(JBOSS_HOME_VAR_STRING);
            if (string2 != null && string2.length() > 1 && (file = new File(string2)).exists() && file.isDirectory()) {
                string = string2;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    private String getJbossScriptPath(String string, String string2, boolean bl) {
        return this.getJbossScriptPath(this.getInstallationPath(), string, string2, bl);
    }

    private String getJbossScriptPath(String string, String string2, String string3, boolean bl) {
        String string4 = System.getProperty("file.separator");
        String string5 = IntegrationUtils.getBatchExtensionString((String)string2);
        String string6 = "";
        if (IntegrationUtils.isWindowsPlatform((String)string2)) {
            string6 = "\"";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (!string.endsWith(string4)) {
            stringBuffer.append(string4);
        }
        stringBuffer.append("bin").append(string4).append(JBOSS_RUN_SCRIPT).append(string3).append(string5);
        if (bl) {
            stringBuffer.insert(0, string6);
            stringBuffer.append(string6);
        }
        return stringBuffer.toString();
    }
}

