/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.openide.ErrorManager;

public class SyntaxElement {
    public static final int TYPE_COMMENT = 0;
    public static final int TYPE_DECLARATION = 1;
    public static final int TYPE_ERROR = 2;
    public static final int TYPE_TEXT = 3;
    public static final int TYPE_TAG = 4;
    public static final int TYPE_ENDTAG = 5;
    public static final int TYPE_SCRIPT = 6;
    public static final int TYPE_STYLE = 7;
    public static final int TYPE_UNKNOWN = 8;
    public static final String[] TYPE_NAMES = new String[]{"comment", "declaration", "error", "text", "tag", "endtag", "script", "style", "unknown"};
    private SyntaxElement previous;
    private SyntaxElement next;
    private HTMLSyntaxSupport sup;
    int offset;
    int length;
    int type;

    public SyntaxElement(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, int n3) {
        this.offset = n;
        this.length = n2 - n;
        this.type = n3;
        this.sup = hTMLSyntaxSupport;
    }

    public int getElementOffset() {
        return this.offset;
    }

    public int getElementLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        try {
            return this.sup.getDocument().getText(this.getElementOffset(), this.getElementLength());
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(16, (Throwable)badLocationException);
            return null;
        }
    }

    public SyntaxElement getPrevious() throws BadLocationException {
        if (this.previous == null) {
            this.previous = this.sup.getPreviousElement(this.offset);
            if (this.previous != null) {
                this.previous.next = this;
            }
        }
        return this.previous;
    }

    public SyntaxElement getNext() throws BadLocationException {
        if (this.next == null) {
            this.next = this.sup.getNextElement(this.offset + this.length);
            if (this.next != null) {
                this.next.previous = this;
            }
        }
        return this.next;
    }

    public String toString() {
        String string = this.getType() == 3 ? this.getText() : "";
        return "Element(" + TYPE_NAMES[this.type] + ")[" + this.offset + "," + (this.offset + this.length - 1) + "] \"" + string + "";
    }

    public static class TagAttribute {
        private String name;
        private String value;
        private int nameOffset;
        private int valueOffset;

        public TagAttribute(String string, String string2, int n, int n2) {
            this.name = string;
            this.value = string2;
            this.nameOffset = n;
            this.valueOffset = n2;
        }

        public String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        void setValue(String string) {
            this.value = string;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        void setNameOffset(int n) {
            this.nameOffset = n;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        void setValueOffset(int n) {
            this.valueOffset = n;
        }

        public String toString() {
            return "TagAttribute[name=" + this.getName() + "; value=" + this.getValue() + "; nameOffset=" + this.getNameOffset() + "; valueOffset=" + this.getValueOffset() + "]";
        }

        public boolean equals(Object object) {
            if (!(object instanceof TagAttribute)) {
                return false;
            }
            return this.getName().equals(((TagAttribute)object).getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tag
    extends Named {
        private List<TagAttribute> attribs;
        private boolean empty = false;

        public Tag(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, List<TagAttribute> list) {
            this(hTMLSyntaxSupport, n, n2, string, list, false);
        }

        public Tag(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, List list, boolean bl) {
            super(hTMLSyntaxSupport, n, n2, 4, string);
            this.attribs = list;
            this.empty = bl;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public List<TagAttribute> getAttributes() {
            return this.attribs;
        }

        public TagAttribute getAttribute(String string) {
            return this.getAttribute(string, true);
        }

        public TagAttribute getAttribute(String string, boolean bl) {
            for (TagAttribute tagAttribute : this.attribs) {
                if (!tagAttribute.getName().equals(string)) continue;
                return tagAttribute;
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" - {");
            Iterator<TagAttribute> iterator = this.attribs.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            if (this.isEmpty()) {
                stringBuffer.append(" (EMPTY TAG)");
            }
            return stringBuffer.toString();
        }
    }

    public static class Named
    extends SyntaxElement {
        String name;

        public Named(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, int n3, String string) {
            super(hTMLSyntaxSupport, n, n2, n3);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return super.toString() + " - \"" + this.name + '\"';
        }
    }

    public static class Declaration
    extends SyntaxElement {
        private String root;
        private String publicID;
        private String file;

        public Declaration(HTMLSyntaxSupport hTMLSyntaxSupport, int n, int n2, String string, String string2, String string3) {
            super(hTMLSyntaxSupport, n, n2, 1);
            this.root = string;
            this.publicID = string2;
            this.file = string3;
        }

        public String getRootElement() {
            return this.root;
        }

        public String getPublicIdentifier() {
            return this.publicID;
        }

        public String getDoctypeFile() {
            return this.file;
        }
    }
}

