/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacrosStorage
implements StorageDescription<String, MacroDescription> {
    private static final Logger LOG = Logger.getLogger(MacrosStorage.class.getName());
    public static final String ID = "Macros";
    private static final String E_ROOT = "editor-macros";
    private static final String E_MACRO = "macro";
    private static final String E_DESCRIPTION = "description";
    private static final String E_CODE = "code";
    private static final String E_SHORTCUT = "shortcut";
    private static final String A_NAME = "name";
    private static final String A_DESCRIPTION_ID = "descriptionId";
    private static final String A_KEYSTROKES = "keystrokes";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Macros settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorMacros-1_1.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-macrosettings";

    public String getId() {
        return ID;
    }

    public boolean isUsingProfiles() {
        return false;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getLegacyFileName() {
        return "macros.xml";
    }

    public StorageReader<String, MacroDescription> createReader(FileObject fileObject, String string) {
        if (MIME_TYPE.equals(fileObject.getMIMEType())) {
            return new Reader(fileObject, string);
        }
        return new LegacyReader(fileObject, string);
    }

    public StorageWriter<String, MacroDescription> createWriter(FileObject fileObject, String string) {
        return new Writer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Writer
    extends StorageWriter<String, MacroDescription> {
        public Document getDocument() {
            Element element;
            Document document = XMLUtil.createDocument((String)MacrosStorage.E_ROOT, null, (String)MacrosStorage.PUBLIC_ID, (String)MacrosStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(MacrosStorage.E_ROOT).item(0);
            for (Object object : this.getAdded().values()) {
                String object22;
                Element element2;
                element = document.createElement(MacrosStorage.E_MACRO);
                node.appendChild(element);
                element.setAttribute(MacrosStorage.A_NAME, ((MacroDescription)object).getName());
                List<? extends MultiKeyBinding> list = ((MacroDescription)object).getShortcuts();
                if (list != null && list.size() > 0) {
                    for (MultiKeyBinding multiKeyBinding : list) {
                        element2 = document.createElement(MacrosStorage.E_SHORTCUT);
                        element2.setAttribute(MacrosStorage.A_KEYSTROKES, StorageSupport.keyStrokesToString((Collection)multiKeyBinding.getKeyStrokeList(), (boolean)true));
                        element.appendChild(element2);
                    }
                }
                element.setAttribute(MacrosStorage.A_XML_SPACE, MacrosStorage.V_PRESERVE);
                String string = ((MacroDescription)object).getCode();
                if (string.length() > 0) {
                    Element element3 = document.createElement(MacrosStorage.E_CODE);
                    element3.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)string)));
                    element.appendChild(element3);
                }
                if ((object22 = ((MacroDescription)object).getDescription()) == null || object22.length() <= 0) continue;
                element2 = document.createElement(MacrosStorage.E_DESCRIPTION);
                element2.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)object22)));
                element.appendChild(element2);
            }
            for (Object object : this.getRemoved()) {
                element = document.createElement(MacrosStorage.E_MACRO);
                node.appendChild(element);
                element.setAttribute(MacrosStorage.A_NAME, (String)object);
                element.setAttribute(MacrosStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return document;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LegacyReader
    extends MacrosReader {
        private static final String EL_ROOT = "macros";
        private static final String EL_MACRO = "macro";
        private static final String AL_NAME = "name";
        private static final String AL_REMOVE = "remove";
        private Map<String, MacroDescription> macrosMap = new HashMap<String, MacroDescription>();
        private Set<String> removedMacros = new HashSet<String>();
        private String name = null;
        private StringBuilder text = null;

        public LegacyReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, MacroDescription> getAdded() {
            return this.macrosMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedMacros;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals("macro")) {
                boolean bl = Boolean.valueOf(attributes.getValue("remove"));
                if (bl) {
                    String string4 = attributes.getValue("name");
                    this.removedMacros.add(string4);
                    this.name = null;
                    this.text = null;
                } else {
                    this.name = attributes.getValue("name");
                    this.text = new StringBuilder();
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals("macro") && this.name != null) {
                MacroDescription macroDescription = new MacroDescription(this.name, CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.text), null, Collections.emptyList());
                this.macrosMap.put(this.name, macroDescription);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reader
    extends MacrosReader {
        private Map<String, MacroDescription> macrosMap = new HashMap<String, MacroDescription>();
        private Set<String> removedMacros = new HashSet<String>();
        private String name = null;
        private String description = null;
        private String code = null;
        private List<MultiKeyBinding> shortcuts = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        public Reader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, MacroDescription> getAdded() {
            return this.macrosMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedMacros;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
                if (this.insideCdata) {
                    this.cdataText.append(cArray, n, n2);
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(MacrosStorage.E_ROOT)) {
                if (string3.equals(MacrosStorage.E_MACRO)) {
                    boolean bl = Boolean.valueOf(attributes.getValue(MacrosStorage.A_REMOVE));
                    this.name = null;
                    this.description = null;
                    this.shortcuts = null;
                    this.text = null;
                    this.cdataText = null;
                    if (bl) {
                        String string4 = attributes.getValue(MacrosStorage.A_NAME);
                        this.removedMacros.add(string4);
                    } else {
                        String string5;
                        this.name = attributes.getValue(MacrosStorage.A_NAME);
                        this.description = attributes.getValue(MacrosStorage.A_DESCRIPTION_ID);
                        if (this.description != null && (string5 = StorageSupport.getLocalizingBundleMessage((FileObject)this.getProcessedFile(), (String)this.description, null)) != null) {
                            this.description = string5;
                        }
                        this.shortcuts = new ArrayList<MultiKeyBinding>();
                    }
                } else if (this.name != null && string3.equals(MacrosStorage.E_CODE)) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                } else if (this.name != null && string3.equals(MacrosStorage.E_DESCRIPTION)) {
                    this.text = new StringBuilder();
                    this.cdataText = new StringBuilder();
                    this.insideCdata = false;
                } else if (this.name != null && string3.equals(MacrosStorage.E_SHORTCUT)) {
                    int n;
                    String string6 = attributes.getValue(MacrosStorage.A_KEYSTROKES);
                    if (this.isModuleFile() && this.isDefaultProfile() && string6 != null && string6.length() > 0 && (n = string6.indexOf(45)) != -1 && (string6.charAt(0) == 'A' || string6.charAt(0) == 'C')) {
                        LOG.warning("The keybinding '" + string6 + "' in " + this.getProcessedFile().getPath() + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                    }
                    KeyStroke[] keyStrokeArray = StorageSupport.stringToKeyStrokes((String)string6, (boolean)true);
                    this.shortcuts.add(new MultiKeyBinding(keyStrokeArray, "macro-" + this.name));
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(MacrosStorage.E_ROOT)) {
                if (string3.equals(MacrosStorage.E_MACRO)) {
                    if (this.name != null) {
                        MacroDescription macroDescription = new MacroDescription(this.name, this.code == null ? "" : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.code), this.description == null ? null : CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.description), Collections.unmodifiableList(this.shortcuts));
                        this.macrosMap.put(this.name, macroDescription);
                    }
                } else if (string3.equals(MacrosStorage.E_CODE)) {
                    if (this.text != null) {
                        this.code = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                    }
                } else if (string3.equals(MacrosStorage.E_DESCRIPTION) && this.text != null) {
                    if (this.cdataText.length() > 0) {
                        this.description = this.cdataText.toString();
                    } else if (this.text.length() > 0) {
                        this.description = this.text.toString();
                    }
                }
            }
        }

        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MacrosReader
    extends StorageReader<String, MacroDescription> {
        protected MacrosReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        public abstract Map<String, MacroDescription> getAdded();

        public abstract Set<String> getRemoved();
    }
}

