/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.macros.storage.ui.MacrosPanel;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MacroDialogSupport {
    private static final Logger LOG = Logger.getLogger(MacroDialogSupport.class.getName());

    private MacroDialogSupport() {
    }

    public static MacroDescription findMacro(MimePath mimePath, String string) {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Macros");
        MacroDescription macroDescription = null;
        try {
            macroDescription = (MacroDescription)editorSettingsStorage.load(mimePath, null, false).get(string);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        if (macroDescription == null) {
            try {
                macroDescription = (MacroDescription)editorSettingsStorage.load(MimePath.EMPTY, null, false).get(string);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
        return macroDescription;
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet<String> runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String string) {
            super("macro-" + string);
            this.macroName = string;
        }

        protected void error(JTextComponent jTextComponent, String string, Object ... objectArray) {
            try {
                String string2 = NbBundle.getMessage(RunMacroAction.class, (String)string, (Object[])objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                String string3 = "Error in macro: " + string + "; macroName = '" + this.macroName + "'";
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MacroDialogSupport.class, (String)"MSG_InvalidMacro", (Object)this.macroName));
            Toolkit.getDefaultToolkit().beep();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                return;
            }
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (baseDocument == null) {
                return;
            }
            MimePath mimePath = MimePath.parse((String)NbEditorUtilities.getMimeType((JTextComponent)jTextComponent));
            MacroDescription macroDescription = MacroDialogSupport.findMacro(mimePath, this.macroName);
            if (macroDescription == null) {
                this.error(jTextComponent, "macro-not-found", this.macroName);
                return;
            }
            if (!runningActions.add(this.macroName)) {
                this.error(jTextComponent, "loop", this.macroName);
                return;
            }
            try {
                this.runMacro(jTextComponent, baseDocument, baseKit, macroDescription.getCode());
            }
            finally {
                runningActions.remove(this.macroName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runMacro(JTextComponent jTextComponent, BaseDocument baseDocument, BaseKit baseKit, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            baseDocument.atomicLock();
            try {
                for (int i = 0; i < n; ++i) {
                    Object object;
                    Object object2;
                    if (Character.isWhitespace(cArray[i])) continue;
                    if (cArray[i] == '\"') {
                        while (++i < n && cArray[i] != '\"') {
                            char c = cArray[i];
                            if (c == '\\') {
                                if (++i >= n) {
                                    this.error(jTextComponent, "macro-malformed", this.macroName);
                                    return;
                                }
                                c = cArray[i];
                                if (c != '\"' && c != '\\') {
                                    this.error(jTextComponent, "macro-malformed", this.macroName);
                                    return;
                                }
                            }
                            if ((object2 = jTextComponent.getKeymap().getDefaultAction()) == null) continue;
                            object = new ActionEvent(jTextComponent, 0, new String(new char[]{c}));
                            if (object2 instanceof BaseAction) {
                                ((BaseAction)object2).updateComponent(jTextComponent);
                                ((BaseAction)object2).actionPerformed((ActionEvent)object, jTextComponent);
                                continue;
                            }
                            object2.actionPerformed((ActionEvent)object);
                        }
                        continue;
                    }
                    stringBuffer.setLength(0);
                    while (i < n && !Character.isWhitespace(cArray[i])) {
                        char c;
                        if ((c = cArray[i++]) == '\\') {
                            if (i >= n) {
                                this.error(jTextComponent, "macro-malformed", this.macroName);
                                return;
                            }
                            if ((c = cArray[i++]) != '\\' && !Character.isWhitespace(c)) {
                                this.error(jTextComponent, "macro-malformed", this.macroName);
                                return;
                            }
                        }
                        stringBuffer.append(c);
                    }
                    Action action = baseKit.getActionByName(stringBuffer.toString());
                    if (action != null) {
                        object2 = new ActionEvent(jTextComponent, 0, "");
                        if (action instanceof BaseAction) {
                            ((BaseAction)action).updateComponent(jTextComponent);
                            ((BaseAction)action).actionPerformed((ActionEvent)object2, jTextComponent);
                        } else {
                            action.actionPerformed((ActionEvent)object2);
                        }
                        if (!"insert-break".equals(stringBuffer.toString())) continue;
                        object = jTextComponent.getKeymap().getDefaultAction();
                        ActionEvent actionEvent = new ActionEvent(jTextComponent, 0, new String(new byte[]{10}));
                        if (object instanceof BaseAction) {
                            ((BaseAction)object).updateComponent(jTextComponent);
                            ((BaseAction)object).actionPerformed(actionEvent, jTextComponent);
                            continue;
                        }
                        object.actionPerformed(actionEvent);
                        continue;
                    }
                    this.error(jTextComponent, "macro-unknown-action", this.macroName, stringBuffer.toString());
                    return;
                }
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    public static final class StopMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/macros/stop_macro_recording.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                final String string = this.stopRecording(jTextComponent);
                if (string == null) {
                    jTextComponent.getToolkit().beep();
                } else {
                    final MacrosPanel macrosPanel = new MacrosPanel(Lookup.getDefault());
                    macrosPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
                    macrosPanel.addAncestorListener(new AncestorListener(){

                        public void ancestorAdded(AncestorEvent ancestorEvent) {
                            macrosPanel.forceAddMacro(string);
                        }

                        public void ancestorRemoved(AncestorEvent ancestorEvent) {
                        }

                        public void ancestorMoved(AncestorEvent ancestorEvent) {
                        }
                    });
                    macrosPanel.getModel().load();
                    final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)macrosPanel, NbBundle.getMessage(MacroDialogSupport.class, (String)"Macros_Dialog_title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                    dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
                    dialogDescriptor.setValid(false);
                    macrosPanel.getModel().addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                            if (propertyChangeEvent.getPropertyName() == null || "changed".equals(propertyChangeEvent.getPropertyName())) {
                                dialogDescriptor.setValid(macrosPanel.getModel().isChanged());
                            }
                        }
                    });
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                    if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                        macrosPanel.getModel().save();
                    }
                }
            }
        }

        private String stopRecording(JTextComponent jTextComponent) {
            try {
                Method method = BaseAction.class.getDeclaredMethod("stopRecording", JTextComponent.class);
                method.setAccessible(true);
                return (String)method.invoke((Object)this, jTextComponent);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call BaseAction.stopRecording", exception);
                return null;
            }
        }
    }

    public static class StartMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/macros/start_macro_recording.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && !this.startRecording(jTextComponent)) {
                jTextComponent.getToolkit().beep();
            }
        }

        private boolean startRecording(JTextComponent jTextComponent) {
            try {
                Method method = BaseAction.class.getDeclaredMethod("startRecording", JTextComponent.class);
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)this, jTextComponent);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call BaseAction.startRecording", exception);
                return false;
            }
        }
    }
}

